/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.gjgr.pig.chivalrous.db.AbstractSqlRunner;
import org.gjgr.pig.chivalrous.db.DbUtil;
import org.gjgr.pig.chivalrous.db.SqlConnRunner;
import org.gjgr.pig.chivalrous.db.dialect.Dialect;
import org.gjgr.pig.chivalrous.db.dialect.DialectFactory;

public class SqlRunner
extends AbstractSqlRunner {
    private DataSource ds;

    public SqlRunner(DataSource ds) {
        this(ds, DialectFactory.newDialect(ds));
    }

    public SqlRunner(DataSource ds, Dialect dialect) {
        this.runner = new SqlConnRunner(dialect);
        this.ds = ds;
    }

    public SqlRunner(DataSource ds, String driverClassName) {
        this.runner = new SqlConnRunner(driverClassName);
        this.ds = ds;
    }

    public static SqlRunner create(DataSource ds) {
        return ds == null ? null : new SqlRunner(ds);
    }

    public static SqlRunner create(DataSource ds, Dialect dialect) {
        return new SqlRunner(ds, dialect);
    }

    public static SqlRunner create(DataSource ds, String driverClassName) {
        return new SqlRunner(ds, DialectFactory.newDialect(driverClassName));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    @Override
    public void closeConnection(Connection conn) {
        DbUtil.close(conn);
    }

    @Override
    public SqlConnRunner getRunner() {
        return this.runner;
    }

    @Override
    public void setRunner(SqlConnRunner runner) {
        this.runner = runner;
    }
}

