/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.dialect;

import java.sql.Connection;
import javax.sql.DataSource;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.db.DbUtil;
import org.gjgr.pig.chivalrous.db.dialect.Dialect;
import org.gjgr.pig.chivalrous.db.dialect.impl.AnsiSqlDialect;
import org.gjgr.pig.chivalrous.db.dialect.impl.MysqlDialect;
import org.gjgr.pig.chivalrous.db.dialect.impl.OracleDialect;
import org.gjgr.pig.chivalrous.db.dialect.impl.PostgresqlDialect;
import org.gjgr.pig.chivalrous.db.dialect.impl.Sqlite3Dialect;

public class DialectFactory {
    public static final String DRIVER_MYSQL = "com.mysql.jdbc.Driver";
    public static final String DRIVER_ORACLE = "oracle.jdbc.driver.OracleDriver";
    public static final String DRIVER_POSTGRESQL = "org.postgresql.Driver";
    public static final String DRIVER_SQLLITE3 = "org.sqlite.JDBC";

    private DialectFactory() {
    }

    public static Dialect newDialect(String driverName) {
        if (StringCommand.isNotBlank((CharSequence)driverName)) {
            if (DRIVER_MYSQL.equalsIgnoreCase(driverName)) {
                return new MysqlDialect();
            }
            if (DRIVER_ORACLE.equalsIgnoreCase(driverName)) {
                return new OracleDialect();
            }
            if (DRIVER_SQLLITE3.equalsIgnoreCase(driverName)) {
                return new Sqlite3Dialect();
            }
            if (DRIVER_POSTGRESQL.equalsIgnoreCase(driverName)) {
                return new PostgresqlDialect();
            }
        }
        return new AnsiSqlDialect();
    }

    public static Dialect newDialect(DataSource ds) {
        return DialectFactory.newDialect(DbUtil.identifyDriver(ds));
    }

    public static Dialect newDialect(Connection conn) {
        return DialectFactory.newDialect(DbUtil.identifyDriver(conn));
    }
}

