/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.dialect.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.db.DbUtil;
import org.gjgr.pig.chivalrous.db.Entity;
import org.gjgr.pig.chivalrous.db.Page;
import org.gjgr.pig.chivalrous.db.dialect.Dialect;
import org.gjgr.pig.chivalrous.db.dialect.DialectName;
import org.gjgr.pig.chivalrous.db.sql.Condition;
import org.gjgr.pig.chivalrous.db.sql.LogicalOperator;
import org.gjgr.pig.chivalrous.db.sql.Order;
import org.gjgr.pig.chivalrous.db.sql.Query;
import org.gjgr.pig.chivalrous.db.sql.SqlBuilder;
import org.gjgr.pig.chivalrous.db.sql.Wrapper;

public class AnsiSqlDialect
implements Dialect {
    protected Wrapper wrapper = new Wrapper();

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public PreparedStatement psForInsert(Connection conn, Entity entity) throws SQLException {
        SqlBuilder insert = SqlBuilder.create(this.wrapper).insert(entity, this.dialectName());
        PreparedStatement ps = conn.prepareStatement(insert.build(), 1);
        DbUtil.fillParams(ps, insert.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForDelete(Connection conn, Query query) throws SQLException {
        if (null == query) {
            throw new NullPointerException("query is null !");
        }
        Object[] where = query.getWhere();
        if (ArrayCommand.isEmpty((Object[])where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepared statement for delete everything.");
        }
        SqlBuilder delete = SqlBuilder.create(this.wrapper).delete(query.getFirstTableName()).where(LogicalOperator.AND, (Condition[])where);
        PreparedStatement ps = conn.prepareStatement(delete.build());
        DbUtil.fillParams(ps, delete.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForUpdate(Connection conn, Entity entity, Query query) throws SQLException {
        if (null == query) {
            throw new NullPointerException("query is null !");
        }
        Object[] where = query.getWhere();
        if (ArrayCommand.isEmpty((Object[])where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepared statement for update everything.");
        }
        SqlBuilder update = SqlBuilder.create(this.wrapper).update(entity).where(LogicalOperator.AND, (Condition[])where);
        PreparedStatement ps = conn.prepareStatement(update.build());
        DbUtil.fillParams(ps, update.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForFind(Connection conn, Query query) throws SQLException {
        if (null == query) {
            throw new NullPointerException("query is null !");
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).query(query);
        PreparedStatement ps = conn.prepareStatement(find.build());
        DbUtil.fillParams(ps, find.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Query query) throws SQLException {
        Order[] orders;
        SqlBuilder find = SqlBuilder.create(this.wrapper).select(query.getFields()).from(query.getTableNames()).where(LogicalOperator.AND, query.getWhere());
        Page page = query.getPage();
        if (null != page && null != (orders = page.getOrders())) {
            find.orderBy(orders);
        }
        find.append(" limit ").append(page.getNumPerPage()).append(" offset ").append(page.getStartPosition());
        PreparedStatement ps = conn.prepareStatement(find.build());
        DbUtil.fillParams(ps, find.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForCount(Connection conn, Query query) throws SQLException {
        query.setFields(CollectionCommand.newArrayList((Object[])new String[]{"count(1)"}));
        return this.psForFind(conn, query);
    }

    @Override
    public DialectName dialectName() {
        return DialectName.ANSI;
    }
}

