/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.dialect.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.db.DbRuntimeException;
import org.gjgr.pig.chivalrous.db.DbUtil;
import org.gjgr.pig.chivalrous.db.Page;
import org.gjgr.pig.chivalrous.db.dialect.DialectName;
import org.gjgr.pig.chivalrous.db.dialect.impl.AnsiSqlDialect;
import org.gjgr.pig.chivalrous.db.sql.LogicalOperator;
import org.gjgr.pig.chivalrous.db.sql.Order;
import org.gjgr.pig.chivalrous.db.sql.Query;
import org.gjgr.pig.chivalrous.db.sql.SqlBuilder;
import org.gjgr.pig.chivalrous.db.sql.Wrapper;

public class MysqlDialect
extends AnsiSqlDialect {
    public MysqlDialect() {
        this.wrapper = new Wrapper(Character.valueOf('`'));
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Query query) throws SQLException {
        Order[] orders;
        if (query == null || StringCommand.hasBlank((CharSequence[])query.getTableNames())) {
            throw new DbRuntimeException("Table name is null !");
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).select(query.getFields()).from(query.getTableNames()).where(LogicalOperator.AND, query.getWhere());
        Page page = query.getPage();
        if (null != page && null != (orders = page.getOrders())) {
            find.orderBy(orders);
        }
        find.append(" LIMIT ").append(page.getStartPosition()).append(", ").append(page.getNumPerPage());
        PreparedStatement ps = conn.prepareStatement(find.build());
        DbUtil.fillParams(ps, find.getParamValueArray());
        return ps;
    }

    @Override
    public DialectName dialectName() {
        return DialectName.MYSQL;
    }
}

