/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.ds;

import javax.sql.DataSource;
import org.gjgr.pig.chivalrous.core.log.Log;
import org.gjgr.pig.chivalrous.core.log.LogFactory;
import org.gjgr.pig.chivalrous.core.setting.Setting;
import org.gjgr.pig.chivalrous.db.ds.c3p0.C3p0DSFactory;
import org.gjgr.pig.chivalrous.db.ds.druid.DruidDSFactory;
import org.gjgr.pig.chivalrous.db.ds.hikari.HikariDSFactory;
import org.gjgr.pig.chivalrous.db.ds.pooled.PooledDSFactory;
import org.gjgr.pig.chivalrous.db.ds.tomcat.TomcatDSFactory;

public abstract class DSFactory {
    protected static final String DEFAULT_DB_SETTING_PATH = "config/db.setting";
    private static final Log log = LogFactory.get();
    private static final Object lock = new Object();
    private static volatile DSFactory currentDSFactory;
    protected Setting setting;
    private String dataSourceName;

    public DSFactory(String dataSourceName, Setting setting) {
        this.dataSourceName = dataSourceName;
        if (null == setting) {
            setting = new Setting(DEFAULT_DB_SETTING_PATH, true);
        }
        this.setting = setting;
    }

    public static DataSource get() {
        return DSFactory.get(null);
    }

    public static DataSource get(String group) {
        return DSFactory.get(null, group);
    }

    public static DataSource get(Setting dbSetting, String group) {
        return DSFactory.getCurrentDSFactory(dbSetting).getDataSource(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSFactory getCurrentDSFactory(Setting setting) {
        if (null == currentDSFactory) {
            Object object = lock;
            synchronized (object) {
                if (null == currentDSFactory) {
                    currentDSFactory = DSFactory.detectDSFactory(setting);
                }
            }
        }
        return currentDSFactory;
    }

    public static synchronized DSFactory setCurrentDSFactory(DSFactory dsFactory) {
        if (null != currentDSFactory) {
            if (currentDSFactory.equals(dsFactory)) {
                return currentDSFactory;
            }
            currentDSFactory.destroy();
        }
        log.debug("Custom use [{}] datasource.", new Object[]{dsFactory.dataSourceName});
        currentDSFactory = dsFactory;
        return currentDSFactory;
    }

    private static DSFactory detectDSFactory(Setting setting) {
        DSFactory dsFactory;
        try {
            dsFactory = new HikariDSFactory(setting);
        }
        catch (NoClassDefFoundError e1) {
            try {
                dsFactory = new DruidDSFactory(setting);
            }
            catch (NoClassDefFoundError e2) {
                try {
                    dsFactory = new TomcatDSFactory(setting);
                }
                catch (NoClassDefFoundError e3) {
                    try {
                        dsFactory = new C3p0DSFactory(setting);
                    }
                    catch (NoClassDefFoundError e5) {
                        dsFactory = new PooledDSFactory(setting);
                    }
                }
            }
        }
        log.debug("Use [{}] DataSource As Default", new Object[]{dsFactory.dataSourceName});
        return dsFactory;
    }

    public DataSource getDataSource() {
        return this.getDataSource("");
    }

    public abstract DataSource getDataSource(String var1);

    public void close() {
        this.close("");
    }

    public abstract void close(String var1);

    public abstract void destroy();

    protected void checkCPExist(Class<? extends DataSource> dsClass) {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataSourceName == null ? 0 : this.dataSourceName.hashCode());
        result = 31 * result + (this.setting == null ? 0 : this.setting.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DSFactory other = (DSFactory)obj;
        if (this.dataSourceName == null ? other.dataSourceName != null : !this.dataSourceName.equals(other.dataSourceName)) {
            return false;
        }
        return !(this.setting == null ? other.setting != null : !this.setting.equals((Object)other.setting));
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (null != currentDSFactory) {
                    currentDSFactory.destroy();
                    log.debug("DataSource: [{}] destroyed.", new Object[]{currentDSFactory.dataSourceName});
                }
            }
        });
    }
}

