/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.ds;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;
import org.gjgr.pig.chivalrous.core.exceptions.NotInitedException;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.Log;
import org.gjgr.pig.chivalrous.core.log.StaticLog;
import org.gjgr.pig.chivalrous.core.net.NetworkCommand;
import org.gjgr.pig.chivalrous.core.setting.Setting;
import org.gjgr.pig.chivalrous.db.DbRuntimeException;

public class MongoDS
implements Closeable {
    public static final String MONGO_CONFIG_PATH = "config/mongo.setting";
    private static final Log log = StaticLog.get();
    private static final String GROUP_SEPRATER = ",";
    private static Map<String, MongoDS> dsMap = new HashMap<String, MongoDS>();
    private Setting setting;
    private String[] groups;
    private ServerAddress serverAddress;
    private MongoClient mongo;

    public MongoDS(String host, int port) {
        this.serverAddress = this.createServerAddress(host, port);
        this.initSingle();
    }

    public MongoDS(Setting mongoSetting, String host, int port) {
        this.setting = mongoSetting;
        this.serverAddress = this.createServerAddress(host, port);
        this.initSingle();
    }

    public MongoDS(String ... groups) {
        this.groups = groups;
        this.init();
    }

    public MongoDS(Setting mongoSetting, String ... groups) {
        if (mongoSetting == null) {
            throw new DbRuntimeException("Mongo setting is null!");
        }
        this.setting = mongoSetting;
        this.groups = groups;
        this.init();
    }

    public static MongoDS getDS(String host, int port) {
        String key = host + ":" + port;
        MongoDS ds = dsMap.get(key);
        if (null == ds) {
            ds = new MongoDS(host, port);
            dsMap.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(String ... groups) {
        String key = ArrayCommand.join((Object[])groups, (String)GROUP_SEPRATER);
        MongoDS ds = dsMap.get(key);
        if (null == ds) {
            ds = new MongoDS(groups);
            dsMap.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(Collection<String> groups) {
        return MongoDS.getDS(groups.toArray(new String[groups.size()]));
    }

    public static MongoDS getDS(Setting setting, String ... groups) {
        String key = setting.getSettingPath() + GROUP_SEPRATER + ArrayCommand.join((Object[])groups, (String)GROUP_SEPRATER);
        MongoDS ds = dsMap.get(key);
        if (null == ds) {
            ds = new MongoDS(setting, groups);
            dsMap.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(Setting setting, Collection<String> groups) {
        return MongoDS.getDS(setting, groups.toArray(new String[groups.size()]));
    }

    public static void closeAll() {
        if (CollectionCommand.isNotEmpty(dsMap)) {
            for (MongoDS ds : dsMap.values()) {
                ds.close();
            }
            dsMap.clear();
        }
    }

    public void init() {
        if (this.groups != null && this.groups.length > 1) {
            this.initCloud();
        } else {
            this.initSingle();
        }
    }

    public synchronized void initSingle() {
        if (this.setting == null) {
            try {
                this.setting = new Setting(MONGO_CONFIG_PATH, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String group = "";
        if (this.serverAddress == null) {
            if (this.groups != null && this.groups.length == 1) {
                group = this.groups[0];
            }
            this.serverAddress = this.createServerAddress(group);
        }
        try {
            this.mongo = new MongoClient(this.serverAddress, this.buildMongoClientOptions(group));
        }
        catch (Exception e) {
            throw new DbRuntimeException(StringCommand.format((String)"Init MongoDB pool with connection to [{}] error!", (Object[])new Object[]{this.serverAddress}), e);
        }
        log.info("Init MongoDB pool with connection to [{}]", new Object[]{this.serverAddress});
    }

    public synchronized void initCloud() {
        if (this.groups == null || this.groups.length == 0) {
            throw new DbRuntimeException("Please give replication set groups!");
        }
        if (this.setting == null) {
            this.setting = new Setting(MONGO_CONFIG_PATH, true);
        }
        ArrayList<ServerAddress> addrList = new ArrayList<ServerAddress>();
        for (String group : this.groups) {
            addrList.add(this.createServerAddress(group));
        }
        try {
            this.mongo = new MongoClient(addrList, this.buildMongoClientOptions(""));
        }
        catch (Exception e) {
            log.error((Throwable)e, "Init MongoDB connection error!", new Object[0]);
            return;
        }
        log.info("Init MongoDB cloud Set pool with connection to {}", new Object[]{addrList});
    }

    public void setSetting(Setting setting) {
        this.setting = setting;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public MongoDatabase getDb(String dbName) {
        return this.mongo.getDatabase(dbName);
    }

    public MongoCollection<Document> getCollection(String dbName, String collectionName) {
        return this.getDb(dbName).getCollection(collectionName);
    }

    @Override
    public void close() {
        this.mongo.close();
    }

    private ServerAddress createServerAddress(String group) {
        String tmpHost;
        if (this.setting == null) {
            throw new DbRuntimeException(StringCommand.format((String)"Please indicate setting file or create default [{}], and define group [{}]", (Object[])new Object[]{MONGO_CONFIG_PATH, group}));
        }
        if (group == null) {
            group = "";
        }
        if (StringCommand.isBlank((CharSequence)(tmpHost = this.setting.getByGroup("host", group)))) {
            throw new NotInitedException("Host name is empy of group: " + group);
        }
        int defaultPort = this.setting.getInt("port", group, Integer.valueOf(27017));
        return new ServerAddress(NetworkCommand.buildInetSocketAddress((String)tmpHost, (int)defaultPort));
    }

    private ServerAddress createServerAddress(String host, int port) {
        return new ServerAddress(host, port);
    }

    private MongoClientOptions buildMongoClientOptions(String group) {
        return this.buildMongoClientOptions(MongoClientOptions.builder(), group).build();
    }

    private MongoClientOptions.Builder buildMongoClientOptions(MongoClientOptions.Builder builder, String group) {
        if (this.setting == null) {
            return builder;
        }
        group = group == null ? "" : group + ".";
        Integer connectionsPerHost = this.setting.getInt((Object)(group + "connectionsPerHost"));
        if (!StringCommand.isBlank((CharSequence)group) && connectionsPerHost == null) {
            connectionsPerHost = this.setting.getInt((Object)"connectionsPerHost");
        }
        if (connectionsPerHost != null) {
            builder.connectionsPerHost(connectionsPerHost.intValue());
            log.debug("MongoDB connectionsPerHost: {}", new Object[]{connectionsPerHost});
        }
        Integer threadsAllowedToBlockForConnectionMultiplier = this.setting.getInt((Object)(group + "threadsAllowedToBlockForConnectionMultiplier"));
        if (!StringCommand.isBlank((CharSequence)group) && threadsAllowedToBlockForConnectionMultiplier == null) {
            threadsAllowedToBlockForConnectionMultiplier = this.setting.getInt((Object)"threadsAllowedToBlockForConnectionMultiplier");
        }
        if (threadsAllowedToBlockForConnectionMultiplier != null) {
            builder.threadsAllowedToBlockForConnectionMultiplier(threadsAllowedToBlockForConnectionMultiplier.intValue());
            log.debug("MongoDB threadsAllowedToBlockForConnectionMultiplier: {}", new Object[]{threadsAllowedToBlockForConnectionMultiplier});
        }
        Integer connectTimeout = this.setting.getInt((Object)(group + "connectTimeout"));
        if (!StringCommand.isBlank((CharSequence)group) && connectTimeout == null) {
            this.setting.getInt((Object)"connectTimeout");
        }
        if (connectTimeout != null) {
            builder.connectTimeout(connectTimeout.intValue());
            log.debug("MongoDB connectTimeout: {}", new Object[]{connectTimeout});
        }
        Integer socketTimeout = this.setting.getInt((Object)(group + "socketTimeout"));
        if (!StringCommand.isBlank((CharSequence)group) && socketTimeout == null) {
            this.setting.getInt((Object)"socketTimeout");
        }
        if (socketTimeout != null) {
            builder.socketTimeout(socketTimeout.intValue());
            log.debug("MongoDB socketTimeout: {}", new Object[]{socketTimeout});
        }
        Boolean socketKeepAlive = this.setting.getBool((Object)(group + "socketKeepAlive"));
        if (!StringCommand.isBlank((CharSequence)group) && socketKeepAlive == null) {
            socketKeepAlive = this.setting.getBool((Object)"socketKeepAlive");
        }
        if (socketKeepAlive != null) {
            builder.socketKeepAlive(socketKeepAlive.booleanValue());
            log.debug("MongoDB socketKeepAlive: {}", new Object[]{socketKeepAlive});
        }
        return builder;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MongoDS.closeAll();
            }
        });
    }
}

