/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.ds.druid;

import com.alibaba.druid.pool.DruidDataSource;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.setting.Setting;
import org.gjgr.pig.chivalrous.db.DbRuntimeException;
import org.gjgr.pig.chivalrous.db.ds.DSFactory;

public class DruidDSFactory
extends DSFactory {
    public static final String DS_NAME = "Druid";
    private Map<String, DruidDataSource> dsMap;

    public DruidDSFactory() {
        this(null);
    }

    public DruidDSFactory(Setting setting) {
        super(DS_NAME, setting);
        this.checkCPExist(DruidDataSource.class);
        this.dsMap = new ConcurrentHashMap<String, DruidDataSource>();
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        DruidDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        DruidDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        DruidDataSource dds;
        if (group == null) {
            group = "";
        }
        if ((dds = this.dsMap.get(group)) != null) {
            IoCommand.close((Closeable)dds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionCommand.isNotEmpty(this.dsMap)) {
            Collection<DruidDataSource> values = this.dsMap.values();
            for (DruidDataSource dds : values) {
                IoCommand.close((Closeable)dds);
            }
            this.dsMap.clear();
        }
    }

    private DruidDataSource createDataSource(String group) {
        Properties config = this.setting.getProperties(group);
        if (CollectionCommand.isEmpty((Map)config)) {
            throw new DbRuntimeException("No Druid config for group: [{}]", group);
        }
        DruidDataSource ds = new DruidDataSource();
        ds.setUrl(this.getAndRemoveProperty(config, "url", "jdbcUrl"));
        ds.setUsername(this.getAndRemoveProperty(config, "username", "user"));
        ds.setPassword(this.getAndRemoveProperty(config, "password", "pass"));
        String driver = this.getAndRemoveProperty(config, "driver", "driverClassName");
        if (StringCommand.isNotBlank((CharSequence)driver)) {
            ds.setDriverClassName(driver);
        }
        Properties config2 = new Properties();
        for (Map.Entry<Object, Object> entry : config.entrySet()) {
            String keyStr = StringCommand.addPrefixIfNot((String)Convert.toStr((Object)entry.getKey()), (String)"druid.");
            config2.put(keyStr, entry.getValue());
        }
        ds.configFromPropety(config2);
        if (null == ds.getValidationQuery()) {
            ds.setTestOnBorrow(false);
            ds.setTestOnReturn(false);
            ds.setTestWhileIdle(false);
        }
        return ds;
    }

    private String getAndRemoveProperty(Properties properties, String key1, String key2) {
        String value = (String)properties.remove(key1);
        if (StringCommand.isBlank((CharSequence)value)) {
            value = (String)properties.remove(key2);
        }
        return value;
    }
}

