/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.ds.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.setting.Setting;
import org.gjgr.pig.chivalrous.db.DbRuntimeException;
import org.gjgr.pig.chivalrous.db.ds.DSFactory;

public class HikariDSFactory
extends DSFactory {
    public static final String DS_NAME = "HikariCP";
    private Map<String, HikariDataSource> dsMap;

    public HikariDSFactory() {
        this(null);
    }

    public HikariDSFactory(Setting setting) {
        super(DS_NAME, setting);
        this.checkCPExist(HikariDataSource.class);
        this.dsMap = new ConcurrentHashMap<String, HikariDataSource>();
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        HikariDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        HikariDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        HikariDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            IoCommand.close((Closeable)ds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionCommand.isNotEmpty(this.dsMap)) {
            Collection<HikariDataSource> values = this.dsMap.values();
            for (HikariDataSource ds : values) {
                IoCommand.close((Closeable)ds);
            }
            this.dsMap.clear();
        }
    }

    private HikariDataSource createDataSource(String group) {
        Properties config;
        if (group == null) {
            group = "";
        }
        if (CollectionCommand.isEmpty((Map)(config = this.setting.getProperties(group)))) {
            throw new DbRuntimeException("No HikariCP config for group: [{}]", group);
        }
        if (!config.containsKey("jdbcUrl") && config.containsKey("url")) {
            config.put("jdbcUrl", config.remove("url"));
        }
        if (!config.containsKey("username") && config.containsKey("user")) {
            config.put("username", config.remove("user"));
        }
        if (!config.containsKey("password") && config.containsKey("pass")) {
            config.put("password", config.remove("pass"));
        }
        if (!config.containsKey("driverClassName") && config.containsKey("driver")) {
            config.put("driverClassName", config.remove("driver"));
        }
        HikariDataSource ds = new HikariDataSource(new HikariConfig(config));
        return ds;
    }
}

