/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.ds.jndi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.setting.Setting;
import org.gjgr.pig.chivalrous.db.DbRuntimeException;
import org.gjgr.pig.chivalrous.db.DbUtil;
import org.gjgr.pig.chivalrous.db.ds.DSFactory;

public class JndiDSFactory
extends DSFactory {
    public static final String DS_NAME = "JNDI DataSource";
    private Setting setting;
    private Map<String, DataSource> dsMap = new ConcurrentHashMap<String, DataSource>();

    public JndiDSFactory() {
        this(null);
    }

    public JndiDSFactory(Setting setting) {
        super(DS_NAME, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        DataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        DataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
    }

    @Override
    public void destroy() {
    }

    private DataSource createDataSource(String group) {
        String jndiName;
        if (group == null) {
            group = "";
        }
        if (StringCommand.isEmpty((CharSequence)(jndiName = this.setting.getByGroup("jndi", group)))) {
            throw new DbRuntimeException("No setting name [jndi] for group [{}]", group);
        }
        DataSource ds = DbUtil.getJndiDs(jndiName);
        return ds;
    }
}

