/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.ds.pooled;

import org.gjgr.pig.chivalrous.core.setting.Setting;
import org.gjgr.pig.chivalrous.db.DbUtil;
import org.gjgr.pig.chivalrous.db.ds.pooled.DbConfig;

public class DbSetting {
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    private Setting setting;

    public DbSetting() {
        this(null);
    }

    public DbSetting(Setting setting) {
        this.setting = null == setting ? new Setting(DEFAULT_DB_CONFIG_PATH) : setting;
    }

    public DbConfig getDbConfig(String group) {
        DbConfig config = new DbConfig();
        String jdbcUrl = this.setting.getByGroup("url", group);
        config.setDriver(this.setting.getStr("driver", group, DbUtil.identifyDriver(jdbcUrl)));
        config.setUrl(jdbcUrl);
        config.setUser(this.setting.getStr((Object)"user", group));
        config.setPass(this.setting.getStr((Object)"pass", group));
        config.setInitialSize(this.setting.getInt("initialSize", group, Integer.valueOf(0)));
        config.setMinIdle(this.setting.getInt("minIdle", group, Integer.valueOf(0)));
        config.setMaxActive(this.setting.getInt("maxActive", group, Integer.valueOf(8)));
        config.setMaxWait(this.setting.getLong("maxWait", group, Long.valueOf(6000L)));
        return config;
    }
}

