/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.ds.pooled;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.gjgr.pig.chivalrous.db.DbUtil;
import org.gjgr.pig.chivalrous.db.ds.pooled.ConnectionWraper;
import org.gjgr.pig.chivalrous.db.ds.pooled.DbConfig;
import org.gjgr.pig.chivalrous.db.ds.pooled.PooledDataSource;

public class PooledConnection
extends ConnectionWraper {
    private PooledDataSource ds;
    private boolean isClosed;

    public PooledConnection(PooledDataSource ds) throws SQLException {
        this.ds = ds;
        DbConfig config = ds.getConfig();
        this.raw = DriverManager.getConnection(config.getUrl(), config.getUser(), config.getPass());
    }

    public PooledConnection(PooledDataSource ds, Connection conn) {
        this.ds = ds;
        this.raw = conn;
    }

    @Override
    public void close() throws SQLException {
        this.ds.free(this);
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed || this.raw.isClosed();
    }

    protected PooledConnection open() {
        this.isClosed = false;
        return this;
    }

    protected void release() {
        DbUtil.close(this.raw);
    }
}

