/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.ds.pooled;

import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.setting.Setting;
import org.gjgr.pig.chivalrous.db.DbRuntimeException;
import org.gjgr.pig.chivalrous.db.ds.DSFactory;
import org.gjgr.pig.chivalrous.db.ds.pooled.DbSetting;
import org.gjgr.pig.chivalrous.db.ds.pooled.PooledDataSource;

public class PooledDSFactory
extends DSFactory {
    public static final String DS_NAME = "Hutool-Pooled-DataSource";
    private Map<String, PooledDataSource> dsMap = new ConcurrentHashMap<String, PooledDataSource>();

    public PooledDSFactory() {
        this(null);
    }

    public PooledDSFactory(Setting setting) {
        super(DS_NAME, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        PooledDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        PooledDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        PooledDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            IoCommand.close((Closeable)ds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionCommand.isNotEmpty(this.dsMap)) {
            Collection<PooledDataSource> values = this.dsMap.values();
            for (PooledDataSource ds : values) {
                IoCommand.close((Closeable)ds);
            }
            this.dsMap.clear();
        }
    }

    private PooledDataSource createDataSource(String group) {
        Setting config;
        if (group == null) {
            group = "";
        }
        if (null == (config = this.setting.getSetting(group)) || config.isEmpty()) {
            throw new DbRuntimeException("No PooledDataSource config for group: [{}]", group);
        }
        PooledDataSource ds = new PooledDataSource(new DbSetting(config).getDbConfig(null));
        return ds;
    }
}

