/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.ds.pooled;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Queue;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.util.ThreadUtil;
import org.gjgr.pig.chivalrous.db.DbRuntimeException;
import org.gjgr.pig.chivalrous.db.ds.pooled.DbConfig;
import org.gjgr.pig.chivalrous.db.ds.pooled.DbSetting;
import org.gjgr.pig.chivalrous.db.ds.pooled.PooledConnection;
import org.gjgr.pig.chivalrous.db.ds.simple.AbstractDataSource;

public class PooledDataSource
extends AbstractDataSource {
    private Queue<PooledConnection> freePool;
    private int activeCount;
    private DbConfig config;

    public PooledDataSource() {
        this("");
    }

    public PooledDataSource(String group) {
        this(new DbSetting(), group);
    }

    public PooledDataSource(DbSetting setting, String group) {
        this(setting.getDbConfig(group));
    }

    public PooledDataSource(DbConfig config) {
        this.config = config;
        this.freePool = new LinkedList<PooledConnection>();
        int initialSize = config.getInitialSize();
        try {
            while (initialSize-- > 0) {
                this.freePool.offer(this.newConnection());
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public static synchronized PooledDataSource getDataSource(String group) {
        return new PooledDataSource(group);
    }

    public static synchronized PooledDataSource getDataSource() {
        return new PooledDataSource();
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.config.getMaxWait());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Pooled DataSource is not allow to get special Connection!");
    }

    protected synchronized boolean free(PooledConnection conn) {
        --this.activeCount;
        return this.freePool.offer(conn);
    }

    public PooledConnection newConnection() throws SQLException {
        return new PooledConnection(this);
    }

    public DbConfig getConfig() {
        return this.config;
    }

    public PooledConnection getConnection(long wait) throws SQLException {
        try {
            return this.getConnectionDirect();
        }
        catch (Exception e) {
            ThreadUtil.sleep((Number)wait);
            return this.getConnectionDirect();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (CollectionCommand.isNotEmpty(this.freePool)) {
            for (PooledConnection pooledConnection : this.freePool) {
                pooledConnection.release();
                this.freePool.clear();
                this.freePool = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        IoCommand.close((Closeable)this);
    }

    private PooledConnection getConnectionDirect() throws SQLException {
        if (null == this.freePool) {
            throw new SQLException("PooledDataSource is closed!");
        }
        int maxActive = this.config.getMaxActive();
        if (maxActive <= 0 || maxActive < this.activeCount) {
            throw new SQLException("In used Connection is more than Max Active.");
        }
        PooledConnection conn = this.freePool.poll();
        if (null == conn) {
            conn = this.newConnection();
        }
        ++this.activeCount;
        return conn.open();
    }
}

