/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.ds.simple;

import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.setting.Setting;
import org.gjgr.pig.chivalrous.db.ds.DSFactory;
import org.gjgr.pig.chivalrous.db.ds.simple.SimpleDataSource;

public class SimpleDSFactory
extends DSFactory {
    public static final String DS_NAME = "Hutool-Simple-DataSource";
    private Map<String, SimpleDataSource> dsMap = new ConcurrentHashMap<String, SimpleDataSource>();

    public SimpleDSFactory() {
        this(null);
    }

    public SimpleDSFactory(Setting setting) {
        super(DS_NAME, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        SimpleDataSource existedDataSource = this.dsMap.get(group);
        if (existedDataSource != null) {
            return existedDataSource;
        }
        SimpleDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        SimpleDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            IoCommand.close((Closeable)ds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionCommand.isNotEmpty(this.dsMap)) {
            Collection<SimpleDataSource> values = this.dsMap.values();
            for (SimpleDataSource ds : values) {
                IoCommand.close((Closeable)ds);
            }
            this.dsMap.clear();
        }
    }

    private SimpleDataSource createDataSource(String group) {
        SimpleDataSource ds = new SimpleDataSource(this.setting, group);
        return ds;
    }
}

