/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.ds.tomcat;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.setting.Setting;
import org.gjgr.pig.chivalrous.db.DbRuntimeException;
import org.gjgr.pig.chivalrous.db.DbUtil;
import org.gjgr.pig.chivalrous.db.ds.DSFactory;

public class TomcatDSFactory
extends DSFactory {
    public static final String DS_NAME = "Tomcat-Jdbc-Pool";
    private Map<String, DataSource> dsMap;

    public TomcatDSFactory() {
        this(null);
    }

    public TomcatDSFactory(Setting setting) {
        super(DS_NAME, setting);
        this.checkCPExist(DataSource.class);
        this.dsMap = new ConcurrentHashMap<String, DataSource>();
    }

    public synchronized DataSource getDataSource(String group) {
        DataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        DataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        DataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            ds.close();
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionCommand.isNotEmpty(this.dsMap)) {
            Collection<DataSource> values = this.dsMap.values();
            for (DataSource ds : values) {
                if (null == ds) continue;
                ds.close();
            }
            this.dsMap.clear();
        }
    }

    private DataSource createDataSource(String group) {
        Setting config;
        if (group == null) {
            group = "";
        }
        if (null == (config = this.setting.getSetting(group)) || config.isEmpty()) {
            throw new DbRuntimeException("No Tomcat jdbc pool config for group: [{}]", group);
        }
        PoolProperties poolProps = new PoolProperties();
        poolProps.setUrl(this.getAndRemoveProperty(config, "url", "jdbcUrl"));
        poolProps.setUsername(this.getAndRemoveProperty(config, "username", "user"));
        poolProps.setPassword(this.getAndRemoveProperty(config, "password", "pass"));
        String driver = this.getAndRemoveProperty(config, "driver", "driverClassName");
        if (StringCommand.isNotBlank((CharSequence)driver)) {
            poolProps.setDriverClassName(driver);
        } else {
            poolProps.setDriverClassName(DbUtil.identifyDriver(poolProps.getUrl()));
        }
        config.toBean((Object)poolProps);
        DataSource ds = new DataSource((PoolConfiguration)poolProps);
        return ds;
    }

    private String getAndRemoveProperty(Setting setting, String key1, String key2) {
        String value = (String)setting.remove((Object)key1);
        if (StringCommand.isBlank((CharSequence)value)) {
            value = (String)setting.remove((Object)key2);
        }
        return value;
    }
}

