/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.meta;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.db.DbRuntimeException;

public class Column
implements Cloneable {
    private String tableName;
    private String name;
    private int type;
    private int size;
    private boolean isNullable;

    public Column() {
    }

    public Column(String tableName, ResultSet columnMetaRs) {
        try {
            this.init(tableName, columnMetaRs);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(StringCommand.format((String)"Get table [{}] meta info error!", (Object[])new Object[]{tableName}));
        }
    }

    public static Column create(String tableName, ResultSet columnMetaRs) {
        return new Column(tableName, columnMetaRs);
    }

    public void init(String tableName, ResultSet columnMetaRs) throws SQLException {
        this.tableName = tableName;
        this.name = columnMetaRs.getString("COLUMN_NAME");
        this.type = columnMetaRs.getInt("DATA_TYPE");
        this.size = columnMetaRs.getInt("COLUMN_SIZE");
        this.isNullable = columnMetaRs.getBoolean("NULLABLE");
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public String toString() {
        return "Column [tableName=" + this.tableName + ", name=" + this.name + ", type=" + this.type + ", size=" + this.size + ", isNullable=" + this.isNullable + "]";
    }
}

