/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.sql;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.db.DbUtil;

public class Condition
implements Cloneable {
    private static final String OPERATOR_LIKE = "LIKE";
    private static final String OPERATOR_IN = "IN";
    private static final String OPERATOR_IS = "IS";
    private static final List<String> OPERATORS = Arrays.asList("<>", "<=", "<", ">=", ">", "=", "!=", "IN");
    private static final String VALUE_NULL = "NULL";
    private String field;
    private String operator;
    private Object value;
    private boolean isPlaceHolder = true;

    public Condition() {
    }

    public Condition(boolean isPlaceHolder) {
        this.isPlaceHolder = isPlaceHolder;
    }

    public Condition(String field, Object value) {
        this(field, "=", value);
        this.parseValue();
    }

    public Condition(String field, String operator, Object value) {
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    public Condition(String field, String value, LikeType likeType) {
        this.field = field;
        this.operator = OPERATOR_LIKE;
        this.value = DbUtil.buildLikeValue(value, likeType);
    }

    public static Condition parse(String field, Object expression) {
        return new Condition(field, expression);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.setValue(value, false);
    }

    public void setValue(Object value, boolean isParse) {
        this.value = value;
        if (isParse) {
            this.parseValue();
        }
    }

    public boolean isPlaceHolder() {
        return this.isPlaceHolder;
    }

    public void setPlaceHolder(boolean isPlaceHolder) {
        this.isPlaceHolder = isPlaceHolder;
    }

    public Condition clone() {
        try {
            return (Condition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return StringCommand.format((String)"`{}` {} {}", (Object[])new Object[]{this.field, this.operator, this.value});
    }

    private void parseValue() {
        if (null == this.value) {
            this.operator = OPERATOR_IS;
            this.value = VALUE_NULL;
            return;
        }
        if (this.value instanceof Collection) {
            this.operator = OPERATOR_IN;
            this.value = CollectionCommand.join((Iterable)((Collection)this.value), (String)",");
            return;
        }
        if (ArrayCommand.isArray((Object)this.value)) {
            this.operator = OPERATOR_IN;
            this.value = ArrayCommand.join((Object)this.value, (String)",");
            return;
        }
        if (!(this.value instanceof String)) {
            return;
        }
        String valueStr = (String)this.value;
        if (StringCommand.isBlank((CharSequence)valueStr)) {
            return;
        }
        List strs = StringCommand.split((String)(valueStr = valueStr.trim()), (char)' ', (int)2);
        if (strs.size() < 2) {
            return;
        }
        String firstPart = ((String)strs.get(0)).trim().toUpperCase();
        if (OPERATORS.contains(firstPart)) {
            this.operator = firstPart;
            this.value = strs.get(1);
            return;
        }
        if (valueStr.toUpperCase().startsWith(OPERATOR_LIKE)) {
            this.operator = OPERATOR_LIKE;
            this.value = StringCommand.removePrefix((String)valueStr, (String)OPERATOR_LIKE).trim();
        }
    }

    public static enum LikeType {
        StartWith,
        EndWith,
        Contains;

    }
}

