/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.sql;

import java.sql.SQLException;
import java.util.Collection;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.db.Page;
import org.gjgr.pig.chivalrous.db.sql.Condition;

public class Query {
    Collection<String> fields;
    String[] tableNames;
    Condition[] where;
    Page page;

    public Query(String ... tableNames) {
        this((Condition[])null, tableNames);
        this.tableNames = tableNames;
    }

    public Query(Condition[] where, String ... tableNames) {
        this(where, (Page)null, tableNames);
    }

    public Query(Condition[] where, Page page, String ... tableNames) {
        this(null, tableNames, where, page);
    }

    public Query(Collection<String> fields, String[] tableNames, Condition[] where, Page page) {
        this.fields = fields;
        this.tableNames = tableNames;
        this.where = where;
        this.page = page;
    }

    public Collection<String> getFields() {
        return this.fields;
    }

    public Query setFields(String ... fields) {
        this.fields = CollectionCommand.newArrayList((Object[])fields);
        return this;
    }

    public Query setFields(Collection<String> fields) {
        this.fields = fields;
        return this;
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public Query setTableNames(String ... tableNames) {
        this.tableNames = tableNames;
        return this;
    }

    public Condition[] getWhere() {
        return this.where;
    }

    public Query setWhere(Condition ... where) {
        this.where = where;
        return this;
    }

    public Page getPage() {
        return this.page;
    }

    public Query setPage(Page page) {
        this.page = page;
        return this;
    }

    public String getFirstTableName() throws SQLException {
        if (ArrayCommand.isEmpty((Object[])this.tableNames)) {
            throw new SQLException("No tableName!");
        }
        return this.tableNames[0];
    }
}

