/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.Log;
import org.gjgr.pig.chivalrous.core.log.StaticLog;
import org.gjgr.pig.chivalrous.db.DbRuntimeException;
import org.gjgr.pig.chivalrous.db.DbUtil;
import org.gjgr.pig.chivalrous.db.Entity;
import org.gjgr.pig.chivalrous.db.dialect.DialectName;
import org.gjgr.pig.chivalrous.db.sql.Condition;
import org.gjgr.pig.chivalrous.db.sql.Direction;
import org.gjgr.pig.chivalrous.db.sql.LogicalOperator;
import org.gjgr.pig.chivalrous.db.sql.Order;
import org.gjgr.pig.chivalrous.db.sql.Query;
import org.gjgr.pig.chivalrous.db.sql.SqlFormatter;
import org.gjgr.pig.chivalrous.db.sql.Wrapper;

public class SqlBuilder {
    private static final Log log = StaticLog.get();
    private static boolean showSql;
    private static boolean formatSql;
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> paramValues = new ArrayList<Object>();
    private Wrapper wrapper;

    public SqlBuilder() {
    }

    public SqlBuilder(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public static SqlBuilder create() {
        return new SqlBuilder();
    }

    public static SqlBuilder create(Wrapper wrapper) {
        return new SqlBuilder(wrapper);
    }

    public static void setShowSql(boolean isShowSql, boolean isFormatSql) {
        showSql = isShowSql;
        formatSql = isFormatSql;
    }

    public SqlBuilder insert(Entity entity) {
        return this.insert(entity, DialectName.ANSI);
    }

    public SqlBuilder insert(Entity entity, DialectName dialectName) {
        DbUtil.validateEntity(entity);
        if (null != this.wrapper) {
            entity = this.wrapper.wrap(entity);
        }
        boolean isOracle = ObjectCommand.equal((Object)((Object)dialectName), (Object)((Object)DialectName.ORACLE));
        StringBuilder fields = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry entry : entity.entrySet()) {
            String field = (String)entry.getKey();
            Object value = entry.getValue();
            if (!StringCommand.isNotBlank((CharSequence)field) || null == value) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                fields.append(", ");
                placeHolder.append(", ");
            }
            fields.append(field);
            if (isOracle && value instanceof String && StringCommand.endWithIgnoreCase((String)((String)value), (String)".nextval")) {
                placeHolder.append(value);
                continue;
            }
            placeHolder.append("?");
            this.paramValues.add(value);
        }
        this.sql.append("INSERT INTO ").append(entity.getTableName()).append(" (").append((CharSequence)fields).append(") VALUES (").append(placeHolder.toString()).append(")");
        return this;
    }

    public SqlBuilder delete(String tableName) {
        if (StringCommand.isBlank((CharSequence)tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (null != this.wrapper) {
            tableName = this.wrapper.wrap(tableName);
        }
        this.sql.append("DELETE FROM ").append(tableName);
        return this;
    }

    public SqlBuilder update(Entity entity) {
        DbUtil.validateEntity(entity);
        if (null != this.wrapper) {
            entity = this.wrapper.wrap(entity);
        }
        this.sql.append("UPDATE ").append(entity.getTableName()).append(" SET ");
        for (Map.Entry entry : entity.entrySet()) {
            String key = (String)entry.getKey();
            if (!StringCommand.isNotBlank((CharSequence)key)) continue;
            if (this.paramValues.size() > 0) {
                this.sql.append(", ");
            }
            this.sql.append((String)entry.getKey()).append(" = ? ");
            this.paramValues.add(entry.getValue());
        }
        return this;
    }

    public SqlBuilder select(boolean isDistinct, String ... fields) {
        return this.select(isDistinct, Arrays.asList(fields));
    }

    public SqlBuilder select(boolean isDistinct, Collection<String> fields) {
        this.sql.append("SELECT ");
        if (isDistinct) {
            this.sql.append("DISTINCT ");
        }
        if (CollectionCommand.isEmpty(fields)) {
            this.sql.append("*");
        } else {
            if (null != this.wrapper) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(CollectionCommand.join(fields, (String)","));
        }
        return this;
    }

    public SqlBuilder select(String ... fields) {
        return this.select(false, fields);
    }

    public SqlBuilder select(Collection<String> fields) {
        return this.select(false, fields);
    }

    public SqlBuilder from(String ... tableNames) {
        if (ArrayCommand.isEmpty((Object[])tableNames) || StringCommand.hasBlank((CharSequence[])tableNames)) {
            throw new DbRuntimeException("Table name is blank in table names !");
        }
        if (null != this.wrapper) {
            tableNames = this.wrapper.wrap(tableNames);
        }
        this.sql.append(" FROM ").append(ArrayCommand.join((Object[])tableNames, (String)","));
        return this;
    }

    public SqlBuilder where(LogicalOperator logicalOperator, Condition ... conditions) {
        if (ArrayCommand.isNotEmpty((Object[])conditions)) {
            if (null != this.wrapper) {
                conditions = this.wrapper.wrap(conditions);
            }
            this.where(this.buildCondition(logicalOperator, conditions));
        }
        return this;
    }

    public SqlBuilder where(String where) {
        if (StringCommand.isNotBlank((CharSequence)where)) {
            this.sql.append(" WHERE ").append(where);
        }
        return this;
    }

    public <T> SqlBuilder in(String field, T ... values) {
        this.sql.append(this.wrapper.wrap(field)).append(" IN ").append("(").append(ArrayCommand.join((Object[])values, (String)",")).append(")");
        return this;
    }

    public SqlBuilder groupBy(String ... fields) {
        if (ArrayCommand.isNotEmpty((Object[])fields)) {
            if (null != this.wrapper) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(" GROUP BY ").append(ArrayCommand.join((Object[])fields, (String)","));
        }
        return this;
    }

    public SqlBuilder having(LogicalOperator logicalOperator, Condition ... conditions) {
        if (ArrayCommand.isNotEmpty((Object[])conditions)) {
            if (null != this.wrapper) {
                conditions = this.wrapper.wrap(conditions);
            }
            this.having(this.buildCondition(logicalOperator, conditions));
        }
        return this;
    }

    public SqlBuilder having(String having) {
        if (StringCommand.isNotBlank((CharSequence)having)) {
            this.sql.append(" HAVING ").append(having);
        }
        return this;
    }

    public SqlBuilder orderBy(Order ... orders) {
        if (ArrayCommand.isEmpty((Object[])orders)) {
            return this;
        }
        this.sql.append(" ORDER BY ");
        String field = null;
        boolean isFirst = true;
        for (Order order : orders) {
            if (null != this.wrapper) {
                field = this.wrapper.wrap(order.getField());
            }
            if (StringCommand.isBlank(field)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                this.sql.append(",");
            }
            this.sql.append(field);
            Direction direction = order.getDirection();
            if (null == direction) continue;
            this.sql.append(" ").append((Object)direction);
        }
        return this;
    }

    public SqlBuilder join(String tableName, Join join) {
        if (StringCommand.isBlank((CharSequence)tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (null != join) {
            this.sql.append(" ").append((Object)join).append(" JOIN ");
            if (null != this.wrapper) {
                tableName = this.wrapper.wrap(tableName);
            }
            this.sql.append(tableName);
        }
        return this;
    }

    public SqlBuilder on(LogicalOperator logicalOperator, Condition ... conditions) {
        if (ArrayCommand.isNotEmpty((Object[])conditions)) {
            if (null != this.wrapper) {
                conditions = this.wrapper.wrap(conditions);
            }
            this.on(this.buildCondition(logicalOperator, conditions));
        }
        return this;
    }

    public SqlBuilder on(String on) {
        if (StringCommand.isNotBlank((CharSequence)on)) {
            this.sql.append(" ON ").append(on);
        }
        return this;
    }

    public SqlBuilder append(Object sqlPart) {
        if (null != sqlPart) {
            this.sql.append(sqlPart);
        }
        return this;
    }

    public SqlBuilder query(Query query) {
        return this.select(query.getFields()).from(query.getTableNames()).where(LogicalOperator.AND, query.getWhere());
    }

    public List<Object> getParamValues() {
        return this.paramValues;
    }

    public Object[] getParamValueArray() {
        return this.paramValues.toArray(new Object[this.paramValues.size()]);
    }

    public String build() {
        return this.build(showSql);
    }

    public String build(boolean isShowDebugSql) {
        String sqlStr = this.sql.toString().trim();
        if (isShowDebugSql) {
            log.debug("\n{}", new Object[]{formatSql ? SqlFormatter.format(sqlStr) : sqlStr});
        }
        return sqlStr;
    }

    public String toString() {
        return this.build();
    }

    private String buildCondition(LogicalOperator logicalOperator, Condition ... conditions) {
        if (ArrayCommand.isEmpty((Object[])conditions)) {
            return "";
        }
        if (null == logicalOperator) {
            logicalOperator = LogicalOperator.AND;
        }
        StringBuilder conditionStr = new StringBuilder();
        boolean isFirst = true;
        for (Condition condition : conditions) {
            if (isFirst) {
                isFirst = false;
            } else {
                conditionStr.append(" ").append((Object)logicalOperator).append(" ");
            }
            conditionStr.append(condition.getField()).append(" ").append(condition.getOperator());
            if (condition.isPlaceHolder()) {
                conditionStr.append(" ?");
                this.paramValues.add(condition.getValue());
                continue;
            }
            conditionStr.append(condition.getValue());
        }
        return conditionStr.toString();
    }

    public static enum Join {
        INNER,
        LEFT,
        RIGHT,
        FULL;

    }
}

