/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db.sql;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.db.Entity;
import org.gjgr.pig.chivalrous.db.sql.Condition;

public class Wrapper {
    private Character preWrapQuote;
    private Character sufWrapQuote;

    public Wrapper() {
    }

    public Wrapper(Character wrapQuote) {
        this.preWrapQuote = wrapQuote;
        this.sufWrapQuote = wrapQuote;
    }

    public Wrapper(Character preWrapQuote, Character sufWrapQuote) {
        this.preWrapQuote = preWrapQuote;
        this.sufWrapQuote = sufWrapQuote;
    }

    public char getPreWrapQuote() {
        return this.preWrapQuote.charValue();
    }

    public void setPreWrapQuote(Character preWrapQuote) {
        this.preWrapQuote = preWrapQuote;
    }

    public char getSufWrapQuote() {
        return this.sufWrapQuote.charValue();
    }

    public void setSufWrapQuote(Character sufWrapQuote) {
        this.sufWrapQuote = sufWrapQuote;
    }

    public String wrap(String field) {
        if (this.preWrapQuote == null || this.sufWrapQuote == null || StringCommand.isBlank((CharSequence)field)) {
            return field;
        }
        if (StringCommand.isSurround((CharSequence)field, (char)this.preWrapQuote.charValue(), (char)this.sufWrapQuote.charValue())) {
            return field;
        }
        if (field.contains("*") || field.contains("(")) {
            return field;
        }
        return StringCommand.format((String)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, field, this.sufWrapQuote});
    }

    public String[] wrap(String ... fields) {
        if (ArrayCommand.isEmpty((Object[])fields)) {
            return fields;
        }
        String[] wrappedFields = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            wrappedFields[i] = this.wrap(fields[i]);
        }
        return wrappedFields;
    }

    public Collection<String> wrap(Collection<String> fields) {
        if (CollectionCommand.isEmpty(fields)) {
            return fields;
        }
        return Arrays.asList(this.wrap(fields.toArray(new String[fields.size()])));
    }

    public Entity wrap(Entity entity) {
        if (null == entity) {
            return null;
        }
        Entity wrapedEntity = new Entity();
        wrapedEntity.setTableName(this.wrap(entity.getTableName()));
        for (Map.Entry entry : entity.entrySet()) {
            wrapedEntity.set(this.wrap((String)entry.getKey()), entry.getValue());
        }
        return wrapedEntity;
    }

    public Condition[] wrap(Condition ... conditions) {
        Condition[] clonedConditions = new Condition[conditions.length];
        if (ArrayCommand.isNotEmpty((Object[])conditions)) {
            for (int i = 0; i < conditions.length; ++i) {
                Condition clonedCondition = conditions[i].clone();
                clonedCondition.setField(this.wrap(clonedCondition.getField()));
                clonedConditions[i] = clonedCondition;
            }
        }
        return clonedConditions;
    }
}

