/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.extra;

import it.sauronsoftware.cron4j.Scheduler;
import it.sauronsoftware.cron4j.Task;
import java.util.Map;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.exceptions.UtilException;
import org.gjgr.pig.chivalrous.core.lang.ClassCommand;
import org.gjgr.pig.chivalrous.core.setting.Setting;

public class CronUtil {
    public static final String CRONTAB_CONFIG_PATH = "config/cron4j.setting";
    private static final Scheduler scheduler = new Scheduler();
    private static Setting crontabSetting;

    public static void setCronSetting(Setting cronSetting) {
        crontabSetting = cronSetting;
    }

    public static void setCronSetting(String cronSettingPath) {
        crontabSetting = new Setting(cronSettingPath, Setting.DEFAULT_CHARSET, false);
    }

    public static String schedule(String schedulingPattern, Task task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static String schedule(String schedulingPattern, Runnable task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static void schedule(Setting cronSetting) {
        for (Map.Entry entry : cronSetting.entrySet()) {
            String jobClass = Convert.toStr(entry.getKey());
            String pattern = Convert.toStr(entry.getValue());
            try {
                Runnable job = (Runnable)ClassCommand.newInstance((String)jobClass);
                CronUtil.schedule(pattern, job);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized void start() {
        if (null == crontabSetting) {
            CronUtil.setCronSetting(CRONTAB_CONFIG_PATH);
        }
        if (scheduler.isStarted()) {
            throw new UtilException("Scheduler has been started, please stop it first!");
        }
        CronUtil.schedule(crontabSetting);
        scheduler.start();
    }

    public static synchronized void restart() {
        if (null != crontabSetting) {
            crontabSetting.load();
        }
        if (scheduler.isStarted()) {
            scheduler.stop();
        }
        CronUtil.schedule(crontabSetting);
        scheduler.start();
    }

    public static synchronized void stop() {
        scheduler.stop();
    }

    public void remove(String schedulerId) {
        scheduler.deschedule(schedulerId);
    }

    public Scheduler getScheduler() {
        return scheduler;
    }
}

