/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.image.image;

import java.awt.image.BufferedImage;
import java.util.Random;
import org.gjgr.pig.chivalrous.image.image.ImageMath;
import org.gjgr.pig.chivalrous.image.image.PointFilter;

public class DissolveFilter
extends PointFilter {
    private float density = 1.0f;
    private float softness = 0.0f;
    private float minDensity;
    private float maxDensity;
    private Random randomNumbers;

    public float getDensity() {
        return this.density;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public float getSoftness() {
        return this.softness;
    }

    public void setSoftness(float softness) {
        this.softness = softness;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        float d = (1.0f - this.density) * (1.0f + this.softness);
        this.minDensity = d - this.softness;
        this.maxDensity = d;
        this.randomNumbers = new Random(0L);
        return super.filter(src, dst);
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int a = rgb >> 24 & 0xFF;
        float v = this.randomNumbers.nextFloat();
        float f = ImageMath.smoothStep(this.minDensity, this.maxDensity, v);
        return (int)((float)a * f) << 24 | rgb & 0xFFFFFF;
    }

    public String toString() {
        return "Stylize/Dissolve...";
    }
}

