/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.image.image;

import org.gjgr.pig.chivalrous.image.image.ImageMath;
import org.gjgr.pig.chivalrous.image.image.PixelUtils;
import org.gjgr.pig.chivalrous.image.image.PointFilter;

public class ThresholdFilter
extends PointFilter {
    private int lowerThreshold;
    private int upperThreshold;
    private int white = 0xFFFFFF;
    private int black = 0;

    public ThresholdFilter() {
        this(127);
    }

    public ThresholdFilter(int t) {
        this.setLowerThreshold(t);
        this.setUpperThreshold(t);
    }

    public int getLowerThreshold() {
        return this.lowerThreshold;
    }

    public void setLowerThreshold(int lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
    }

    public int getUpperThreshold() {
        return this.upperThreshold;
    }

    public void setUpperThreshold(int upperThreshold) {
        this.upperThreshold = upperThreshold;
    }

    public int getWhite() {
        return this.white;
    }

    public void setWhite(int white) {
        this.white = white;
    }

    public int getBlack() {
        return this.black;
    }

    public void setBlack(int black) {
        this.black = black;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int v = PixelUtils.brightness(rgb);
        float f = ImageMath.smoothStep(this.lowerThreshold, this.upperThreshold, v);
        return rgb & 0xFF000000 | ImageMath.mixColors(f, this.black, this.white) & 0xFFFFFF;
    }

    public String toString() {
        return "Stylize/Threshold...";
    }
}

