/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.mail;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.http.NameValuePair;
import org.gjgr.pig.chivalrous.core.Command;
import org.gjgr.pig.chivalrous.core.entity.Message;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.json.bean.JsonObject;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.Nullable;
import org.gjgr.pig.chivalrous.core.net.UriBuilder;
import org.gjgr.pig.chivalrous.core.net.UriCommand;
import org.gjgr.pig.chivalrous.mail.SimpleMail;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailCommand {
    private static final String row = "style=\"vertical-align: top; padding: 0;\" align=\"left\"";
    private static final String column = "class=\"center\" style=\"word-break: break-word; -webkit-hyphens: auto; -moz-hyphens: auto; hyphens: auto; border-collapse: collapse !important; color: #222222; font-family: 'Open Sans', 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-weight: normal; line-height: 19px; font-size: 14px; -webkit-font-smoothing: antialiased; -webkit-text-size-adjust: none; margin: 0; padding: 0px 0px 10px;\" align=\"center\" valign=\"top\"";
    private static Logger logger = LoggerFactory.getLogger(Command.class);

    public static boolean sendTextMail(HtmlEmail email, String title, String textBody) {
        return MailCommand.sendMail(email, title, textBody, MailContentType.Text);
    }

    public static boolean sendHtmlMail(HtmlEmail email, String title, String textBody) {
        return MailCommand.sendMail(email, title, textBody, MailContentType.Html);
    }

    public static boolean sendMail(HtmlEmail email, String title, String textBody, MailContentType emailType) {
        boolean status = false;
        try {
            if (title == null) {
                email.setSubject("You received a new email, send by " + email.getFromAddress());
            } else {
                email.setSubject(title);
            }
            switch (emailType) {
                case Html: {
                    email.setHtmlMsg(textBody);
                    break;
                }
                case Text: {
                    email.setTextMsg(textBody);
                    break;
                }
                default: {
                    email.setMsg(textBody);
                }
            }
            email.send();
            status = true;
        }
        catch (EmailException e) {
            logger.error("could not add send email.", (Throwable)e);
        }
        return status;
    }

    public static boolean sendMail(MailContentType mailContentType, String host, String username, String from, String password, String title, String content, String nickname, String to, String cc, Set<String> files) {
        boolean status;
        HtmlEmail email = new HtmlEmail();
        email.setCharset("UTF-8");
        email.setHostName(host);
        if (username == null || password == null) {
            email.setAuthentication("", "");
        } else {
            email.setAuthentication(username, password);
        }
        if (from != null && (to != null || cc != null)) {
            List emailTo = new ArrayList();
            if (to != null) {
                emailTo = CollectionCommand.convertToList((String)to, (String)";");
            }
            List emailCC = new ArrayList();
            if (cc != null) {
                emailCC = CollectionCommand.convertToList((String)cc, (String)";");
            }
            emailTo.forEach(t -> {
                try {
                    email.addTo(t);
                }
                catch (EmailException e) {
                    logger.warn("email exception could not add target email address {}", t);
                }
            });
            emailCC.forEach(c -> {
                try {
                    email.addCc(c);
                }
                catch (EmailException e) {
                    logger.warn("could not add cc address :{}", c);
                }
            });
            try {
                if (nickname != null) {
                    email.setFrom(from, nickname);
                } else {
                    email.setFrom(from);
                }
                if (files.size() != 0) {
                    files.forEach(f -> {
                        File file1 = new File((String)f);
                        if (file1.isFile()) {
                            try {
                                email.attach(file1.getAbsoluteFile());
                            }
                            catch (EmailException e) {
                                logger.error("could not find file {} ", (Object)file1);
                            }
                        }
                    });
                }
                MailCommand.sendMail(email, title, content, mailContentType);
                status = true;
            }
            catch (EmailException e) {
                status = false;
                logger.error("send formatMessage fail from address not right {}", (Object)from);
            }
        } else {
            logger.error("did not contain from or to address for the url. send formatMessage fail.");
            status = false;
        }
        return status;
    }

    public static boolean sendMail(MailContentType mailContentType, String url, String title, String content) {
        try {
            return MailCommand.sendMail(mailContentType, UriCommand.uriBuilder((String)url), title, content);
        }
        catch (Exception e) {
            logger.error("url parse error for send email", (Throwable)e);
            return false;
        }
    }

    public static boolean sendMail(MailContentType mailContentType, String url, String from, String to, String cc, String title, String content, List<String> files) {
        HashSet<String> setFiles = new HashSet<String>(files);
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : setFiles) {
            stringBuffer.append(string + ";");
        }
        return MailCommand.sendMail(mailContentType, url, from, to, cc, title, content);
    }

    public static boolean sendMail(MailContentType mailContentType, String url, String from, String to, String cc, String title, String content, String file) {
        url = url + "&file=" + file;
        return MailCommand.sendMail(mailContentType, url, from, to, cc, title, content);
    }

    public static boolean sendMail(MailContentType mailContentType, String url, String from, String to, String cc, String title, String content) {
        try {
            UriBuilder uriBuilder = UriCommand.uriBuilder((String)url);
            if (from != null) {
                uriBuilder.addParameter("from", from);
            }
            if (to != null) {
                uriBuilder.addParameter("to", to);
            }
            if (cc != null) {
                uriBuilder.addParameter("cc", cc);
            }
            return MailCommand.sendMail(mailContentType, uriBuilder, title, content);
        }
        catch (Exception e) {
            logger.error("url parse error for send email", (Throwable)e);
            return false;
        }
    }

    public static boolean sendMail(Message message) {
        MailContentType mailContentType = MailContentType.valueOf(message.getStatus());
        boolean status = false;
        if (mailContentType == null) {
            throw new RuntimeException("error formatMessage contentType code, did not support the message status " + message.getStatus());
        }
        if (message.getInfo().containsKey("url")) {
            UriBuilder uriBuilder = UriCommand.uriBuilder((String)message.getInfo().get("url").toString());
            String title = null;
            if (message.getInfo().containsKey("title")) {
                title = message.getInfo().get("title").toString();
            }
            if (message.getInfo().containsKey("from")) {
                Object object;
                HashSet sets = new HashSet();
                String from = message.getInfo().get("from").toString();
                String to = message.getInfo().get("to").toString();
                if (from == null || to == null) {
                    throw new RuntimeException("should define from and to address in Message Entity.");
                }
                sets.addAll(CollectionCommand.convertToList((String)from, (String)";"));
                for (Object str : sets) {
                    uriBuilder.addParameter("from", (String)str);
                }
                sets.clear();
                sets.addAll(CollectionCommand.convertToList((String)to, (String)";"));
                for (Object str : sets) {
                    uriBuilder.addParameter("to", (String)str);
                }
                sets.clear();
                String cc = message.getInfo().get("cc").toString();
                if (cc != null) {
                    sets.addAll(CollectionCommand.convertToList((String)to, (String)";"));
                    for (String str : sets) {
                        uriBuilder.addParameter("to", str);
                    }
                    sets.clear();
                }
                if ((object = message.getInfo().get("file")) != null) {
                    if (object instanceof Collection) {
                        Collection list = (Collection)object;
                        sets.addAll(list);
                    } else if (object instanceof String) {
                        sets.addAll(CollectionCommand.convertToList((String)object.toString()));
                    }
                    for (String str : sets) {
                        uriBuilder.addParameter("file", str);
                    }
                }
            }
            Object data = message.getData();
            if (message.getStatus() != null && message.getStatus() == 1) {
                data = MailCommand.formatMessage(message);
            }
            status = MailCommand.sendMail(mailContentType, uriBuilder, title, data.toString());
        } else {
            logger.error("message info did not contain email url");
        }
        return status;
    }

    public static boolean sendMail(Message message, SimpleMail simpleMail) {
        return MailCommand.sendMail(MailCommand.formatMessage(message, simpleMail));
    }

    public static boolean sendMail(SimpleMail simpleMail) {
        Message message = new Message();
        message.setStatus(Integer.valueOf(1));
        message.setCode(Integer.valueOf(25));
        message.setData((Object)simpleMail.getContent());
        MailCommand.formatMessage(message, simpleMail);
        message.setData((Object)MailCommand.formatMessage(message));
        return MailCommand.sendMail(message);
    }

    public static Message formatMessage(Message message, SimpleMail simpleMail) {
        if (simpleMail.getUrl() != null) {
            message.getInfo().put("url", simpleMail.getUrl());
        }
        if (simpleMail.getAuthor() != null) {
            message.getInfo().put("author", simpleMail.getAuthor());
        }
        if (simpleMail.getFrom() != null) {
            message.getInfo().put("from", simpleMail.getFrom());
        }
        if (simpleMail.getCc() != null) {
            message.getInfo().put("cc", simpleMail.getCc());
        }
        if (simpleMail.getContact() != null) {
            message.getInfo().put("contact", simpleMail.getContact());
        }
        if (simpleMail.getContent() != null) {
            message.setData((Object)simpleMail.getContent());
        }
        if (simpleMail.getFile() != null) {
            message.getInfo().put("file", simpleMail.getFile());
        }
        if (simpleMail.getNickname() != null) {
            message.getInfo().put("nickname", simpleMail.getNickname());
        }
        if (simpleMail.getMessage() != null) {
            message.setMessage(simpleMail.getMessage());
        }
        if (simpleMail.getType() != null) {
            message.setType(simpleMail.getType());
        }
        if (simpleMail.getCopyright() != null) {
            message.getInfo().put("copyright", simpleMail.getCopyright());
        }
        if (simpleMail.getMore() != null) {
            message.getInfo().put("more", simpleMail.getMore());
        }
        if (simpleMail.getHeadline() != null) {
            message.getInfo().put("headline", simpleMail.getHeadline());
        }
        if (message.getStatus() == null) {
            message.setStatus(Integer.valueOf(1));
        }
        return message;
    }

    public static String formatMessage(Message message) {
        String result = null;
        logger.info("mail default root resource:{}", (Object)MailCommand.class.getClassLoader().getResource("mail.html").getPath());
        String data = null;
        data = FileCommand.readUtfResource((String)"mail.html", (ClassLoader)MailCommand.class.getClassLoader());
        Document document = Jsoup.parse((String)data);
        Element element = document.getElementById("mail_body");
        Object title = message.getInfo().get("headline");
        Object more = message.getInfo().get("more");
        Object contact = message.getInfo().get("contact");
        String subHeaderLine = message.getType();
        String messageData = message.getMessage();
        if (title != null) {
            document.getElementById("message:title").appendChild((Node)new TextNode(title.toString(), ""));
        }
        if (subHeaderLine != null) {
            document.getElementById("message:subTitle").prependChild((Node)new TextNode(subHeaderLine, ""));
        }
        if (messageData != null) {
            document.getElementById("message:subTitle").appendChild((Node)new TextNode(messageData, ""));
        }
        if (more != null || contact != null) {
            data = FileCommand.readUtfResource((String)"element.html", (ClassLoader)MailCommand.class.getClassLoader());
            Document elementDocument = Jsoup.parse((String)data);
            Element moreElemnt = elementDocument.getElementById("more");
            if (more != null) {
                moreElemnt.getElementById("left").attr("href", more.toString());
            }
            if (contact != null) {
                moreElemnt.getElementById("right").attr("href", contact.toString());
            }
            document.getElementById("message:subTitle").appendChild((Node)moreElemnt);
        }
        Object copyRight = message.getInfo().get("copyright");
        Object author = message.getInfo().get("author");
        if (copyRight != null) {
            document.getElementById("copyright").text(copyRight.toString());
        }
        if (author != null) {
            document.getElementById("author").text(author.toString());
        }
        if (message.getData() != null) {
            Object object = message.getData();
            if (object instanceof String) {
                String string = object.toString();
                result = string.replaceAll(Pattern.quote("{{row}}"), row);
                result = result.replaceAll(Pattern.quote("{{column}}"), row);
            } else if (!(object instanceof JsonObject)) {
                logger.warn("did not support other type.");
            }
        }
        try {
            if (result != null) {
                element.append(result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = document.outerHtml();
        message.setDatum((Object)result);
        return result;
    }

    public static boolean sendMail(MailContentType mailContentType, UriBuilder uriBuilder, String title, String content) {
        boolean status = false;
        if (uriBuilder.getScheme().equalsIgnoreCase("mail")) {
            String username = uriBuilder.getUserInfo();
            String host = uriBuilder.getHost();
            String from = null;
            String to = null;
            String cc = null;
            String nickname = null;
            HashSet<String> files = new HashSet<String>();
            String password = null;
            for (NameValuePair nameValuePair : uriBuilder.getQueryParams()) {
                if (nameValuePair.getName().equalsIgnoreCase("PASSWORD")) {
                    password = nameValuePair.getValue();
                    continue;
                }
                if (nameValuePair.getName().equalsIgnoreCase("USERNAME")) {
                    username = nameValuePair.getValue();
                    continue;
                }
                if (nameValuePair.getName().equalsIgnoreCase("from")) {
                    from = nameValuePair.getValue();
                    continue;
                }
                if (nameValuePair.getName().equalsIgnoreCase("to")) {
                    if (to == null) {
                        to = nameValuePair.getValue();
                        continue;
                    }
                    to = to + ";" + nameValuePair.getValue();
                    continue;
                }
                if (nameValuePair.getName().equalsIgnoreCase("cc")) {
                    if (cc == null) {
                        cc = nameValuePair.getValue();
                        continue;
                    }
                    cc = cc + ";" + nameValuePair.getValue();
                    continue;
                }
                if (nameValuePair.getName().equalsIgnoreCase("nickname")) {
                    nickname = nameValuePair.getValue();
                    continue;
                }
                if (!nameValuePair.getName().equalsIgnoreCase("file")) continue;
                try {
                    files = new HashSet(CollectionCommand.convertToList((String)nameValuePair.getValue()));
                }
                catch (Exception e) {
                    logger.error("send email from url could not know file type not know.");
                }
            }
            if (from == null || cc == null && to == null) {
                logger.error("did not found from address and to address.");
                return false;
            }
            return MailCommand.sendMail(mailContentType, host, username, from, password, title, content, nickname, to, cc, files);
        }
        logger.info("could not parse uri, not formatMessage url {}", (Object)uriBuilder.buildString());
        return status;
    }

    public static enum MailContentType {
        Text(0),
        Html(1),
        Simple(2);

        private int type;

        private MailContentType(int i) {
            this.type = i;
        }

        public static MailContentType valueOf(int statusCode) {
            MailContentType status = MailContentType.resolve(statusCode);
            if (status == null) {
                throw new IllegalArgumentException("No matching constant for [" + statusCode + "]");
            }
            return status;
        }

        @Nullable
        public static MailContentType resolve(int statusCode) {
            for (MailContentType status : MailContentType.values()) {
                if (status.type != statusCode) continue;
                return status;
            }
            return null;
        }

        public int getType() {
            return this.type;
        }
    }
}

