/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.web.http;

import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.web.http.HTMLFilter;

public final class HtmlUtil {
    public static final String RE_HTML_MARK = "(<[^<]*?>)|(<[\\s]*?/[^<]*?>)|(<[^<]*?/[\\s]*?>)";
    public static final String RE_SCRIPT = "<[\\s]*?script[^>]*?>.*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
    private static final char[][] TEXT = new char[64][];

    private HtmlUtil() {
    }

    public static String restoreEscaped(String htmlStr) {
        if (StringCommand.isBlank((CharSequence)htmlStr)) {
            return htmlStr;
        }
        return htmlStr.replace("&#39;", "'").replace("&lt;", "<").replace("&gt;", ">").replace("&amp", "&").replace("&quot;", "\"").replace("&nbsp;", " ");
    }

    public static String encode(String text) {
        return HtmlUtil.encode(text, TEXT);
    }

    public static String cleanHtmlTag(String content) {
        return content.replaceAll(RE_HTML_MARK, "");
    }

    public static String removeHtmlTag(String content, String ... tagNames) {
        return HtmlUtil.removeHtmlTag(content, true, tagNames);
    }

    public static String unwrapHtmlTag(String content, String ... tagNames) {
        return HtmlUtil.removeHtmlTag(content, false, tagNames);
    }

    public static String removeHtmlTag(String content, boolean withTagContent, String ... tagNames) {
        String regex1 = null;
        String regex2 = null;
        for (String tagName : tagNames) {
            if (StringCommand.isBlank((CharSequence)tagName)) continue;
            tagName = tagName.trim();
            regex1 = StringCommand.format((String)"(?i)<{}\\s?[^>]*?/>", (Object[])new Object[]{tagName});
            regex2 = withTagContent ? StringCommand.format((String)"(?i)(?s)<{}\\s*?[^>]*?>.*?</{}>", (Object[])new Object[]{tagName, tagName}) : StringCommand.format((String)"(?i)<{}\\s*?[^>]*?>|</{}>", (Object[])new Object[]{tagName, tagName});
            content = content.replaceAll(regex1, "").replaceAll(regex2, "");
        }
        return content;
    }

    public static String removeHtmlAttr(String content, String ... attrs) {
        String regex = null;
        for (String attr : attrs) {
            regex = StringCommand.format((String)"(?i)\\s*{}=([\"']).*?\\1", (Object[])new Object[]{attr});
            content = content.replaceAll(regex, "");
        }
        return content;
    }

    public static String removeAllHtmlAttr(String content, String ... tagNames) {
        String regex = null;
        for (String tagName : tagNames) {
            regex = StringCommand.format((String)"(?i)<{}[^>]*?>", (Object[])new Object[]{tagName});
            content.replaceAll(regex, StringCommand.format((String)"<{}>", (Object[])new Object[]{tagName}));
        }
        return content;
    }

    private static String encode(String text, char[][] array) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c < '@') {
                buffer.append(array[c]);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String filter(String htmlContent) {
        return new HTMLFilter().filter(htmlContent);
    }

    static {
        for (int i = 0; i < 64; ++i) {
            HtmlUtil.TEXT[i] = new char[]{(char)i};
        }
        HtmlUtil.TEXT[39] = "&#039;".toCharArray();
        HtmlUtil.TEXT[34] = "&quot;".toCharArray();
        HtmlUtil.TEXT[38] = "&amp".toCharArray();
        HtmlUtil.TEXT[60] = "&lt;".toCharArray();
        HtmlUtil.TEXT[62] = "&gt;".toCharArray();
    }
}

