/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.web.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.web.http.Header;

public abstract class HttpBase<T> {
    public static final String HTTP_1_0 = "HTTP/1.0";
    public static final String HTTP_1_1 = "HTTP/1.1";
    protected Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected String charset = "UTF-8";
    protected String httpVersion = "HTTP/1.1";
    protected String body;

    public String header(String name) {
        if (StringCommand.isBlank((CharSequence)name)) {
            return null;
        }
        List<String> values = this.headers.get(name.trim());
        if (CollectionCommand.isEmpty(values)) {
            return null;
        }
        return values.get(0);
    }

    public String header(Header name) {
        return this.header(name.toString());
    }

    public T removeHeader(String name) {
        if (name != null) {
            this.headers.remove(name.trim());
        }
        return (T)this;
    }

    public T removeHeader(Header name) {
        return this.removeHeader(name.toString());
    }

    public T header(String name, String value, boolean isOverride) {
        if (null != name && null != value) {
            List<String> values = this.headers.get(name.trim());
            if (isOverride || CollectionCommand.isEmpty(values)) {
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(value);
                this.headers.put(name.trim(), valueList);
            } else {
                values.add(value.trim());
            }
        }
        return (T)this;
    }

    public T header(Header name, String value, boolean isOverride) {
        return this.header(name.toString(), value, isOverride);
    }

    public T header(Header name, String value) {
        return this.header(name.toString(), value, true);
    }

    public T header(String name, String value) {
        return this.header(name, value, true);
    }

    public T header(Map<String, List<String>> headers) {
        if (CollectionCommand.isEmpty(headers)) {
            return (T)this;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                this.header(name, StringCommand.nullToEmpty((String)value), false);
            }
        }
        return (T)this;
    }

    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String httpVersion() {
        return this.httpVersion;
    }

    public T httpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
        return (T)this;
    }

    public String charset() {
        return this.charset;
    }

    public T charset(String charset) {
        if (StringCommand.isNotBlank((CharSequence)charset)) {
            this.charset = charset;
        }
        return (T)this;
    }

    public T charset(Charset charset) {
        if (null != charset) {
            this.charset = charset.name();
        }
        return (T)this;
    }

    public String toString() {
        StringBuilder sb = StringCommand.builder();
        sb.append("Request Headers: ").append("\r\n");
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            sb.append("    ").append(entry).append("\r\n");
        }
        sb.append("Request Body: ").append("\r\n");
        sb.append("    ").append(this.body).append("\r\n");
        return sb.toString();
    }
}

