/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.web.http;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.stream.FastByteArrayOutputStream;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.web.http.Header;
import org.gjgr.pig.chivalrous.web.http.HttpBase;
import org.gjgr.pig.chivalrous.web.http.HttpConnection;
import org.gjgr.pig.chivalrous.web.http.HttpException;
import org.gjgr.pig.chivalrous.web.http.HttpUtil;

public class HttpResponse
extends HttpBase<HttpResponse> {
    private FastByteArrayOutputStream out;
    private int status;

    public static HttpResponse readResponse(HttpConnection httpConnection) {
        HttpResponse httpResponse;
        block2: {
            httpResponse = new HttpResponse();
            try {
                httpResponse.status = httpConnection.responseCode();
                httpResponse.headers = httpConnection.headers();
                httpResponse.charset = httpConnection.charset();
                InputStream in = httpResponse.status < 400 ? httpConnection.getInputStream() : httpConnection.getErrorStream();
                httpResponse.readBody(in);
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block2;
                throw new HttpException(e.getMessage(), e);
            }
        }
        return httpResponse;
    }

    public int getStatus() {
        return this.status;
    }

    public String contentEncoding() {
        return this.header(Header.CONTENT_ENCODING);
    }

    public boolean isGzip() {
        String contentEncoding = this.contentEncoding();
        return contentEncoding != null && "gzip".equalsIgnoreCase(contentEncoding);
    }

    public InputStream bodyStream() {
        return new ByteArrayInputStream(this.out.toByteArray());
    }

    public byte[] bodyBytes() {
        if (null == this.out) {
            return null;
        }
        return this.out.toByteArray();
    }

    public String body() {
        try {
            return HttpUtil.getString(this.bodyStream(), this.charset, null == this.charset);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = StringCommand.builder();
        sb.append("Request Headers: ").append("\r\n");
        for (Map.Entry entry : this.headers.entrySet()) {
            sb.append("    ").append(entry).append("\r\n");
        }
        sb.append("Request Body: ").append("\r\n");
        sb.append("    ").append(this.body()).append("\r\n");
        return sb.toString();
    }

    private void readBody(InputStream in) throws IOException {
        int contentLength;
        if (this.isGzip()) {
            in = new GZIPInputStream(in);
        }
        this.out = (contentLength = Convert.toInt((Object)this.header(Header.CONTENT_LENGTH), (Integer)0).intValue()) > 0 ? new FastByteArrayOutputStream(contentLength) : new FastByteArrayOutputStream();
        try {
            IoCommand.copy((InputStream)in, (OutputStream)this.out);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }
}

