/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.web.http;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileUtil;
import org.gjgr.pig.chivalrous.core.io.stream.FastByteArrayOutputStream;
import org.gjgr.pig.chivalrous.core.io.stream.StreamProgress;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.StaticLog;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;
import org.gjgr.pig.chivalrous.core.regex.ReUtil;
import org.gjgr.pig.chivalrous.web.http.HttpException;
import org.gjgr.pig.chivalrous.web.http.HttpRequest;

public final class HttpUtil {
    public static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(.*?)\"");

    private HttpUtil() {
    }

    public static String encode(String content, Charset charset) {
        return HttpUtil.encode(content, charset.name());
    }

    public static String encode(String content, String charsetStr) {
        if (StringCommand.isBlank((CharSequence)content)) {
            return content;
        }
        String encodeContent = null;
        try {
            encodeContent = URLEncoder.encode(content, charsetStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpException(StringCommand.format((String)"Unsupported encoding: [{}]", (Object[])new Object[]{charsetStr}), e);
        }
        return encodeContent;
    }

    public static String decode(String content, Charset charset) {
        return HttpUtil.decode(content, charset.name());
    }

    public static String decode(String content, String charsetStr) {
        if (StringCommand.isBlank((CharSequence)content)) {
            return content;
        }
        String encodeContnt = null;
        try {
            encodeContnt = URLDecoder.decode(content, charsetStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpException(StringCommand.format((String)"Unsupported encoding: [{}]", (Object[])new Object[]{charsetStr}), e);
        }
        return encodeContnt;
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String ip;
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayCommand.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])ArrayCommand.addAll((Object[][])new String[][]{headers, otherHeaderNames});
        }
        for (String header : headers) {
            ip = request.getHeader(header);
            if (HttpUtil.isUnknow(ip)) continue;
            return HttpUtil.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return HttpUtil.getMultistageReverseProxyIp(ip);
    }

    public static boolean isHttps(String url) {
        return url.toLowerCase().startsWith("https");
    }

    public static String get(String urlString, String customCharset) {
        return ((HttpRequest)HttpRequest.get(urlString).charset(customCharset)).execute().body();
    }

    public static String get(String urlString) {
        return HttpRequest.get(urlString).execute().body();
    }

    public static String get(String urlString, Map<String, Object> paramMap) {
        return HttpRequest.get(urlString).form(paramMap).execute().body();
    }

    public static String post(String urlString, Map<String, Object> paramMap) {
        return HttpRequest.post(urlString).form(paramMap).execute().body();
    }

    public static String post(String urlString, String params) {
        return HttpRequest.post(urlString).body(params).execute().body();
    }

    public static String downloadString(String url, String customCharsetName) {
        return HttpUtil.downloadString(url, CharsetCommand.charset((String)customCharsetName), null);
    }

    public static String downloadString(String url, Charset customCharset) {
        return HttpUtil.downloadString(url, customCharset, null);
    }

    public static String downloadString(String url, Charset customCharset, StreamProgress streamPress) {
        if (StringCommand.isBlank((CharSequence)url)) {
            throw new NullPointerException("[url] is null!");
        }
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        HttpUtil.download(url, (OutputStream)out, true, streamPress);
        return null == customCharset ? out.toString() : out.toString(customCharset);
    }

    public static long downloadFile(String url, String dest) {
        return HttpUtil.downloadFile(url, FileUtil.file((String)dest));
    }

    public static long downloadFile(String url, File destFile) {
        return HttpUtil.downloadFile(url, destFile, null);
    }

    public static long downloadFile(String url, File destFile, StreamProgress streamProgress) {
        if (StringCommand.isBlank((CharSequence)url)) {
            throw new NullPointerException("[url] is null!");
        }
        if (null == destFile) {
            throw new NullPointerException("[destFile] is null!");
        }
        if (destFile.isDirectory()) {
            String fileName = StringCommand.subSuf((String)url, (int)(url.lastIndexOf(47) + 1));
            StaticLog.debug((String)"FileName: {}", (Object[])new Object[]{fileName});
            if (StringCommand.isBlank((CharSequence)fileName)) {
                fileName = HttpUtil.encode(url, CharsetCommand.CHARSET_UTF_8);
            }
            destFile = FileUtil.file((File)destFile, (String)fileName);
        }
        BufferedOutputStream out = null;
        try {
            out = FileUtil.getOutputStream((File)destFile);
            return HttpUtil.download(url, out, true, streamProgress);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    public static long download(String url, OutputStream out, boolean isCloseOut) {
        return HttpUtil.download(url, out, isCloseOut, null);
    }

    public static long download(String url, OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        long l;
        if (StringCommand.isBlank((CharSequence)url)) {
            throw new NullPointerException("[url] is null!");
        }
        if (null == out) {
            throw new NullPointerException("[out] is null!");
        }
        InputStream in = null;
        try {
            in = new URL(url).openStream();
            l = IoCommand.copyByNIO((InputStream)in, (OutputStream)out, (int)1024, (StreamProgress)streamProgress);
        }
        catch (IOException e) {
            try {
                throw new HttpException(e);
            }
            catch (Throwable throwable) {
                IoCommand.close(in);
                if (isCloseOut) {
                    IoCommand.close((Closeable)out);
                }
                throw throwable;
            }
        }
        IoCommand.close((Closeable)in);
        if (isCloseOut) {
            IoCommand.close((Closeable)out);
        }
        return l;
    }

    public static String toParams(Map<String, Object> paramMap) {
        return HttpUtil.toParams(paramMap, CharsetCommand.CHARSET_UTF_8);
    }

    public static String toParams(Map<String, Object> paramMap, String charsetName) {
        return HttpUtil.toParams(paramMap, CharsetCommand.charset((String)charsetName));
    }

    public static String toParams(Map<String, Object> paramMap, Charset charset) {
        if (CollectionCommand.isEmpty(paramMap)) {
            return "";
        }
        if (null == charset) {
            charset = CharsetCommand.CHARSET_UTF_8;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, Object> item : paramMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            sb.append(HttpUtil.encode(item.getKey(), charset)).append("=").append(HttpUtil.encode(Convert.toStr((Object)item.getValue()), charset));
        }
        return sb.toString();
    }

    public static Map<String, List<String>> decodeParams(String paramsStr, String charset) {
        int i;
        if (StringCommand.isBlank((CharSequence)paramsStr)) {
            return Collections.emptyMap();
        }
        int pathEndPos = paramsStr.indexOf(63);
        if (pathEndPos > 0) {
            paramsStr = StringCommand.subSuf((String)paramsStr, (int)(pathEndPos + 1));
        }
        paramsStr = HttpUtil.decode(paramsStr, charset);
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        String name = null;
        int pos = 0;
        for (i = 0; i < paramsStr.length(); ++i) {
            char c = paramsStr.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = paramsStr.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&' && c != ';') continue;
            if (name == null && pos != i) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "");
            } else if (name != null) {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i));
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "");
            } else {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i));
            }
        } else if (name != null) {
            HttpUtil.addParam(params, name, "");
        }
        return params;
    }

    public static String urlWithForm(String url, Map<String, Object> form) {
        String queryString = HttpUtil.toParams(form, "UTF-8");
        return HttpUtil.urlWithForm(url, queryString);
    }

    public static String urlWithForm(String url, String queryString) {
        if (StringCommand.isNotBlank((CharSequence)queryString)) {
            if (url.contains("?")) {
                url = url + "&" + queryString;
            }
            url = url + (url.endsWith("?") ? queryString : "?" + queryString);
        }
        return url;
    }

    public static String getCharset(HttpURLConnection conn) {
        if (conn == null) {
            return null;
        }
        String charset = ReUtil.get((Pattern)CHARSET_PATTERN, (String)conn.getContentType(), (int)1);
        return charset;
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (HttpUtil.isUnknow(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknow(String checkString) {
        return StringCommand.isBlank((CharSequence)checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static String getString(InputStream in, String charset, boolean isGetCharsetFromContent) throws IOException {
        if (StringCommand.isBlank((CharSequence)charset)) {
            charset = "UTF-8";
        }
        if (!isGetCharsetFromContent) {
            return IoCommand.read((InputStream)in, (String)charset);
        }
        StringBuilder content = new StringBuilder();
        BufferedReader reader = IoCommand.getReader((InputStream)in, (String)charset);
        String line = null;
        while ((line = reader.readLine()) != null) {
            String charsetInContent;
            content.append(line).append("\n");
            if (!isGetCharsetFromContent || !StringCommand.isNotBlank((CharSequence)(charsetInContent = ReUtil.get((Pattern)CHARSET_PATTERN, (String)line, (int)1)))) continue;
            StaticLog.debug((String)"Http content charset\uff1a{}", (Object[])new Object[]{charsetInContent});
            charset = charsetInContent;
            reader = IoCommand.getReader((InputStream)in, (String)charset);
            isGetCharsetFromContent = false;
        }
        return content.toString();
    }

    public static String getMimeType(String filePath) {
        return URLConnection.getFileNameMap().getContentTypeFor(filePath);
    }

    private static boolean addParam(Map<String, List<String>> params, String name, String value) {
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
        return true;
    }
}

