/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.web.http;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileUtil;
import org.gjgr.pig.chivalrous.core.json.JsonString;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.Base64;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.StaticLog;
import org.gjgr.pig.chivalrous.core.util.RandomCommand;
import org.gjgr.pig.chivalrous.core.util.ThreadUtil;
import org.gjgr.pig.chivalrous.web.http.Header;
import org.gjgr.pig.chivalrous.web.http.HttpBase;
import org.gjgr.pig.chivalrous.web.http.HttpConnection;
import org.gjgr.pig.chivalrous.web.http.HttpException;
import org.gjgr.pig.chivalrous.web.http.HttpResponse;
import org.gjgr.pig.chivalrous.web.http.HttpUtil;
import org.gjgr.pig.chivalrous.web.http.Method;
import org.gjgr.pig.chivalrous.web.http.ssl.SSLSocketFactoryBuilder;

public class HttpRequest
extends HttpBase<HttpRequest> {
    private static final String BOUNDARY = "--------------------Hutool_" + RandomCommand.randomString((int)16);
    private static final byte[] BOUNDARY_END = StringCommand.format((String)"--{}--\r\n", (Object[])new Object[]{BOUNDARY}).getBytes();
    private static final String CONTENT_DISPOSITION_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"\r\n\r\n";
    private static final String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"; filename=\"{}\"\r\n";
    private static final String CONTENT_TYPE_X_WWW_FORM_URLENCODED_PREFIX = "application/x-www-form-urlencoded;charset=";
    private static final String CONTENT_TYPE_MULTIPART_PREFIX = "multipart/form-data; boundary=";
    private static final String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type: {}\r\n\r\n";
    protected Map<String, Object> form;
    protected Map<String, File> fileForm;
    private String url = "";
    private Method method = Method.GET;
    private int timeout = -1;
    private HttpConnection httpConnection;
    private boolean isDisableCache;
    private Boolean isFollowRedirects;
    private int redirectCount;
    private Proxy proxy;
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory ssf;

    public HttpRequest(String url) {
        this.url = url;
    }

    public static HttpRequest post(String url) {
        return new HttpRequest(url).method(Method.POST);
    }

    public static HttpRequest get(String url) {
        return new HttpRequest(url).method(Method.GET);
    }

    public static HttpRequest head(String url) {
        return new HttpRequest(url).method(Method.HEAD);
    }

    public static HttpRequest options(String url) {
        return new HttpRequest(url).method(Method.OPTIONS);
    }

    public static HttpRequest put(String url) {
        return new HttpRequest(url).method(Method.PUT);
    }

    public static HttpRequest delete(String url) {
        return new HttpRequest(url).method(Method.DELETE);
    }

    public static HttpRequest trace(String url) {
        return new HttpRequest(url).method(Method.TRACE);
    }

    public HttpRequest method(Method method) {
        this.method = method;
        return this;
    }

    public HttpRequest contentType(String contentType) {
        this.header(Header.CONTENT_TYPE, contentType);
        return this;
    }

    public HttpRequest keepAlive(boolean isKeepAlive) {
        this.header(Header.CONNECTION, isKeepAlive ? "Keep-Alive" : "Close");
        return this;
    }

    public boolean isKeepAlive() {
        String connection = this.header(Header.CONNECTION);
        if (connection == null) {
            return !this.httpVersion.equalsIgnoreCase("HTTP/1.0");
        }
        return !"close".equalsIgnoreCase(connection);
    }

    public String contentLength() {
        return this.header(Header.CONTENT_LENGTH);
    }

    public HttpRequest contentLength(int value) {
        this.header(Header.CONTENT_LENGTH, String.valueOf(value));
        return this;
    }

    public HttpRequest form(String name, Object value) {
        if (StringCommand.isBlank((CharSequence)name) || ObjectCommand.isNull((Object)value)) {
            return this;
        }
        this.body = null;
        if (value instanceof File) {
            return this.form(name, (File)value);
        }
        if (this.form == null) {
            this.form = new HashMap<String, Object>();
        }
        String strValue = value instanceof List ? CollectionCommand.join((Iterable)((List)value), (String)",") : (ArrayCommand.isArray((Object)value) ? ArrayCommand.join((Object[])((Object[])value), (String)",") : Convert.toStr((Object)value, null));
        this.form.put(name, strValue);
        return this;
    }

    public HttpRequest form(String name, Object value, Object ... parameters) {
        this.form(name, value);
        for (int i = 0; i < parameters.length; i += 2) {
            name = parameters[i].toString();
            this.form(name, parameters[i + 1]);
        }
        return this;
    }

    public HttpRequest form(Map<String, Object> formMap) {
        for (Map.Entry<String, Object> entry : formMap.entrySet()) {
            this.form(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpRequest form(String name, File file) {
        if (null == file) {
            return this;
        }
        if (!this.isKeepAlive()) {
            this.keepAlive(true);
        }
        if (this.fileForm == null) {
            this.fileForm = new HashMap<String, File>();
        }
        this.fileForm.put(name, file);
        return this;
    }

    public Map<String, Object> form() {
        return this.form;
    }

    public HttpRequest body(String body) {
        this.body = body;
        this.form = null;
        this.contentLength(body.length());
        return this;
    }

    public HttpRequest body(String body, String contentType) {
        this.body(body);
        this.contentType(contentType);
        return this;
    }

    public HttpRequest body(JsonString json) {
        this.body(json.toString());
        String contentTypeJson = "application/newJson";
        if (StringCommand.isNotBlank((CharSequence)this.charset)) {
            contentTypeJson = StringCommand.format((String)"{};charset={}", (Object[])new Object[]{contentTypeJson, this.charset});
        }
        this.contentType(contentTypeJson);
        return this;
    }

    public HttpRequest body(byte[] bodyBytes) {
        return this.body(StringCommand.str((byte[])bodyBytes, (String)this.charset));
    }

    public HttpRequest timeout(int milliseconds) {
        this.timeout = milliseconds;
        return this;
    }

    public HttpRequest disableCache() {
        this.isDisableCache = true;
        return this;
    }

    public HttpRequest setFollowRedirects(Boolean isFollowRedirects) {
        this.isFollowRedirects = isFollowRedirects;
        return this;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public HttpRequest setSSLSocketFactory(SSLSocketFactory ssf) {
        this.ssf = ssf;
        return this;
    }

    public HttpRequest setSSLProtocol(String protocol) {
        if (null == this.ssf) {
            try {
                this.ssf = SSLSocketFactoryBuilder.create().setProtocol(protocol).build();
            }
            catch (Exception e) {
                throw new HttpException(e);
            }
        }
        return this;
    }

    public HttpResponse execute() {
        this.urlWithParamIfGet();
        this.initConnecton();
        this.send();
        HttpResponse httpResponse = this.sendRedirectIfPosible();
        if (null == httpResponse) {
            httpResponse = HttpResponse.readResponse(this.httpConnection);
        }
        this.httpConnection.disconnect();
        return httpResponse;
    }

    public Future<HttpResponse> asyncExecute() {
        return ThreadUtil.execAsync((Callable)new Callable<HttpResponse>(){

            @Override
            public HttpResponse call() throws Exception {
                return HttpRequest.this.execute();
            }
        });
    }

    public HttpRequest basicAuth(String username, String password) {
        String data = username.concat(":").concat(password);
        String base64 = Base64.encode((String)data, (String)this.charset);
        this.header("Authorization", "Basic " + base64, true);
        return this;
    }

    private void initConnecton() {
        this.httpConnection = HttpConnection.create(this.url, this.method, this.hostnameVerifier, this.ssf, this.timeout, this.proxy).header(this.headers, true);
        if (this.isDisableCache) {
            this.httpConnection.disableCache();
        }
        if (null != this.isFollowRedirects) {
            this.httpConnection.setInstanceFollowRedirects(this.isFollowRedirects);
        }
    }

    private void urlWithParamIfGet() {
        if (Method.GET.equals((Object)this.method)) {
            this.url = StringCommand.isNotBlank((CharSequence)this.body) ? HttpUtil.urlWithForm(this.url, this.body) : HttpUtil.urlWithForm(this.url, this.form);
        }
    }

    private HttpResponse sendRedirectIfPosible() {
        if (this.httpConnection.getHttpURLConnection().getInstanceFollowRedirects()) {
            int responseCode;
            try {
                responseCode = this.httpConnection.responseCode();
            }
            catch (IOException e) {
                throw new HttpException(e);
            }
            if (responseCode != 200 && (responseCode == 302 || responseCode == 301 || responseCode == 303)) {
                this.url = this.httpConnection.header(Header.LOCATION);
                if (this.redirectCount < 2) {
                    ++this.redirectCount;
                    return this.execute();
                }
                StaticLog.warn((String)"URL [{}] redirect count more than two !", (Object[])new Object[]{this.url});
            }
        }
        return null;
    }

    private void send() throws HttpException {
        try {
            if (Method.POST.equals((Object)this.method) || Method.PUT.equals((Object)this.method)) {
                if (CollectionCommand.isEmpty(this.fileForm)) {
                    this.sendFormUrlEncoded();
                } else {
                    this.sendMltipart();
                }
            } else {
                this.httpConnection.connect();
            }
        }
        catch (IOException e) {
            throw new HttpException(e.getMessage(), e);
        }
    }

    private void sendFormUrlEncoded() throws IOException {
        if (StringCommand.isBlank((CharSequence)this.header(Header.CONTENT_TYPE))) {
            this.httpConnection.header(Header.CONTENT_TYPE, CONTENT_TYPE_X_WWW_FORM_URLENCODED_PREFIX + this.charset, true);
        }
        String content = StringCommand.isNotBlank((CharSequence)this.body) ? this.body : HttpUtil.toParams(this.form, this.charset);
        IoCommand.write((OutputStream)this.httpConnection.getOutputStream(), (String)this.charset, (boolean)true, (Object[])new Object[]{content});
    }

    private void sendMltipart() throws IOException {
        this.setMultipart();
        OutputStream out = this.httpConnection.getOutputStream();
        try {
            this.writeFileForm(out);
            this.writeForm(out);
            this.formEnd(out);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            IoCommand.close((Closeable)out);
        }
    }

    private void writeForm(OutputStream out) throws IOException {
        if (CollectionCommand.isNotEmpty(this.form)) {
            StringBuilder builder = StringCommand.builder();
            for (Map.Entry<String, Object> entry : this.form.entrySet()) {
                builder.append("--").append(BOUNDARY).append("\r\n");
                builder.append(StringCommand.format((String)CONTENT_DISPOSITION_TEMPLATE, (Object[])new Object[]{entry.getKey()}));
                builder.append(entry.getValue()).append("\r\n");
            }
            IoCommand.write((OutputStream)out, (String)this.charset, (boolean)false, (Object[])new Object[]{builder});
        }
    }

    private void writeFileForm(OutputStream out) throws IOException {
        for (Map.Entry<String, File> entry : this.fileForm.entrySet()) {
            File file = entry.getValue();
            StringBuilder builder = StringCommand.builder().append("--").append(BOUNDARY).append("\r\n");
            builder.append(StringCommand.format((String)CONTENT_DISPOSITION_FILE_TEMPLATE, (Object[])new Object[]{entry.getKey(), file.getName()}));
            builder.append(StringCommand.format((String)CONTENT_TYPE_FILE_TEMPLATE, (Object[])new Object[]{HttpUtil.getMimeType(file.getName())}));
            IoCommand.write((OutputStream)out, (String)this.charset, (boolean)false, (Object[])new Object[]{builder});
            FileUtil.writeToStream((File)file, (OutputStream)out);
            IoCommand.write((OutputStream)out, (String)this.charset, (boolean)false, (Object[])new Object[]{"\r\n"});
        }
    }

    private void formEnd(OutputStream out) throws IOException {
        out.write(BOUNDARY_END);
        out.flush();
    }

    private void setMultipart() {
        this.httpConnection.header(Header.CONTENT_TYPE, CONTENT_TYPE_MULTIPART_PREFIX + BOUNDARY, true);
    }
}

