/*
 * Decompiled with CFR 0.152.
 */
package org.glamey.scaffold.component.sms.huanxin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.glamey.scaffold.component.exception.ComponentException;
import org.glamey.scaffold.component.sms.huanxin.HuanXinConstants;
import org.glamey.scaffold.json.JsonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class HuanXinRestAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(HuanXinRestAPI.class);
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_JSON = "application/json";
    private String baseUrl;
    private String clientId;
    private String clientSecret;
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient();
    private static final JsonMapper JSON_MAPPER = JsonMapper.create();
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json;charset=utf-8");

    private HuanXinRestAPI(Builder builder) {
        this.baseUrl = builder.BASE_URL;
        this.clientId = (String)StringUtils.defaultIfBlank((CharSequence)builder.CLIENT_ID, (CharSequence)"");
        this.clientSecret = (String)StringUtils.defaultIfBlank((CharSequence)builder.CLIENT_SECRET, (CharSequence)"");
    }

    public final Map<String, Object> token() throws IOException {
        Request request = new Request.Builder().url(this.baseUrl + "/token").headers(Headers.of((Map)ImmutableMap.of((Object)CONTENT_TYPE, (Object)APPLICATION_JSON))).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)JSON_MAPPER.toJson((Object)ImmutableMap.of((Object)"grant_type", (Object)"client_credentials", (Object)"client_id", (Object)this.clientId, (Object)"client_secret", (Object)this.clientSecret)))).build();
        return this.doRequest(request, String.format("\u83b7\u53d6token\u5f02\u5e38", new Object[0]));
    }

    public final Map<String, Object> accountInfo(String accountId) throws IOException {
        Assert.notNull((Object)StringUtils.isNotBlank((CharSequence)accountId), (String)"\u8d26\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        Request request = new Request.Builder().url(this.baseUrl + "/users/" + accountId).headers(this.buildTokenHeader()).get().build();
        return this.doRequest(request, String.format("\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u5931\u8d25,accountId=%s", accountId));
    }

    public final Map<String, Object> createAccount(String accountId, String password, String nickName) throws IOException {
        Assert.notNull((Object)(StringUtils.isNotBlank((CharSequence)accountId) && StringUtils.isNotBlank((CharSequence)password) ? 1 : 0), (String)"\u8d26\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap map = Maps.newHashMap();
        map.put("username", accountId);
        map.put("password", password);
        map.put("nickname", StringUtils.defaultIfBlank((CharSequence)nickName, (CharSequence)accountId));
        String requestBody = JSON_MAPPER.toJson((Object)map);
        Request request = new Request.Builder().url(this.baseUrl + "/users").headers(this.buildTokenHeader()).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)requestBody)).build();
        return this.doRequest(request, String.format("\u521b\u5efa\u8d26\u6237\u5931\u8d25,accountId=%s, password=%s,nickname=%s", accountId, password, nickName));
    }

    public final Map<String, Object> updateNickName(String accountId, String nickName) throws IOException {
        Assert.notNull((Object)(StringUtils.isNotBlank((CharSequence)accountId) && StringUtils.isNotBlank((CharSequence)nickName) ? 1 : 0), (String)"\u7528\u6237\u8d26\u6237ID\u548c\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap map = Maps.newHashMap();
        map.put("nickname", nickName);
        String requestBody = JSON_MAPPER.toJson((Object)map);
        Request request = new Request.Builder().url(this.baseUrl + "/users/" + accountId).headers(this.buildTokenHeader()).put(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)requestBody)).build();
        return this.doRequest(request, String.format("\u4fee\u6539\u7528\u6237\u6635\u79f0\u5931\u8d25,accountId=%s, nickname=%s", accountId, nickName));
    }

    private Map<String, Object> doRequest(Request request, String message) throws IOException {
        Response response = this.httpExecute(request);
        String result = response.body().string();
        LOGGER.info("response {}, request={}", (Object)result, (Object)request.toString());
        HashMap resultMap = (HashMap)JSON_MAPPER.fromJson(result, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        if (response.isSuccessful()) {
            return resultMap;
        }
        throw new ComponentException(response.code(), (String)resultMap.get("error_description"));
    }

    private Response httpExecute(Request request) throws IOException {
        return HTTP_CLIENT.newCall(request).execute();
    }

    private Headers buildTokenHeader() throws IOException {
        String token = HuanXinConstants.TOKEN;
        if (StringUtils.isBlank((CharSequence)token)) {
            Map<String, Object> tokenMap = this.token();
            token = (String)tokenMap.get("access_token");
        }
        ImmutableMap map = ImmutableMap.builder().put((Object)CONTENT_TYPE, (Object)APPLICATION_JSON).put((Object)"Authorization", (Object)("Bearer " + token)).build();
        return Headers.of((Map)map);
    }

    public static class Builder {
        private String BASE_URL;
        private String APP_KEY;
        private String ORG_NAME;
        private String APP_NAME;
        private String CLIENT_ID;
        private String CLIENT_SECRET;

        public Builder url(String baseUrl, String orgName, String appName) {
            Assert.state((StringUtils.isNotBlank((CharSequence)baseUrl) && StringUtils.isNotBlank((CharSequence)orgName) && StringUtils.isNotBlank((CharSequence)appName) ? 1 : 0) != 0, (String)"\u5e94\u7528\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            this.BASE_URL = new StringBuffer(baseUrl).append("/").append(orgName).append("/").append(appName).toString();
            this.APP_KEY = orgName + "#" + appName;
            this.ORG_NAME = orgName;
            this.APP_NAME = appName;
            return this;
        }

        public Builder auth(String clientId, String clientSecret) {
            Assert.state((StringUtils.isNotBlank((CharSequence)clientId) && StringUtils.isNotBlank((CharSequence)clientSecret) ? 1 : 0) != 0, (String)"APP\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
            this.CLIENT_ID = clientId;
            this.CLIENT_SECRET = clientSecret;
            return this;
        }

        public HuanXinRestAPI build() {
            return new HuanXinRestAPI(this);
        }
    }
}

