/*
 * Decompiled with CFR 0.152.
 */
package org.glamey.scaffold.component.sms.yuntongxun;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.glamey.scaffold.component.exception.ComponentException;
import org.glamey.scaffold.encryption.Base64Handler;
import org.glamey.scaffold.encryption.MD5Handler;
import org.glamey.scaffold.json.JsonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class YunTongXunRestAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(YunTongXunRestAPI.class);
    private String baseUrl;
    private String accountSid;
    private String accountToken;
    private String subAccountSid;
    private String subAccountToken;
    private String voipAccount;
    private String voipToken;
    private String appId;
    private String timeStamp;
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient();
    private static final JsonMapper JSON_MAPPER = JsonMapper.create();
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json;charset=utf-8");

    private YunTongXunRestAPI(Builder builder) {
        this.timeStamp = builder.TIME_STAMP;
        this.baseUrl = builder.BASE_URL;
        this.accountSid = (String)StringUtils.defaultIfBlank((CharSequence)builder.ACCOUNT_SID, (CharSequence)"");
        this.accountToken = (String)StringUtils.defaultIfBlank((CharSequence)builder.ACCOUNT_TOKEN, (CharSequence)"");
        this.subAccountSid = (String)StringUtils.defaultIfBlank((CharSequence)builder.SUBACCOUNT_SID, (CharSequence)"");
        this.subAccountToken = (String)StringUtils.defaultIfBlank((CharSequence)builder.SUBACCOUNT_TOKEN, (CharSequence)"");
        this.voipAccount = (String)StringUtils.defaultIfBlank((CharSequence)builder.VOIP_ACCOUNT, (CharSequence)"");
        this.voipToken = (String)StringUtils.defaultIfBlank((CharSequence)builder.VOIP_TOKEN, (CharSequence)"");
        this.appId = (String)StringUtils.defaultIfBlank((CharSequence)builder.APP_ID, (CharSequence)"");
    }

    public final Map<String, Object> accountInfo() throws IOException {
        Request request = new Request.Builder().url(this.buildBaseUrl("/AccountInfo", AccountType.ACCOUNT)).headers(this.buildHeader(0L, AccountType.ACCOUNT)).get().build();
        return this.doRequest(request, String.format("\u4e3b\u8d26\u6237\u4fe1\u606f\u67e5\u8be2,accountSid=%s", this.accountSid));
    }

    public final Map<String, Object> subAccounts(String friendlyName) throws IOException {
        Assert.notNull((Object)StringUtils.isNotBlank((CharSequence)friendlyName), (String)"\u5b50\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap map = Maps.newHashMap();
        map.put("appId", this.appId);
        map.put("friendlyName", friendlyName);
        String requestBody = JSON_MAPPER.toJson((Object)map);
        Request request = new Request.Builder().url(this.buildBaseUrl("/SubAccounts", AccountType.ACCOUNT)).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)requestBody)).headers(this.buildHeader(requestBody.length(), AccountType.ACCOUNT)).build();
        return this.doRequest(request, String.format("\u5b50\u8d26\u6237\u521b\u5efa\u5f02\u5e38,friendlyName=%s", friendlyName));
    }

    public final Map<String, Object> closeSubAccount(String subAccountSid) throws IOException {
        Assert.notNull((Object)StringUtils.isNotBlank((CharSequence)subAccountSid), (String)"\u5b50\u8d26\u6237SID\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap map = Maps.newHashMap();
        map.put("subAccountSid", subAccountSid);
        String requestBody = JSON_MAPPER.toJson((Object)map);
        Request request = new Request.Builder().url(this.buildBaseUrl("/CloseSubAccount", AccountType.ACCOUNT)).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)requestBody)).headers(this.buildHeader(requestBody.length(), AccountType.ACCOUNT)).build();
        return this.doRequest(request, String.format("\u5b50\u8d26\u6237\u5173\u95ed\u5f02\u5e38,subAccountSid=%s", subAccountSid));
    }

    public final Map<String, Object> querySubAccountByName(String friendlyName) throws IOException {
        Assert.notNull((Object)StringUtils.isNotBlank((CharSequence)friendlyName), (String)"\u5b50\u8d26\u6237\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap map = Maps.newHashMap();
        map.put("appId", this.appId);
        map.put("friendlyName", friendlyName);
        String requestBody = JSON_MAPPER.toJson((Object)map);
        Request request = new Request.Builder().url(this.buildBaseUrl("/QuerySubAccountByName", AccountType.ACCOUNT)).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)requestBody)).headers(this.buildHeader(requestBody.length(), AccountType.ACCOUNT)).build();
        return this.doRequest(request, String.format("\u5b50\u8d26\u6237\u4fe1\u606f\u67e5\u8be2,friendlyName=%s", friendlyName));
    }

    public final Map<String, Object> smsTemplateSMS(String[] mobiles, String templateId, String[] data) throws IOException {
        Assert.state((mobiles != null && StringUtils.isNotBlank((CharSequence)templateId) && data != null ? 1 : 0) != 0, (String)"\u53c2\u6570\u9519\u8bef");
        HashMap map = Maps.newHashMap();
        map.put("to", Joiner.on((String)",").join(Arrays.asList(mobiles)));
        map.put("appId", this.appId);
        map.put("templateId", "1");
        map.put("datas", data);
        String requestBody = JSON_MAPPER.toJson((Object)map);
        Request request = new Request.Builder().url(this.buildBaseUrl("/SMS/TemplateSMS", AccountType.ACCOUNT)).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)requestBody)).headers(this.buildHeader(requestBody.length(), AccountType.ACCOUNT)).build();
        return this.doRequest(request, String.format("\u8bf7\u6c42\u77ed\u4fe1\u6a21\u677f\u9a8c\u8bc1\u5931\u8d25,mobiles=%s,templateId=%s,data=%s", mobiles, templateId, data));
    }

    public final Map<String, Object> callsVoiceVerify(String mobile, String verifyCode, String displayNum, String playTimes) throws IOException {
        Assert.state((StringUtils.isNotBlank((CharSequence)mobile) && StringUtils.isNotBlank((CharSequence)verifyCode) ? 1 : 0) != 0, (String)"\u53c2\u6570\u9519\u8bef");
        playTimes = (String)StringUtils.defaultIfBlank((CharSequence)playTimes, (CharSequence)"3");
        displayNum = (String)StringUtils.defaultIfBlank((CharSequence)displayNum, (CharSequence)"\u70b9\u70b9\u65e0\u9650--\u9762\u8bd5\u5b98");
        HashMap map = Maps.newHashMap();
        map.put("appId", this.appId);
        map.put("verifyCode", verifyCode);
        map.put("to", mobile);
        map.put("displayNum", displayNum);
        map.put("playTimes", playTimes);
        String requestBody = JSON_MAPPER.toJson((Object)map);
        Request request = new Request.Builder().url(this.buildBaseUrl("/Calls/VoiceVerify", AccountType.ACCOUNT)).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)requestBody)).headers(this.buildHeader(requestBody.length(), AccountType.ACCOUNT)).build();
        return this.doRequest(request, String.format("\u8bf7\u6c42\u8bed\u97f3\u9a8c\u8bc1\u7801\u5931\u8d25,mobiles=%s,verifyCode=%s", mobile, verifyCode));
    }

    public final Map<String, Object> callsCallback(String from, String to, String customerSerNum, String fromSerNum, String promptTone, String alwaysPlay, String terminalDtmf, String userData, String maxCallTime, String hangupCdrUrl, String needBothCdr, String needRecord, String countDownTime, String countDownPrompt) throws IOException {
        Assert.state((StringUtils.isNotBlank((CharSequence)from) && StringUtils.isNotBlank((CharSequence)to) ? 1 : 0) != 0, (String)"\u4e3b\u53eb\u7535\u8bdd\u53f7\u7801\u3001\u88ab\u53eb\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap map = Maps.newHashMap();
        map.put("from", from);
        map.put("to", to);
        if (StringUtils.isNotBlank((CharSequence)customerSerNum)) {
            map.put("customerSerNum", customerSerNum);
        }
        if (StringUtils.isNotBlank((CharSequence)fromSerNum)) {
            map.put("fromSerNum", fromSerNum);
        }
        if (StringUtils.isNotBlank((CharSequence)promptTone)) {
            map.put("promptTone", promptTone);
        }
        if (StringUtils.isNotBlank((CharSequence)alwaysPlay)) {
            map.put("alwaysPlay", alwaysPlay);
        }
        if (StringUtils.isNotBlank((CharSequence)terminalDtmf)) {
            map.put("terminalDtmf", terminalDtmf);
        }
        if (StringUtils.isNotBlank((CharSequence)userData)) {
            map.put("userData", userData);
        }
        if (StringUtils.isNotBlank((CharSequence)maxCallTime)) {
            map.put("maxCallTime", maxCallTime);
        }
        if (StringUtils.isNotBlank((CharSequence)hangupCdrUrl)) {
            map.put("hangupCdrUrl", hangupCdrUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)needBothCdr)) {
            map.put("needBothCdr", needBothCdr);
        }
        if (StringUtils.isNotBlank((CharSequence)needRecord)) {
            map.put("needRecord", needRecord);
        }
        if (StringUtils.isNotBlank((CharSequence)countDownTime)) {
            map.put("countDownTime", countDownTime);
        }
        if (StringUtils.isNotBlank((CharSequence)countDownPrompt)) {
            map.put("countDownPrompt", countDownPrompt);
        }
        map.put("recordPoint", "0");
        String requestBody = JSON_MAPPER.toJson((Object)map);
        Request request = new Request.Builder().url(this.buildBaseUrl("/Calls/Callback", AccountType.SUB_ACCOUNT)).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)requestBody)).headers(this.buildHeader(requestBody.length(), AccountType.SUB_ACCOUNT)).build();
        return this.doRequest(request, String.format("\u8bf7\u6c42\u53cc\u5411\u56de\u62e8\u5f02\u5e38,subAccountSid=%s", this.subAccountSid));
    }

    private Map<String, Object> doRequest(Request request, String message) throws IOException {
        Response response = this.httpExecute(request);
        if (response.isSuccessful()) {
            String result = response.body().string();
            LOGGER.info("response {}, request={}", (Object)result, (Object)request.toString());
            return (Map)JSON_MAPPER.fromJson(result, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        throw new ComponentException(message);
    }

    private Response httpExecute(Request request) throws IOException {
        return HTTP_CLIENT.newCall(request).execute();
    }

    private Headers buildHeader(long bodySize, AccountType accountType) {
        StringBuffer buffer = new StringBuffer();
        if (accountType == AccountType.ACCOUNT) {
            buffer.append(this.accountSid);
        } else if (accountType == AccountType.SUB_ACCOUNT) {
            buffer.append(this.subAccountSid);
        }
        buffer.append(":");
        buffer.append(this.timeStamp);
        String authorization = Base64Handler.byteToString((byte[])buffer.toString().getBytes(Charsets.UTF_8));
        ImmutableMap map = ImmutableMap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"Content-Type", (Object)"application/json;charset=utf-8").put((Object)"Content-Length", (Object)String.valueOf(bodySize)).put((Object)"Authorization", (Object)authorization).build();
        return Headers.of((Map)map);
    }

    private String buildBaseUrl(String function, AccountType accountType) {
        StringBuffer buffer = new StringBuffer(this.baseUrl);
        buffer.append("/").append("2013-12-26");
        if (accountType == AccountType.ACCOUNT) {
            buffer.append("/Accounts/").append(this.accountSid);
            buffer.append(function).append("?sig=");
            buffer.append(new MD5Handler().getMD5(new StringBuffer(this.accountSid).append(this.accountToken).append(this.timeStamp).toString()).toUpperCase());
        } else if (accountType == AccountType.SUB_ACCOUNT) {
            buffer.append("/SubAccounts/").append(this.subAccountSid);
            buffer.append(function).append("?sig=");
            buffer.append(new MD5Handler().getMD5(new StringBuffer(this.subAccountSid).append(this.subAccountToken).append(this.timeStamp).toString()).toUpperCase());
        }
        return buffer.toString();
    }

    public static class Builder {
        private String BASE_URL;
        private String ACCOUNT_SID;
        private String ACCOUNT_TOKEN;
        private String SUBACCOUNT_SID;
        private String SUBACCOUNT_TOKEN;
        private String VOIP_ACCOUNT;
        private String VOIP_TOKEN;
        private String APP_ID;
        private String TIME_STAMP;

        public Builder url(String baseUrl) {
            Assert.state((boolean)StringUtils.isNotBlank((CharSequence)baseUrl), (String)"\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            this.BASE_URL = baseUrl;
            this.TIME_STAMP = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
            return this;
        }

        public Builder account(String accountSid, String accountAuth) {
            Assert.state((StringUtils.isNotBlank((CharSequence)accountSid) && StringUtils.isNotBlank((CharSequence)accountAuth) ? 1 : 0) != 0, (String)"\u4e3b\u8d26\u53f7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            this.ACCOUNT_SID = accountSid;
            this.ACCOUNT_TOKEN = accountAuth;
            return this;
        }

        public Builder subAccount(String subAccountSid, String subAccountAuth) {
            Assert.state((StringUtils.isNotBlank((CharSequence)subAccountSid) && StringUtils.isNotBlank((CharSequence)subAccountAuth) ? 1 : 0) != 0, (String)"\u5b50\u8d26\u53f7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            this.SUBACCOUNT_SID = subAccountSid;
            this.SUBACCOUNT_TOKEN = subAccountAuth;
            return this;
        }

        public Builder app(String appId) {
            Assert.state((boolean)StringUtils.isNotBlank((CharSequence)appId), (String)"APP_ID\u4e0d\u80fd\u4e3a\u7a7a");
            this.APP_ID = appId;
            return this;
        }

        public Builder voIPAccount(String voIPAccount, String voIPPassword) {
            Assert.state((StringUtils.isNotBlank((CharSequence)voIPAccount) && StringUtils.isNotBlank((CharSequence)voIPAccount) ? 1 : 0) != 0, (String)"VOIP\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            this.VOIP_ACCOUNT = voIPAccount;
            this.VOIP_TOKEN = voIPPassword;
            return this;
        }

        public YunTongXunRestAPI build() {
            return new YunTongXunRestAPI(this);
        }
    }

    static enum AccountType {
        ACCOUNT,
        SUB_ACCOUNT;

    }
}

