/*
 * Decompiled with CFR 0.152.
 */
package org.glamey.scaffold.component.sms.yuntongxun;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.glamey.scaffold.component.exception.ComponentException;
import org.glamey.scaffold.component.sms.SmsManufacturer;
import org.glamey.scaffold.component.sms.SmsTemplate;
import org.glamey.scaffold.component.sms.yuntongxun.YunTongXunInfo;
import org.glamey.scaffold.component.sms.yuntongxun.YunTongXunRestAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class YunTongXunSmsTemplate
implements SmsTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(YunTongXunSmsTemplate.class);
    @Resource
    private YunTongXunInfo yunTongXunInfo;

    @Override
    public void sendSmsContentOfText(String[] mobiles, String templateId, String[] data) throws IOException {
        Assert.notNull((Object)mobiles, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)data, (String)"\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        templateId = (String)StringUtils.defaultIfBlank((CharSequence)templateId, (CharSequence)this.yunTongXunInfo.getTemplateId());
        LOGGER.info("mobiles={}, templateId={}, data={}", new Object[]{mobiles, templateId, data});
        YunTongXunRestAPI api = this.yunTongXunInfo.initAPIAccount();
        Map<String, Object> resultMap = api.smsTemplateSMS(mobiles, templateId, data);
        String statusCode = (String)resultMap.get("statusCode");
        if (!StringUtils.equals((CharSequence)statusCode, (CharSequence)"000000")) {
            throw new ComponentException((String)resultMap.get("statusMsg"));
        }
    }

    @Override
    public void sendSmsContentOfVoice(String mobile, String verifyCode, String displayNum, String playTimes) throws IOException {
        Assert.notNull((Object)mobile, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)verifyCode, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LOGGER.info("mobile={}, verifyCode={}, displayNum={}, playTimes={}", new Object[]{mobile, verifyCode, displayNum, playTimes});
        YunTongXunRestAPI api = this.yunTongXunInfo.initAPIAccount();
        Map<String, Object> resultMap = api.callsVoiceVerify(mobile, verifyCode, displayNum, playTimes);
        String statusCode = (String)resultMap.get("statusCode");
        if (!StringUtils.equals((CharSequence)statusCode, (CharSequence)"000000")) {
            throw new ComponentException((String)resultMap.get("statusMsg"));
        }
    }

    @Override
    public SmsManufacturer manufacturer() {
        return SmsManufacturer.YUNTONGXUN;
    }
}

