/*
 * Decompiled with CFR 0.152.
 */
package org.glamey.scaffold.component.store.qiniu;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class QiNiuRestAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(QiNiuRestAPI.class);
    private String accessKey;
    private String secretKey;
    private String bucketName;
    private String bucketHash;
    private String serverDomain;

    private QiNiuRestAPI(Builder builder) {
        this.accessKey = builder.accessKey;
        this.secretKey = builder.secretKey;
        this.bucketName = builder.bucketName;
        this.bucketHash = builder.bucketHash;
        this.serverDomain = builder.serverDomain;
    }

    private Auth create() {
        Assert.notNull((Object)this.accessKey);
        Assert.notNull((Object)this.secretKey);
        return Auth.create((String)this.accessKey, (String)this.secretKey);
    }

    private String getUpToken() {
        Assert.notNull((Object)this.bucketName);
        return this.create().uploadToken(this.bucketName);
    }

    public String upload(String uploadFile, String fileName) throws QiniuException {
        Assert.notNull((Object)uploadFile);
        Assert.notNull((Object)fileName);
        UploadManager uploadManager = new UploadManager();
        Response res = uploadManager.put(uploadFile, fileName, this.getUpToken());
        LOGGER.info("upload file,uploadFile={}, fileName={}, response={}", new Object[]{uploadFile, fileName, res.bodyString()});
        return this.generateFileUrl(fileName);
    }

    public String upload(byte[] bytes, String fileName) throws QiniuException {
        Assert.notNull((Object)bytes);
        Assert.notNull((Object)fileName);
        UploadManager uploadManager = new UploadManager();
        Response res = uploadManager.put(bytes, fileName, this.getUpToken());
        LOGGER.info("upload file,fileName={}, response={}", (Object)fileName, (Object)res.bodyString());
        return this.generateFileUrl(fileName);
    }

    private String generateFileUrl(String fileName) {
        return "http://" + this.bucketHash + "." + this.serverDomain + "/" + fileName;
    }

    public static class Builder {
        private String accessKey;
        private String secretKey;
        private String bucketName;
        private String bucketHash;
        private String serverDomain;

        public Builder auth(String accessKey, String secretKey) {
            Assert.state((StringUtils.isNotBlank((CharSequence)accessKey) && StringUtils.isNotBlank((CharSequence)secretKey) ? 1 : 0) != 0);
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            return this;
        }

        public Builder bucket(String bucketName, String bucketHash, String serverDomain) {
            Assert.state((boolean)StringUtils.isNotBlank((CharSequence)bucketName));
            this.bucketName = bucketName;
            this.bucketHash = bucketHash;
            this.serverDomain = serverDomain;
            return this;
        }

        public QiNiuRestAPI build() {
            return new QiNiuRestAPI(this);
        }
    }
}

