/*
 * Decompiled with CFR 0.152.
 */
package org.glamey.scaffold.component.store.qiniu;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.glamey.scaffold.component.store.StoreTemplate;
import org.glamey.scaffold.component.store.qiniu.QiNiuInfo;
import org.glamey.scaffold.component.store.qiniu.QiNiuRestAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class QiNiuStoreTemplate
implements StoreTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(QiNiuStoreTemplate.class);
    @Resource
    private QiNiuInfo qiNiuInfo;

    @Override
    public String upload(File uploadFile, String fileName) throws IOException {
        Assert.notNull((Object)uploadFile);
        Assert.notNull((Object)fileName);
        QiNiuRestAPI restAPI = this.qiNiuInfo.authBucket();
        String fileUrl = restAPI.upload(Files.toByteArray((File)uploadFile), FilenameUtils.getName((String)fileName));
        LOGGER.info("upload the file success, return fileUrl={}", (Object)fileUrl);
        return fileUrl;
    }

    @Override
    public String upload(byte[] bytes, String fileName) throws IOException {
        Assert.notNull((Object)bytes);
        Assert.notNull((Object)fileName);
        QiNiuRestAPI restAPI = this.qiNiuInfo.authBucket();
        String fileUrl = restAPI.upload(bytes, FilenameUtils.getName((String)fileName));
        LOGGER.info("upload the file success, return fileUrl={}", (Object)fileUrl);
        return fileUrl;
    }
}

