/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.DeployedItemRefConfigCR;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.config.ResourceRefConfigCR;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.GuiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetUtil {
    public static final int APP_NO_TARGET = -2;
    public static final int APP_ALL_ENABLED = -1;
    public static final int APP_ALL_DISABLED = 0;

    private TargetUtil() {
    }

    public static boolean isResourceEnabled(Enabled resourceObject, String target) {
        boolean master = Boolean.valueOf(resourceObject.getEnabled());
        if (!master) {
            return false;
        }
        String name = ((AMX)resourceObject).getName();
        ResourceRefConfig ref = TargetUtil.getResourceRef(name, target);
        if (ref == null) {
            return master;
        }
        return Boolean.valueOf(ref.getEnabled());
    }

    public static Set getVirtualServers(String targetName) {
        ConfigConfig config = AMXRoot.getInstance().getConfigByInstanceOrClusterName(targetName);
        Set vsNames = config.getHTTPServiceConfig().getVirtualServerConfigMap().keySet();
        return vsNames;
    }

    public static void setVirtualServers(String appName, String targetName, String virtualServers) {
        DeployedItemRefConfig appRef = TargetUtil.getDeployedItemRefObject(appName, targetName);
        appRef.setVirtualServers(virtualServers);
    }

    public static String getAssociatedVS(String appName, String targetName) {
        DeployedItemRefConfig appRef = TargetUtil.getDeployedItemRefObject(appName, targetName);
        String vs = appRef.getVirtualServers();
        return vs;
    }

    public static void setResourceEnabled(Enabled resource, String target, boolean enabledFlag) {
        if (enabledFlag) {
            resource.setEnabled(Boolean.toString(enabledFlag));
        }
        String name = ((AMX)resource).getName();
        List<Map<String, ResourceRefConfig>> allResourceRefs = TargetUtil.getAllResourceRefConfig(target);
        for (Map<String, ResourceRefConfig> oneResourceMap : allResourceRefs) {
            ResourceRefConfig ref = oneResourceMap.get(name);
            ref.setEnabled(Boolean.toString(enabledFlag));
        }
    }

    public static ResourceRefConfig getResourceRef(String name, String target) {
        ClusterConfig cluster;
        StandaloneServerConfig server = (StandaloneServerConfig)AMXRoot.getInstance().getServersConfig().getStandaloneServerConfigMap().get(target);
        ResourceRefConfig ref = null;
        ref = server == null ? ((cluster = (ClusterConfig)AMXRoot.getInstance().getClustersConfig().getClusterConfigMap().get(target)) == null ? null : (ResourceRefConfig)cluster.getResourceRefConfigMap().get(name)) : (ResourceRefConfig)server.getResourceRefConfigMap().get(name);
        return ref;
    }

    public static List<Map<String, ResourceRefConfig>> getAllResourceRefConfig(String target) {
        ArrayList<Map<String, ResourceRefConfig>> allResourceRefs = new ArrayList<Map<String, ResourceRefConfig>>();
        if (TargetUtil.isCluster(target)) {
            ClusterConfig cluster = (ClusterConfig)AMXRoot.getInstance().getClustersConfig().getClusterConfigMap().get(target);
            allResourceRefs.add(cluster.getResourceRefConfigMap());
            Map clusteredServerConfigMap = cluster.getClusteredServerConfigMap();
            Collection csConfigs = clusteredServerConfigMap.values();
            for (ClusteredServerConfig csConfig : csConfigs) {
                allResourceRefs.add(csConfig.getResourceRefConfigMap());
            }
        } else {
            StandaloneServerConfig server = (StandaloneServerConfig)AMXRoot.getInstance().getServersConfig().getStandaloneServerConfigMap().get(target);
            allResourceRefs.add(server.getResourceRefConfigMap());
        }
        return allResourceRefs;
    }

    public static void createResourceRef(String name, String targetName) {
        ResourceRefConfigCR target = TargetUtil.getResoruceRefConfigCR(targetName);
        if (target != null) {
            target.createResourceRefConfig(name);
        }
    }

    public static void createResourceRef(String name, String targetName, boolean enabled) {
        ResourceRefConfigCR target = TargetUtil.getResoruceRefConfigCR(targetName);
        if (target != null) {
            target.createResourceRefConfig(name, enabled);
        }
    }

    public static Set<String> XMinusY(Collection<String> X, Collection<String> Y) {
        Set<String> s = Collections.synchronizedSet(new HashSet<String>(X));
        if (Y != null && Y.size() != 0) {
            for (String str : Y) {
                s.remove(str);
            }
        }
        return s;
    }

    public static void removeResourceRef(String name, String targetName) {
        ResourceRefConfigCR target = TargetUtil.getResoruceRefConfigCR(targetName);
        if (target != null) {
            target.removeResourceRefConfig(name);
        }
    }

    public static ResourceRefConfigCR getResoruceRefConfigCR(String targetName) {
        ResourceRefConfigCR target = (ResourceRefConfigCR)AMXRoot.getInstance().getServersConfig().getStandaloneServerConfigMap().get(targetName);
        if (target == null && (target = (ResourceRefConfigCR)AMXRoot.getInstance().getClustersConfig().getClusterConfigMap().get(targetName)) == null) {
            return null;
        }
        return target;
    }

    public static boolean isApplicationEnabled(Enabled app, String target) {
        return TargetUtil.isApplicationEnabled(app, target, false);
    }

    public static boolean isApplicationEnabled(Enabled app, String target, Boolean forLB) {
        boolean master = Boolean.valueOf(app.getEnabled());
        if (!master) {
            return false;
        }
        String name = ((AMX)app).getName();
        DeployedItemRefConfig ref = TargetUtil.getDeployedItemRefObject(name, target);
        if (forLB.booleanValue()) {
            if (ref != null) {
                return Boolean.valueOf(ref.getLBEnabled());
            }
            return false;
        }
        if (ref == null) {
            return master;
        }
        return Boolean.valueOf(ref.getEnabled());
    }

    public static void setApplicationEnabled(Enabled app, String target, boolean enabledFlag) {
        TargetUtil.setApplicationEnabled(app, target, enabledFlag, false);
    }

    public static void setApplicationEnabled(Enabled app, String target, boolean enabledFlag, boolean forLB) {
        String name = ((AMX)app).getName();
        DeployedItemRefConfig ref = TargetUtil.getDeployedItemRefObject(name, target);
        if (forLB) {
            if (ref != null) {
                ref.setLBEnabled(Boolean.toString(enabledFlag));
            }
            return;
        }
        if (enabledFlag) {
            app.setEnabled("true");
        }
        if (ref != null) {
            ref.setEnabled(Boolean.toString(enabledFlag));
        }
    }

    public static DeployedItemRefConfig getDeployedItemRefObject(String name, String target) {
        ClusterConfig cluster;
        StandaloneServerConfig server = (StandaloneServerConfig)AMXRoot.getInstance().getServersConfig().getStandaloneServerConfigMap().get(target);
        DeployedItemRefConfig ref = null;
        ref = server == null ? ((cluster = (ClusterConfig)AMXRoot.getInstance().getClustersConfig().getClusterConfigMap().get(target)) == null ? null : (DeployedItemRefConfig)cluster.getDeployedItemRefConfigMap().get(name)) : (DeployedItemRefConfig)server.getDeployedItemRefConfigMap().get(name);
        return ref;
    }

    public static void createDeployedItemRefObject(String name, String targetName) {
        DeployedItemRefConfigCR target = (DeployedItemRefConfigCR)AMXRoot.getInstance().getServersConfig().getStandaloneServerConfigMap().get(targetName);
        if (target == null && (target = (DeployedItemRefConfigCR)AMXRoot.getInstance().getClustersConfig().getClusterConfigMap().get(targetName)) == null) {
            return;
        }
        target.createDeployedItemRefConfig(name);
    }

    public static void removeDeployedItemRefObject(String name, String targetName) {
        DeployedItemRefConfigCR target = (DeployedItemRefConfigCR)AMXRoot.getInstance().getServersConfig().getStandaloneServerConfigMap().get(targetName);
        if (target == null && (target = (DeployedItemRefConfigCR)AMXRoot.getInstance().getClustersConfig().getClusterConfigMap().get(targetName)) == null) {
            return;
        }
        target.removeDeployedItemRefConfig(name);
    }

    public static void createNewTargets(HandlerContext handlerCtx, String name) {
        Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        String[] selTargets = new String[]{"server"};
        if (AMXRoot.getInstance().isEE()) {
            selTargets = (String[])handlerCtx.getInputValue("targets");
        }
        List<String> targets = Arrays.asList(selTargets);
        for (String targetName : targets) {
            TargetUtil.createResourceRef(name, targetName, enabled);
        }
    }

    public static String getEnabledStatus(Enabled app, boolean isApp) {
        if (AMXRoot.getInstance().isEE()) {
            List<String> targetList = TargetUtil.getDeployedTargets((AMX)app, isApp);
            if (targetList.size() == 0) {
                return TargetUtil.convertStatusSummary(-2);
            }
            int total = 0;
            for (String target : targetList) {
                if (isApp) {
                    if (!TargetUtil.isApplicationEnabled(app, target)) continue;
                    ++total;
                    continue;
                }
                if (!TargetUtil.isResourceEnabled(app, target)) continue;
                ++total;
            }
            if (total == targetList.size()) {
                return TargetUtil.convertStatusSummary(-1);
            }
            if (total == 0) {
                return TargetUtil.convertStatusSummary(0);
            }
            return TargetUtil.convertStatusSummary(total);
        }
        boolean status = isApp ? TargetUtil.isApplicationEnabled(app, "server") : TargetUtil.isResourceEnabled(app, "server");
        return Boolean.toString(status);
    }

    public static List<String> getDeployedTargets(AMX app, boolean isApp) {
        String appName = app.getName();
        return TargetUtil.getDeployedTargets(appName, isApp);
    }

    public static List<String> getDeployedTargets(String appName, boolean isApp) {
        String objectName;
        ArrayList<String> targetList = new ArrayList<String>();
        String string = objectName = isApp ? "com.sun.appserv:type=applications,category=config" : "com.sun.appserv:type=resources,category=config";
        if (!AMXRoot.getInstance().isEE()) {
            targetList.add("server");
        } else {
            String[] params = new String[]{appName};
            String[] types = new String[]{"java.lang.String"};
        }
        return targetList;
    }

    public static String convertStatusSummary(int statusSummary) {
        String disp = null;
        disp = statusSummary == -1 ? GuiUtil.getMessage("deploy.allEnabled") : (statusSummary == 0 ? GuiUtil.getMessage("deploy.allDisabled") : (statusSummary == -2 ? GuiUtil.getMessage("deploy.noTarget") : GuiUtil.getMessage("deploy.someEnabled", new String[]{"" + statusSummary})));
        return disp;
    }

    public static String getDomainRoot() {
        String domainRoot = System.getProperty("com.sun.aas.instanceRoot");
        return domainRoot;
    }

    public static boolean isCluster(String name) {
        return false;
    }
}

