/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.UploadDownloadMgr;
import com.sun.appserv.management.client.AMXBooter;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ApplicationsConfig;
import com.sun.appserv.management.config.ClustersConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ConfigsConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.IIOPListenerConfig;
import com.sun.appserv.management.config.IIOPServiceConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.PropertyConfig;
import com.sun.appserv.management.config.ResourcesConfig;
import com.sun.appserv.management.config.ServersConfig;
import com.sun.appserv.management.ext.realm.RealmsMgr;
import com.sun.appserv.management.ext.runtime.RuntimeMgr;
import com.sun.appserv.management.ext.wsmgmt.WebServiceEndpointInfo;
import com.sun.appserv.management.ext.wsmgmt.WebServiceMgr;
import com.sun.appserv.management.j2ee.J2EEDomain;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.appserv.management.j2ee.StateManageable;
import com.sun.appserv.management.monitor.MonitoringRoot;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.servlet.ServletContext;
import org.glassfish.admingui.common.util.GuiUtil;
import org.jvnet.hk2.component.Habitat;

public class AMXRoot {
    private static AMXRoot amxRoot = null;
    private final DomainRoot domainRoot;
    private final DomainConfig domainConfig;
    private final ApplicationsConfig applicationsConfig;
    private final ConfigsConfig configsConfig;
    private final J2EEDomain j2eeDomain;
    private final MonitoringRoot monitoringRoot;
    private final QueryMgr queryMgr;
    private final UploadDownloadMgr uploadDownloadMgr;
    private final WebServiceMgr webServiceMgr;
    private final MBeanServerConnection mbaenServerConnection;
    private final ResourcesConfig resourcesConfig;
    private final ServersConfig serversConfig;
    private final ClustersConfig clustersConfig;
    private final RealmsMgr realmsMgr;
    private final RuntimeMgr runtimeMgr;
    private static final Map<Integer, String> stateImageMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> stateMap;

    private AMXRoot(DomainRoot dd, MBeanServerConnection msc) {
        this.domainRoot = dd;
        this.domainConfig = dd.getDomainConfig();
        this.configsConfig = (ConfigsConfig)this.domainRoot.getQueryMgr().querySingletonJ2EEType("X-ConfigsConfig");
        this.j2eeDomain = this.domainRoot.getJ2EEDomain();
        this.monitoringRoot = this.domainRoot.getMonitoringRoot();
        this.queryMgr = this.domainRoot.getQueryMgr();
        this.uploadDownloadMgr = this.domainRoot.getUploadDownloadMgr();
        this.webServiceMgr = this.domainRoot.getWebServiceMgr();
        this.mbaenServerConnection = msc;
        this.resourcesConfig = this.domainConfig.getResourcesConfig();
        this.applicationsConfig = this.domainConfig.getApplicationsConfig();
        this.serversConfig = this.domainConfig.getServersConfig();
        this.clustersConfig = this.domainConfig.getClustersConfig();
        this.realmsMgr = this.domainRoot.getRealmsMgr();
        this.runtimeMgr = this.domainRoot.getRuntimeMgr();
    }

    public static synchronized AMXRoot getInstance() {
        if (amxRoot == null) {
            ServletContext servletCtx = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
            Habitat habitat = (Habitat)servletCtx.getAttribute("org.glassfish.servlet.habitat");
            MBeanServer mbs = (MBeanServer)habitat.getComponent(MBeanServer.class);
            if (mbs == null) {
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            if (mbs == null) {
                System.out.println("!!!!!!!!!!!!!!  Cannot get to MBeanServer");
            }
            AMXBooter.bootAMX((MBeanServerConnection)mbs);
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServer)mbs).getDomainRoot();
            domainRoot.waitAMXReady();
            amxRoot = new AMXRoot(domainRoot, mbs);
        }
        return amxRoot;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbaenServerConnection;
    }

    public DomainConfig getDomainConfig() {
        return this.domainConfig;
    }

    public ConfigsConfig getConfigsConfig() {
        return this.configsConfig;
    }

    public ResourcesConfig getResourcesConfig() {
        return this.resourcesConfig;
    }

    public ApplicationsConfig getApplicationsConfig() {
        return this.applicationsConfig;
    }

    public ServersConfig getServersConfig() {
        return this.serversConfig;
    }

    public ClustersConfig getClustersConfig() {
        return this.clustersConfig;
    }

    public J2EEDomain getJ2EEDomain() {
        return this.j2eeDomain;
    }

    public MonitoringRoot getMonitoringRoot() {
        return this.monitoringRoot;
    }

    public WebServiceMgr getWebServiceMgr() {
        return this.webServiceMgr;
    }

    public DomainRoot getDomainRoot() {
        return this.domainRoot;
    }

    public QueryMgr getQueryMgr() {
        return this.queryMgr;
    }

    public RealmsMgr getRealmsMgr() {
        return this.realmsMgr;
    }

    public RuntimeMgr getRuntimeMgr() {
        return this.runtimeMgr;
    }

    public UploadDownloadMgr getUploadDownloadMgr() {
        return this.uploadDownloadMgr;
    }

    public ServerRootMonitor getServerRootMonitor(String instanceName) {
        if (GuiUtil.isEmpty(instanceName)) {
            return null;
        }
        return (ServerRootMonitor)this.monitoringRoot.getServerRootMonitorMap().get(instanceName);
    }

    public ConfigConfig getConfig(String configName) {
        if (GuiUtil.isEmpty(configName)) {
            return null;
        }
        Map cmap = this.configsConfig.getConfigConfigMap();
        ConfigConfig config = (ConfigConfig)cmap.get(configName);
        return config;
    }

    public String getConfigName(String name) {
        Map sm = this.domainConfig.getServersConfig().getStandaloneServerConfigMap();
        Map cm = this.domainConfig.getServersConfig().getClusteredServerConfigMap();
        return "server-config";
    }

    public ConfigConfig getConfigByInstanceOrClusterName(String instanceName) {
        return this.getConfig(this.getConfigName(instanceName));
    }

    public HTTPListenerConfig getHTTPListenerConfig(String configName, String listenerName) {
        HTTPServiceConfig service;
        if (GuiUtil.isEmpty(configName) || GuiUtil.isEmpty(listenerName)) {
            return null;
        }
        ConfigConfig config = this.getConfig(configName);
        HTTPServiceConfig hTTPServiceConfig = service = config == null ? null : config.getHTTPServiceConfig();
        if (service != null) {
            Map listeners = service.getHTTPListenerConfigMap();
            HTTPListenerConfig listener = (HTTPListenerConfig)listeners.get(listenerName);
            return listener;
        }
        return null;
    }

    public IIOPListenerConfig getIIOPListenerConfig(String configName, String listenerName) {
        IIOPServiceConfig service;
        if (GuiUtil.isEmpty(configName) || GuiUtil.isEmpty(listenerName)) {
            return null;
        }
        ConfigConfig config = this.getConfig(configName);
        IIOPServiceConfig iIOPServiceConfig = service = config == null ? null : config.getIIOPServiceConfig();
        if (service != null) {
            Map listeners = service.getIIOPListenerConfigMap();
            IIOPListenerConfig listener = (IIOPListenerConfig)listeners.get(listenerName);
            return listener;
        }
        return null;
    }

    public boolean isEE() {
        return false;
    }

    public boolean supportCluster() {
        return false;
    }

    public void editProperties(HandlerContext handlerCtx, PropertiesAccess config) {
        Map addProps = (Map)handlerCtx.getInputValue("AddProps");
        ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
        if (removeProps != null) {
            for (int i = 0; i < removeProps.size(); ++i) {
                config.removePropertyConfig((String)removeProps.get(i));
            }
        }
        if (addProps != null) {
            Map pMap = config.getPropertyConfigMap();
            for (String key : addProps.keySet()) {
                String value = (String)addProps.get(key);
                if (pMap.containsKey(key)) {
                    ((PropertyConfig)pMap.get(key)).setValue(value);
                    continue;
                }
                config.createPropertyConfig(key, value);
            }
        }
    }

    public WebServiceEndpointInfo getWebServiceEndpointInfo(Object webServiceKey) {
        return this.webServiceMgr.getWebServiceEndpointInfo(webServiceKey);
    }

    public String getStatusForDisplay(AMX obj, boolean includeString) {
        boolean restart;
        if (!(obj instanceof StateManageable)) {
            return "";
        }
        int state = ((StateManageable)obj).getstate();
        if (obj instanceof J2EEServer && state == 1 && (restart = ((J2EEServer)obj).getRestartRequired())) {
            String image = GuiUtil.getMessage("common.restartRequiredImage");
            return includeString ? image + "&nbsp;" + GuiUtil.getMessage("common.restartRequired") : image;
        }
        if (includeString) {
            return this.getStatusImage(state) + "&nbsp;" + this.getStatusString(state);
        }
        return this.getStatusImage(state);
    }

    public String getStatusImage(int state) {
        return stateImageMap.get(state);
    }

    public String getStatusString(int state) {
        return stateMap.get(state);
    }

    static {
        stateImageMap.put(4, GuiUtil.getMessage("common.failedImage"));
        stateImageMap.put(1, GuiUtil.getMessage("common.runningImage"));
        stateImageMap.put(0, GuiUtil.getMessage("common.startingImage"));
        stateImageMap.put(3, GuiUtil.getMessage("common.stoppedImage"));
        stateImageMap.put(2, GuiUtil.getMessage("common.stoppingImage"));
        stateMap = new HashMap<Integer, String>();
        stateMap.put(4, GuiUtil.getMessage("common.failedState"));
        stateMap.put(1, GuiUtil.getMessage("common.runningState"));
        stateMap.put(0, GuiUtil.getMessage("common.startingState"));
        stateMap.put(3, GuiUtil.getMessage("common.stoppedState"));
        stateMap.put(2, GuiUtil.getMessage("common.stoppingState"));
    }
}

