/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.proxy.AMXBooter;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.intf.config.Config;
import org.glassfish.admin.amx.intf.config.Configs;
import org.glassfish.admin.amx.intf.config.DeployedItemRef;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.intf.config.HttpService;
import org.glassfish.admin.amx.intf.config.VirtualServer;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListener;
import org.glassfish.admingui.common.util.GuiUtil;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V3AMX {
    private static V3AMX v3amx;
    private final DomainRoot domainRoot;
    private final Domain domain;
    private final ProxyFactory proxyFactory;
    private final MBeanServerConnection mbeanServer;
    private static final List skipAttr;

    private V3AMX(DomainRoot dd, MBeanServerConnection msc) {
        this.proxyFactory = ProxyFactory.getInstance((MBeanServerConnection)msc);
        this.domainRoot = dd;
        this.domain = (Domain)this.domainRoot.getDomain().as(Domain.class);
        this.mbeanServer = msc;
    }

    public static synchronized V3AMX getInstance() {
        if (v3amx == null) {
            ServletContext servletCtx = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
            Habitat habitat = (Habitat)servletCtx.getAttribute("org.glassfish.servlet.habitat");
            MBeanServer mbs = (MBeanServer)habitat.getComponent(MBeanServer.class);
            if (mbs == null) {
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            if (mbs == null) {
                System.out.println("!!!!!!!!!!!!!!  Cannot get to MBeanServer");
            }
            AMXBooter.bootAMX((MBeanServerConnection)mbs);
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServer)mbs).getDomainRootProxy();
            v3amx = new V3AMX(domainRoot, mbs);
        }
        return v3amx;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public DomainRoot getDomainRoot() {
        return this.domainRoot;
    }

    public Configs getConfigs() {
        return this.domain.getConfigs();
    }

    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public AMXProxy getProxy(ObjectName objName) {
        return this.proxyFactory.getProxy(objName);
    }

    public MBeanServerConnection getMbeanServerConnection() {
        return this.mbeanServer;
    }

    public static Config getServerConfig(String configName) {
        if (configName == null || configName.equals("")) {
            configName = "server-config";
        }
        return (Config)V3AMX.getInstance().getConfigs().getConfig().get(configName);
    }

    public static void setAttribute(String objectName, Attribute attributeName) {
        try {
            V3AMX.setAttribute(new ObjectName(objectName), attributeName);
        }
        catch (MalformedObjectNameException ex) {
            System.out.println("MalformedObjectNameException: " + objectName);
            throw new RuntimeException(ex);
        }
    }

    public static void setAttribute(ObjectName objectName, Attribute attributeName) {
        try {
            V3AMX.getInstance().getMbeanServerConnection().setAttribute(objectName, attributeName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setAttributes(Object name, Map<String, Object> attrMap) {
        try {
            ObjectName objectName = null;
            objectName = name instanceof String ? new ObjectName((String)name) : (ObjectName)name;
            AttributeList attrList = new AttributeList();
            V3AMX.removeElement(attrMap);
            for (String key : attrMap.keySet()) {
                Object val;
                if (skipAttr.contains(key) || (val = attrMap.get(key)) != null && !(val instanceof String)) continue;
                Attribute attr = new Attribute(key, (String)val);
                attrList.add(attr);
            }
            V3AMX.setAttributes(objectName, attrList);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setAttributes(ObjectName objectName, AttributeList attrList) {
        try {
            V3AMX.getInstance().getMbeanServerConnection().setAttributes(objectName, attrList);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getHttpPortNumber(String serverName, String configName) {
        StringBuffer ports = new StringBuffer();
        try {
            Config config = V3AMX.getServerConfig(configName);
            Map nls = ((NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class)).getNetworkListeners().getNetworkListener();
            for (NetworkListener listener : nls.values()) {
                String port = (String)listener.attributesMap().get("Port");
                ports = ports.append("," + port);
            }
            if (ports.length() > 0) {
                ports.deleteCharAt(0);
            }
            return ports.toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getPortForApplication(String appName) {
        try {
            String vsId;
            String objectNameStr = "v3:pp=/domain/servers,type=server,name=server";
            AMXProxy server = V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectNameStr));
            DeployedItemRef appRef = (DeployedItemRef)((AMXProxy)server.childrenMap("application-ref").get(appName)).as(DeployedItemRef.class);
            NetworkListener listener = null;
            listener = appRef == null ? V3AMX.getListener() : ((vsId = appRef.getVirtualServers()) == null || vsId.length() == 0 ? V3AMX.getListener() : V3AMX.getListener(vsId));
            if (listener == null) {
                return null;
            }
            String port = (String)listener.attributesMap().get("Port");
            String security = (String)listener.findProtocol().attributesMap().get("SecurityEnabled");
            return "true".equals(security) ? "-" + port : port;
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static NetworkListener getListener() {
        Map vsMap = V3AMX.getServerConfig("server-config").getHttpService().getVirtualServer();
        return V3AMX.getOneVsWithNetworkListener(new ArrayList<String>(vsMap.keySet()));
    }

    private static NetworkListener getListener(String vsIds) {
        return V3AMX.getOneVsWithNetworkListener(GuiUtil.parseStringList(vsIds, ","));
    }

    private static NetworkListener getOneVsWithNetworkListener(List<String> vsList) {
        if (vsList == null || vsList.size() == 0) {
            return null;
        }
        NetworkListener secureListener = null;
        HttpService hConfig = V3AMX.getServerConfig("server-config").getHttpService();
        Map vsMap = V3AMX.getServerConfig("server-config").getHttpService().getVirtualServer();
        for (String vsName : vsList) {
            VirtualServer vs;
            String listener;
            if (vsName.equals("__asadmin") || GuiUtil.isEmpty(listener = (String)(vs = (VirtualServer)vsMap.get(vsName)).attributesMap().get("NetworkListeners"))) continue;
            List hpList = GuiUtil.parseStringList(listener, ",");
            for (String one : hpList) {
                NetworkListener oneListener = (NetworkListener)((NetworkConfig)V3AMX.getServerConfig("server-config").getNetworkConfig().as(NetworkConfig.class)).getNetworkListeners().getNetworkListener().get(one);
                if (!"true".equals(oneListener.attributesMap().get("Enabled"))) continue;
                String security = (String)oneListener.findProtocol().attributesMap().get("SecurityEnabled");
                if ("true".equals(security)) {
                    secureListener = oneListener;
                    continue;
                }
                return oneListener;
            }
        }
        return secureListener;
    }

    public static void removeElement(Map<String, Object> attrs) {
        Set<Map.Entry<String, Object>> attrSet = attrs.entrySet();
        Iterator<Map.Entry<String, Object>> iter = attrSet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> oneEntry = iter.next();
            Object val = oneEntry.getValue();
            if (!(val instanceof ObjectName) && !(val instanceof ObjectName[])) continue;
            iter.remove();
        }
    }

    public static void removeSpecifiedAttr(Map<String, Object> attrs, List removeList) {
        if (removeList == null || removeList.size() <= 0) {
            return;
        }
        Set<Map.Entry<String, Object>> attrSet = attrs.entrySet();
        Iterator<Map.Entry<String, Object>> iter = attrSet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> oneEntry = iter.next();
            if (!removeList.contains(oneEntry.getKey())) continue;
            iter.remove();
        }
    }

    static {
        skipAttr = new ArrayList();
        skipAttr.add("Parent");
        skipAttr.add("Name");
        skipAttr.add("Children");
    }
}

