/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.amx.base.Runtime;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;
import org.glassfish.deployment.client.DFDeploymentProperties;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;

public class DeploymentHandler {
    public static final String KEEP_SESSIONS = "keepSessions";

    public static void deploy(HandlerContext handlerCtx) {
        Properties deploymentProps = new Properties();
        String appName = (String)handlerCtx.getInputValue("appName");
        String origPath = (String)handlerCtx.getInputValue("origPath");
        String filePath = (String)handlerCtx.getInputValue("filePath");
        String ctxtRoot = (String)handlerCtx.getInputValue("ctxtRoot");
        String[] vs = (String[])handlerCtx.getInputValue("VS");
        String enabled = (String)handlerCtx.getInputValue("enabled");
        String libraries = (String)handlerCtx.getInputValue("libraries");
        String precompile = (String)handlerCtx.getInputValue("precompileJSP");
        String desc = (String)handlerCtx.getInputValue("description");
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        if (targets == null || targets.length == 0 || !V3AMX.getInstance().isEE()) {
            targets = null;
        }
        if (GuiUtil.isEmpty(origPath)) {
            String mesg = GuiUtil.getMessage("msg.deploy.nullArchiveError");
            GuiUtil.handleError(handlerCtx, mesg);
            return;
        }
        deploymentProps.setProperty("name", appName != null ? appName : "");
        if (!GuiUtil.isEmpty(ctxtRoot)) {
            deploymentProps.setProperty("contextroot", ctxtRoot);
        }
        deploymentProps.setProperty("enabled", enabled != null ? enabled : "false");
        deploymentProps.setProperty("libraries", libraries != null ? libraries : "");
        deploymentProps.setProperty("description", desc != null ? desc : "");
        deploymentProps.setProperty("precompilejsp", precompile != null ? precompile : "false");
        if (vs != null && vs.length > 0 && !GuiUtil.isEmpty(vs[0])) {
            String vsTargets = GuiUtil.arrayToString(vs, ",");
            deploymentProps.setProperty("virtualservers", vsTargets);
        }
        try {
            DeployUtil.deploy(targets, deploymentProps, filePath, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void deploy2(HandlerContext handlerCtx) {
        String appType = (String)handlerCtx.getInputValue("appType");
        String origPath = (String)handlerCtx.getInputValue("origPath");
        String filePath = (String)handlerCtx.getInputValue("filePath");
        Map allMaps = (Map)handlerCtx.getInputValue("allMaps");
        HashMap<String, String> attrMap = new HashMap<String, String>((Map)allMaps.get(appType));
        if (GuiUtil.isEmpty(origPath)) {
            String mesg = GuiUtil.getMessage("msg.deploy.nullArchiveError");
            GuiUtil.handleError(handlerCtx, mesg);
            return;
        }
        DFDeploymentProperties deploymentProps = new DFDeploymentProperties();
        String[] vs = (String[])attrMap.get("virtualservers");
        if (vs != null && vs.length > 0 && !GuiUtil.isEmpty(vs[0])) {
            String vsTargets = GuiUtil.arrayToString(vs, ",");
            deploymentProps.setProperty("virtualservers", vsTargets);
        }
        attrMap.remove("virtualservers");
        List convertToFalseList = (List)attrMap.get("convertToFalseList");
        if (convertToFalseList != null) {
            for (String one : convertToFalseList) {
                if (attrMap.get(one) != null) continue;
                attrMap.put(one, "false");
            }
            attrMap.remove("convertToFalseList");
        }
        Properties props = new Properties();
        for (Object attr : attrMap.keySet()) {
            String key = (String)attr;
            String prefix = "PROPERTY-";
            String value = (String)attrMap.get(key);
            if (value == null) continue;
            if (key.startsWith(prefix)) {
                props.setProperty(key.substring(prefix.length()), value);
                continue;
            }
            deploymentProps.setProperty(key, value);
        }
        List propertyList = (List)handlerCtx.getInputValue("propertyList");
        if (propertyList != null) {
            HashSet<String> propertyNames = new HashSet<String>();
            for (Map oneRow : propertyList) {
                String name = (String)oneRow.get("Name");
                if (GuiUtil.isEmpty(name)) continue;
                if (propertyNames.contains(name)) {
                    GuiUtil.getLogger().warning("Ignored Duplicate Property Name : " + name);
                    continue;
                }
                propertyNames.add(name);
                String value = (String)oneRow.get("Value");
                if (GuiUtil.isEmpty(value)) continue;
                props.setProperty(name, value);
            }
        }
        if (props.size() > 0) {
            deploymentProps.setProperties(props);
        }
        try {
            DeployUtil.deploy(null, (Properties)deploymentProps, filePath, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void redeploy(HandlerContext handlerCtx) {
        try {
            String filePath = (String)handlerCtx.getInputValue("filePath");
            String origPath = (String)handlerCtx.getInputValue("origPath");
            String appName = (String)handlerCtx.getInputValue("appName");
            Boolean keepSessions = (Boolean)handlerCtx.getInputValue(KEEP_SESSIONS);
            DFDeploymentProperties deploymentProps = new DFDeploymentProperties();
            AMXProxy app = V3AMX.objectNameToProxy("amx:pp=/domain/applications,type=application,name=" + appName);
            String ctxRoot = (String)app.attributesMap().get("ContextRoot");
            if (ctxRoot != null) {
                deploymentProps.setContextRoot(ctxRoot);
            }
            deploymentProps.setForce(true);
            deploymentProps.setUpload(false);
            deploymentProps.setName(appName);
            Properties prop = new Properties();
            String ks = keepSessions == null ? "false" : keepSessions.toString();
            prop.setProperty(KEEP_SESSIONS, ks);
            deploymentProps.setProperties(prop);
            DeployUtil.invokeDeploymentFacility(null, (Properties)deploymentProps, filePath, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void undeploy(HandlerContext handlerCtx) {
        Object obj = handlerCtx.getInputValue("selectedRows");
        Properties dProps = new Properties();
        List selectedRows = (List)obj;
        DFProgressObject progressObject = null;
        DeploymentFacility df = GuiUtil.getDeploymentFacility();
        String[] targetNames = new String[]{"server"};
        for (int i = 0; i < selectedRows.size(); ++i) {
            Map oneRow = (Map)selectedRows.get(i);
            String appName = (String)oneRow.get("name");
            progressObject = df.undeploy(df.createTargets(targetNames), appName, (Map)dProps);
            progressObject.waitFor();
            DFDeploymentStatus status = progressObject.getCompletedStatus();
            if (!DeployUtil.checkDeployStatus(status, handlerCtx, false)) continue;
            String mesg = GuiUtil.getMessage("msg.deploySuccess", new Object[]{appName, "undeployed"});
        }
    }

    public static void changeAppStatus(HandlerContext handlerCtx) {
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        DeploymentFacility df = GuiUtil.getDeploymentFacility();
        String[] targetNames = new String[]{"server"};
        List selectedRows = obj;
        try {
            for (int i = 0; i < selectedRows.size(); ++i) {
                String msg;
                Map oneRow = (Map)selectedRows.get(i);
                String appName = (String)oneRow.get("name");
                if (enabled) {
                    df.enable(df.createTargets(targetNames), appName);
                } else {
                    df.disable(df.createTargets(targetNames), appName);
                }
                if (V3AMX.getInstance().isEE()) {
                    msg = GuiUtil.getMessage(enabled ? "msg.enableSuccessful" : "msg.disableSuccessful");
                    GuiUtil.prepareAlert(handlerCtx, "success", msg, null);
                    continue;
                }
                msg = GuiUtil.getMessage(enabled ? "msg.enableSuccessfulPE" : "msg.disableSuccessfulPE");
                GuiUtil.prepareAlert(handlerCtx, "success", msg, null);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getDeploymentDescriptors(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        ArrayList result = new ArrayList();
        Runtime runtimeMgr = V3AMX.getInstance().getRuntime();
        List ddList = runtimeMgr.getDeploymentConfigurations(appName);
        if (ddList.size() > 0) {
            for (Map oneDD : ddList) {
                HashMap oneRow = new HashMap();
                oneRow.put("moduleName", oneDD.get("module-name"));
                oneRow.put("ddPath", oneDD.get("dd-path"));
                oneRow.put("ddContent", oneDD.get("dd-content"));
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("descriptors", result);
    }
}

