/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.enterprise.deploy.spi.Target;
import javax.management.Attribute;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.Applications;
import org.glassfish.admingui.common.util.AppUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;
import org.glassfish.admingui.common.util.V3AMXUtil;
import org.glassfish.deployment.client.DeploymentFacility;

public class WebAppHandlers {
    public static void getApplicationEnabled(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        boolean enable = AppUtil.isApplicationEnabled(objectNameStr);
        handlerCtx.setOutputValue("enabled", (Object)Boolean.toString(enable));
    }

    public static void showContextRoot(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        String isEar = V3AMX.getPropValue(V3AMX.objectNameToProxy(objectNameStr), "isComposite");
        if (isEar == null || !isEar.equals("true")) {
            handlerCtx.setOutputValue("value", (Object)Boolean.TRUE);
        } else {
            handlerCtx.setOutputValue("value", (Object)Boolean.FALSE);
        }
    }

    public static void saveApplicationInfo(HandlerContext handlerCtx) {
        Map appAttr = (Map)handlerCtx.getInputValue("appAttr");
        Map appRefAttr = (Map)handlerCtx.getInputValue("appRefAttr");
        String appObjectName = (String)handlerCtx.getInputValue("appObjectName");
        String appRefObjectName = (String)handlerCtx.getInputValue("appRefObjectName");
        V3AMX.setAttribute(appObjectName, new Attribute("ContextRoot", appAttr.get("ContextRoot")));
        V3AMX.setAttribute(appObjectName, new Attribute("Description", appAttr.get("Description")));
        String enStr = (String)appAttr.get("Enabled");
        if (enStr == null) {
            enStr = "false";
        }
        V3AMX.setAttribute(appRefObjectName, new Attribute("Enabled", enStr));
        V3AMX.setAttribute(appRefObjectName, new Attribute("VirtualServers", appRefAttr.get("VirtualServers")));
    }

    public static void getSubComponents(HandlerContext handlerCtx) {
        ArrayList result = new ArrayList();
        String appName = (String)handlerCtx.getInputValue("appName");
        Applications applications = V3AMX.getInstance().getApplications();
        Map modules = ((AMXProxy)applications.childrenMap("application").get(appName)).childrenMap("module");
        for (AMXProxy oneModule : modules.values()) {
            HashMap<String, String> oneRow = new HashMap<String, String>();
            List<String> snifferList = AppUtil.getSnifferListOfModule(oneModule);
            oneRow.put("componentName", oneModule.getName());
            oneRow.put("engines", snifferList.toString());
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getDeployedAppsInfo(HandlerContext handlerCtx) {
        String serverName = (String)handlerCtx.getInputValue("serverName");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        TreeSet<String> filters = new TreeSet<String>();
        filters.add("");
        if (GuiUtil.isEmpty(filterValue)) {
            filterValue = null;
        }
        ArrayList result = new ArrayList();
        Applications applications = V3AMX.getInstance().getApplications();
        Map application = applications.childrenMap("application");
        for (AMXProxy oneApp : application.values()) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("name", oneApp.getName());
            oneRow.put("selected", false);
            boolean enable = AppUtil.isApplicationEnabled(oneApp);
            String enableURL = enable ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
            oneRow.put("enableURL", enableURL);
            List sniffersList = AppUtil.getAllSniffers(oneApp);
            oneRow.put("sniffersList", sniffersList);
            oneRow.put("sniffers", sniffersList.toString());
            for (int ix = 0; ix < sniffersList.size(); ++ix) {
                filters.add((String)sniffersList.get(ix));
            }
            if (filterValue != null && !sniffersList.contains(filterValue)) continue;
            WebAppHandlers.getLaunchInfo(serverName, oneApp, oneRow);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("filters", new ArrayList(filters));
    }

    private static void getLaunchInfo(String serverName, AMXProxy oneApp, Map oneRow) {
        Map attrs = oneApp.attributesMap();
        String contextRoot = (String)attrs.get("ContextRoot");
        if (contextRoot == null) {
            contextRoot = "";
        }
        boolean enabled = AppUtil.isApplicationEnabled(oneApp);
        oneRow.put("contextRoot", contextRoot);
        oneRow.put("hasLaunch", false);
        if (!enabled || contextRoot.equals("")) {
            return;
        }
        String protocol = "http";
        String port = V3AMXUtil.getPortForApplication((String)attrs.get("Name"));
        if (port == null) {
            oneRow.put("port", "");
            oneRow.put("hasLaunch", false);
        } else {
            if (port.startsWith("-")) {
                protocol = "https";
                port = port.substring(1);
            }
            oneRow.put("port", port);
            oneRow.put("hasLaunch", true);
            String ctxRoot = WebAppHandlers.calContextRoot(contextRoot);
            oneRow.put("launchLink", protocol + "://" + serverName + ":" + port + ctxRoot);
        }
    }

    public static void restartApplication(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String[] targetNames = new String[]{"server"};
        try {
            DeploymentFacility df = GuiUtil.getDeploymentFacility();
            Target[] targets = df.createTargets(targetNames);
            df.disable(targets, appName);
            df.enable(targets, appName);
            if (V3AMX.getInstance().isEE()) {
                GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("org.glassfish.web.admingui.Strings", "restart.success"), null);
            } else {
                GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("org.glassfish.web.admingui.Strings", "restart.successPE"), null);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static String calContextRoot(String contextRoot) {
        String ctxRoot = "";
        ctxRoot = contextRoot == null || contextRoot.equals("") || contextRoot.equals("/") ? "/" : (contextRoot.startsWith("/") ? contextRoot : "/" + contextRoot);
        return ctxRoot;
    }
}

