/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import org.glassfish.admin.amx.base.Query;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.AMXConfigHelper;
import org.glassfish.admin.amx.intf.config.Applications;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class MonitoringHandlers {
    private static final List<String> levels = new ArrayList<String>();
    public static final String JVM = "JVM";
    public static final String WEB_CONTAINER = "Web Container";
    public static final String HTTP_SERVICE = "HTTP Service";
    public static final String THREAD_POOL = "Thread Pool";
    public static final String JDBC_CONNECTION_POOL = "JDBC Connection Pool";
    public static final String CONNECTOR_CONNECTION_POOL = "Connector Connection Pool";
    public static final String EJB_CONTAINER = "EJB Container";
    public static final String TRANSACTION_SERVICE = "Transaction Service";
    public static final String ORB = "ORB";
    public static final String CONNECTOR_SERVICE = "Connector Service";
    public static final String JMS_SERVICE = "JMS Service";
    public static final String WEB_SERVICES_CONTAINER = "Web Services Container";
    public static final String JPA = "JPA";
    public static final String SECURITY = "Security";
    public static final String JERSEY = "Jersey";

    public static void getMonitorLevels(HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        ArrayList result = new ArrayList();
        try {
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectName));
            AMXConfigHelper helper = new AMXConfigHelper(amx);
            Map attrs = helper.simpleAttributesMap();
            for (String oneMonComp : attrs.keySet()) {
                if (oneMonComp.equals("Parent") || oneMonComp.equals("Children") || oneMonComp.equals("Name") || oneMonComp.equals("Property")) continue;
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                String name = null;
                if (oneMonComp.equals("Jvm")) {
                    name = JVM;
                }
                if (oneMonComp.equals("WebContainer")) {
                    name = WEB_CONTAINER;
                }
                if (oneMonComp.equals("HttpService")) {
                    name = HTTP_SERVICE;
                }
                if (oneMonComp.equals("ThreadPool")) {
                    name = THREAD_POOL;
                }
                if (oneMonComp.equals("JdbcConnectionPool")) {
                    name = JDBC_CONNECTION_POOL;
                }
                if (oneMonComp.equals("ConnectorConnectionPool")) {
                    name = CONNECTOR_CONNECTION_POOL;
                }
                if (oneMonComp.equals("EjbContainer")) {
                    name = EJB_CONTAINER;
                }
                if (oneMonComp.equals("TransactionService")) {
                    name = TRANSACTION_SERVICE;
                }
                if (oneMonComp.equals("Orb")) {
                    name = ORB;
                }
                if (oneMonComp.equals("ConnectorService")) {
                    name = CONNECTOR_SERVICE;
                }
                if (oneMonComp.equals("JmsService")) {
                    name = JMS_SERVICE;
                }
                if (oneMonComp.equals("WebServicesContainer")) {
                    name = WEB_SERVICES_CONTAINER;
                }
                if (oneMonComp.equals("Jpa")) {
                    name = JPA;
                }
                if (oneMonComp.equals(SECURITY)) {
                    name = SECURITY;
                }
                if (oneMonComp.equals(JERSEY)) {
                    name = JERSEY;
                }
                if (name == null) {
                    name = oneMonComp;
                }
                oneRow.put("monCompName", name);
                oneRow.put("level", attrs.get(oneMonComp));
                oneRow.put("selected", false);
                result.add(oneRow);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        handlerCtx.setOutputValue("monitorCompList", result);
    }

    public static void getStatsbyTypeName(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        String name = (String)handlerCtx.getInputValue("name");
        Locale locale = GuiUtil.getLocale();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, locale);
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        ArrayList result = new ArrayList();
        try {
            Query query = V3AMX.getInstance().getDomainRoot().getQueryMgr();
            Set amxproxy = query.queryTypeName(type, name);
            Iterator iter = amxproxy.iterator();
            while (iter.hasNext()) {
                Map monattrs = ((AMXProxy)iter.next()).attributesMap();
                for (String monName : monattrs.keySet()) {
                    if (monName.equals("Parent") || monName.equals("Children") || monName.equals("Name")) continue;
                    HashMap<String, String> statMap = new HashMap<String, String>();
                    Object val = monattrs.get(monName);
                    String details = "--";
                    String desc = "--";
                    String start = "--";
                    String last = "--";
                    String unit = "";
                    String current = "";
                    String mname = null;
                    Integer runtimes = null;
                    Object queuesize = null;
                    String thresholds = "--";
                    boolean nostatskey = true;
                    if (val instanceof CompositeDataSupport) {
                        CompositeDataSupport cds = (CompositeDataSupport)val;
                        CompositeType ctype = cds.getCompositeType();
                        if (cds.containsKey("statistics")) {
                            Object statistics = cds.get("statistics");
                            if (statistics instanceof CompositeData[]) {
                                CompositeData[] mycd = (CompositeData[])cds.get("statistics");
                                if (((CompositeData[])cds.get("statistics")).length == 0) {
                                    val = "--";
                                }
                                for (CompositeData cd : (CompositeData[])cds.get("statistics")) {
                                    nostatskey = false;
                                    HashMap<String, Object> statsMap = new HashMap<String, Object>();
                                    if (cd.containsKey("name") && type.equals("web-service-mon")) {
                                        val = cd.get("name");
                                    }
                                    if (cd.containsKey("name")) {
                                        val = cd.get("name");
                                    }
                                    if (cd.containsKey("description")) {
                                        desc = (String)cd.get("description");
                                    }
                                    if (cd.containsKey("lastSampleTime")) {
                                        last = df.format(new Date((Long)cd.get("lastSampleTime")));
                                    }
                                    if (cd.containsKey("startTime")) {
                                        start = df.format(new Date((Long)cd.get("startTime")));
                                    }
                                    if (cd.containsKey("appName")) {
                                        details = GuiUtil.getMessage("msg.AppName") + ": " + cd.get("appName") + "<br/>";
                                    }
                                    if (cd.containsKey("address")) {
                                        details = details + GuiUtil.getMessage("msg.Address") + ": " + cd.get("address") + "<br/>";
                                    }
                                    if (cd.containsKey("deploymentType")) {
                                        details = details + GuiUtil.getMessage("msg.DepType") + ": " + cd.get("deploymentType") + "<br/>";
                                    }
                                    if (cd.containsKey("endpointName")) {
                                        details = details + GuiUtil.getMessage("msg.EndPointName") + ": " + cd.get("endpointName") + "<br/>";
                                    }
                                    if (cd.containsKey("implType")) {
                                        details = details + GuiUtil.getMessage("msg.ImplClass") + ": " + cd.get("implClass") + "<br/>";
                                    }
                                    if (cd.containsKey("implClass") && cd.containsKey("implType")) {
                                        details = details + GuiUtil.getMessage("msg.ImplType") + ": " + cd.get("implType") + "<br/>";
                                    }
                                    if (cd.containsKey("namespace")) {
                                        details = details + GuiUtil.getMessage("msg.NameSpace") + ": " + cd.get("namespace") + "<br/>";
                                    }
                                    if (cd.containsKey("portName")) {
                                        details = details + GuiUtil.getMessage("msg.PortName") + ": " + cd.get("portName") + "<br/>";
                                    }
                                    if (cd.containsKey("serviceName")) {
                                        details = details + GuiUtil.getMessage("msg.ServiceName") + ": " + cd.get("serviceName") + "<br/>";
                                    }
                                    if (cd.containsKey("tester")) {
                                        details = details + GuiUtil.getMessage("msg.Tester") + ": " + cd.get("tester") + "<br/>";
                                    }
                                    if (cd.containsKey("wsdl")) {
                                        details = details + GuiUtil.getMessage("msg.WSDL") + ": " + cd.get("wsdl") + "<br/>";
                                    }
                                    statsMap.put("Name", monName);
                                    statsMap.put("StartTime", start);
                                    statsMap.put("LastTime", last);
                                    statsMap.put("Description", desc);
                                    statsMap.put("Value", val == null ? "" : val);
                                    statsMap.put("Details", details);
                                    result.add(statsMap);
                                }
                            }
                        } else {
                            mname = cds.containsKey("name") ? (String)cds.get("name") : monName;
                            if (cds.containsKey("unit")) {
                                unit = (String)cds.get("unit");
                            }
                            if (cds.containsKey("description")) {
                                desc = (String)cds.get("description");
                            }
                            if (cds.containsKey("startTime")) {
                                start = df.format(new Date((Long)cds.get("startTime")));
                            }
                            if (cds.containsKey("lastSampleTime")) {
                                last = df.format(new Date((Long)cds.get("lastSampleTime")));
                            }
                            if (cds.containsKey("maxTime")) {
                                details = GuiUtil.getMessage("msg.MaxTime") + ": " + cds.get("maxTime") + " " + unit + "<br/>";
                            }
                            if (cds.containsKey("minTime")) {
                                details = details + GuiUtil.getMessage("msg.MinTime") + ": " + cds.get("minTime") + " " + unit + "<br/>";
                            }
                            if (cds.containsKey("totalTime")) {
                                details = details + GuiUtil.getMessage("msg.TotalTime") + ": " + cds.get("totalTime") + " " + unit + "<br/>";
                            }
                            if (cds.containsKey("activeRuntimes")) {
                                runtimes = (Integer)cds.get("activeRuntimes");
                            }
                            if (cds.containsKey("queueSize")) {
                                queuesize = cds.get("queueSize");
                            }
                            if (cds.containsKey("hardMaximum") && cds.get("hardMaximum") != null) {
                                val = cds.get("hardMaximum") + " " + "hard max " + "<br/>" + cds.get("hardMinimum") + " " + "hard min";
                            }
                            if (cds.containsKey("newThreshold") && cds.get("newThreshold") != null) {
                                thresholds = cds.get("newThreshold") + " " + "new " + "<br/>" + cds.get("queueDownThreshold") + " " + "queue down";
                            }
                            val = cds.containsKey("count") ? cds.get("count") + " " + unit : (cds.containsKey("current") ? cds.get("current") : "--");
                        }
                    } else if (val instanceof String[]) {
                        mname = monName;
                        String values = "";
                        for (String s : (String[])val) {
                            values = values + (String)s + "<br/>";
                        }
                        val = values;
                    } else if (val instanceof CompositeData[]) {
                        String apptype = "";
                        for (CompositeData cd : (CompositeData[])val) {
                            if (cd.containsKey("appName")) {
                                mname = (String)cd.get("appName");
                            }
                            if (cd.containsKey("applicationType")) {
                                apptype = (String)cd.get("applicationType");
                            }
                            if (!cd.containsKey("queueSize") || !cd.containsKey("jrubyVersion")) continue;
                            details = details + cd.get("environment") + " " + cd.get("jrubyVersion");
                        }
                        val = apptype;
                    }
                    if (!nostatskey) continue;
                    statMap.put("Name", mname != null ? mname : monName);
                    statMap.put("Thresholds", thresholds == null ? "--" : thresholds);
                    statMap.put("QueueSize", (String)(queuesize == null ? "--" : queuesize));
                    statMap.put("Runtimes", (String)(runtimes == null ? "--" : runtimes));
                    statMap.put("Current", current);
                    statMap.put("StartTime", start);
                    statMap.put("LastTime", last);
                    statMap.put("Description", desc);
                    statMap.put("Value", val == null ? "" : val);
                    statMap.put("Details", details == null ? "--" : details);
                    result.add(statMap);
                }
            }
            handlerCtx.setOutputValue("result", result);
            handlerCtx.setOutputValue("hasStats", (Object)(!amxproxy.isEmpty() ? 1 : 0));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void updateMonitorLevels(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectName");
        List allRows = (List)handlerCtx.getInputValue("allRows");
        for (Map oneRow : allRows) {
            String name = (String)oneRow.get("monCompName");
            String value = null;
            if (name.equals(JVM)) {
                value = "Jvm";
            }
            if (name.equals(WEB_CONTAINER)) {
                value = "WebContainer";
            }
            if (name.equals(HTTP_SERVICE)) {
                value = "HttpService";
            }
            if (name.equals(THREAD_POOL)) {
                value = "ThreadPool";
            }
            if (name.equals(JDBC_CONNECTION_POOL)) {
                value = "JdbcConnectionPool";
            }
            if (name.equals(CONNECTOR_CONNECTION_POOL)) {
                value = "ConnectorConnectionPool";
            }
            if (name.equals(EJB_CONTAINER)) {
                value = "EjbContainer";
            }
            if (name.equals(TRANSACTION_SERVICE)) {
                value = "TransactionService";
            }
            if (name.equals(ORB)) {
                value = "Orb";
            }
            if (name.equals(CONNECTOR_SERVICE)) {
                value = "ConnectorService";
            }
            if (name.equals(JMS_SERVICE)) {
                value = "JmsService";
            }
            if (name.equals(WEB_SERVICES_CONTAINER)) {
                value = "WebServicesContainer";
            }
            if (name.equals(JPA)) {
                value = "Jpa";
            }
            if (name.equals(SECURITY)) {
                value = SECURITY;
            }
            if (name.equals(JERSEY)) {
                value = JERSEY;
            }
            if (value == null) {
                value = name;
            }
            V3AMX.setAttribute(objectNameStr, new Attribute(value, oneRow.get("level")));
        }
    }

    public static void addToMonitorList(HandlerContext handlerCtx) {
        List oldList = (List)handlerCtx.getInputValue("oldList");
        ArrayList<String> newList = (ArrayList<String>)handlerCtx.getInputValue("newList");
        if (newList == null) {
            newList = new ArrayList<String>();
        }
        if (oldList != null) {
            for (String sk : oldList) {
                newList.add(sk);
            }
        }
        handlerCtx.setOutputValue("result", newList);
    }

    public static void getValidMonitorLevels(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("monitorLevelList", levels);
    }

    public static void getFirstValueFromList(HandlerContext handlerCtx) {
        List values = (List)handlerCtx.getInputValue("values");
        String firstval = "";
        if (values != null && values.size() != 0) {
            firstval = (String)values.get(0);
        }
        handlerCtx.setOutputValue("firstValue", (Object)firstval);
    }

    public static void getAppName(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        Applications amx = V3AMX.getInstance().getApplications();
        Map applications = amx.childrenMap("application");
        ArrayList result = new ArrayList();
        String appName = "";
        block0: for (AMXProxy oneApp : applications.values()) {
            Map modules = oneApp.childrenMap("module");
            for (AMXProxy oneModule : modules.values()) {
                String moduleName = oneModule.getName();
                if (!moduleName.equals(name)) continue;
                appName = oneApp.getName();
                continue block0;
            }
        }
        handlerCtx.setOutputValue("appName", (Object)appName);
    }

    public static void getNameforMbean(HandlerContext handlerCtx) {
        String app = (String)handlerCtx.getInputValue("appName");
        String comp = (String)handlerCtx.getInputValue("compVal");
        String mbeanName = "";
        try {
            Query query = V3AMX.getInstance().getDomainRoot().getQueryMgr();
            Set data = query.queryType("server-mon");
            Iterator iter = data.iterator();
            block2: while (iter.hasNext()) {
                Map attrs = ((AMXProxy)iter.next()).attributesMap();
                ObjectName[] pnames = (ObjectName[])attrs.get("Children");
                for (int i = 0; i < pnames.length; ++i) {
                    String pname = pnames[i].getKeyProperty("name");
                    if (!pname.endsWith(app + "/" + comp)) continue;
                    mbeanName = pname;
                    continue block2;
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("mbeanName", (Object)mbeanName);
    }

    static {
        levels.add("OFF");
        levels.add("LOW");
        levels.add("HIGH");
    }
}

