/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class JdbcTempHandler {
    public static final String REASON_FAILED_KEY = "ReasonFailedKey";
    private static final String CONN_DEFINITION_PROPS_KEY = "ConnDefinitionPropsKey";
    private static final String PING_CONNECTION_POOL_KEY = "PingConnectionPoolKey";
    private static final String FLUSH_CONNECTION_POOL_KEY = "FlushConnectionPoolKey";
    private static final String VALIDATION_TABLE_NAMES_KEY = "ValidationTableNamesKey";
    private static final String JDBC_DRIVER_CLASS_NAMES_KEY = "JdbcDriverClassNamesKey";
    private static final String DATA_SOURCE = "javax.sql.DataSource";
    private static final String XADATA_SOURCE = "javax.sql.XADataSource";
    private static final String CCDATA_SOURCE = "javax.sql.ConnectionPoolDataSource";
    private static final String DRIVER = "java.sql.Driver";
    private static final String JAVADB = "JavaDB";
    private static final String ORACLE = "Oracle";
    private static final String DERBY = "Derby";
    private static final String SYBASE = "Sybase";
    private static final String DB2 = "DB2";
    private static final String POINTBASE = "PointBase";
    private static final String POSTGRESQL = "PostgreSQL";
    private static final String INFORMIX = "Informix";
    private static final String CLOUDSCAPE = "Cloudscape";
    private static final String MSSQL = "Microsoft SQL Server";
    private static final String MYSQL = "MySQL";
    private static List resTypeList = new ArrayList();
    private static List dbVendorList = new ArrayList();

    public static void pingJdbcConnectionPool(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        try {
            Map statusMap = V3AMX.getInstance().getConnectorRuntime().pingJDBCConnectionPool(jndiName);
            if (((Boolean)statusMap.get(PING_CONNECTION_POOL_KEY)).booleanValue()) {
                GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.PingSucceed"), null);
            } else {
                GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), statusMap.get(REASON_FAILED_KEY).toString());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void flushConnectionPool(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        try {
            Map statusMap = V3AMX.getInstance().getConnectorRuntime().flushConnectionPool(jndiName);
            if (((Boolean)statusMap.get(FLUSH_CONNECTION_POOL_KEY)).booleanValue()) {
                GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.FlushSucceed"), null);
            } else {
                GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), statusMap.get(REASON_FAILED_KEY).toString());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getTableNames(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        ArrayList result = new ArrayList();
        Map tn = V3AMX.getInstance().getConnectorRuntime().getValidationTableNames(name);
        if (tn != null) {
            Set keys = (Set)tn.get(VALIDATION_TABLE_NAMES_KEY);
            if (keys != null) {
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    result.add(iter.next());
                }
            } else if (tn.get(REASON_FAILED_KEY) != null) {
                GuiUtil.getLogger().warning(tn.get(REASON_FAILED_KEY).toString());
            }
            handlerCtx.setOutputValue("result", result);
        }
    }

    public static void setJDBCPoolWizard(HandlerContext handlerCtx) {
        Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("fromStep2");
        if (fromStep2 == null || !fromStep2.booleanValue()) {
            Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
            Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
            sessionMap.put("wizardMap", attrMap);
            sessionMap.put("wizardPoolExtra", new HashMap());
        }
        handlerCtx.setOutputValue("ResTypeList", (Object)resTypeList);
        handlerCtx.setOutputValue("DBVendorList", (Object)dbVendorList);
    }

    public static void updateJDBCPoolWizardStep1(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        String resType = (String)extra.get("ResType");
        String dbVendor = (String)extra.get("DBVendor");
        String previousResType = (String)extra.get("PreviousResType");
        String previousDB = (String)extra.get("PreviousDB");
        if (!resType.equals(previousResType) || !dbVendor.equals(previousDB) || GuiUtil.isEmpty((String)extra.get("DatasourceClassname"))) {
            block12: {
                if (!GuiUtil.isEmpty(resType) && !GuiUtil.isEmpty(dbVendor)) {
                    ArrayList dsl = new ArrayList();
                    try {
                        String classname = "";
                        GuiUtil.getLogger().info("======= getJdbcDriverClassNames(" + dbVendor + ", " + resType + ")");
                        Map dcn = V3AMX.getInstance().getConnectorRuntime().getJdbcDriverClassNames(dbVendor, resType);
                        GuiUtil.getLogger().info("======= returns " + (dcn == null ? "NULL" : " Map of size " + dcn.size()));
                        if (dcn != null) {
                            dsl = new ArrayList((Set)dcn.get(JDBC_DRIVER_CLASS_NAMES_KEY));
                            GuiUtil.getLogger().info("=======  # of items for JDBC_DRIVER_CLASS_NAMES_KEY  " + dsl.size());
                            for (int i = 0; i < dsl.size(); ++i) {
                                System.out.println("classname[" + i + "] : " + dsl.get(i));
                            }
                        }
                        if (resType.equals(DRIVER)) {
                            extra.put("DList", dsl);
                            extra.put("DSList", "");
                            extra.put("DatasourceClassnameField", "");
                            extra.put("dsClassname", Boolean.FALSE);
                        } else {
                            extra.put("DSList", dsl);
                            extra.put("DList", "");
                            extra.put("DriverClassnameField", "");
                            extra.put("dsClassname", Boolean.TRUE);
                        }
                        ArrayList noprops = new ArrayList();
                        String dslName = dsl != null && dsl.size() > 0 ? (String)dsl.get(0) : "";
                        GuiUtil.getLogger().info("===== getConnectionDefinitionPropertiesAndDefaults(\"" + dslName + "\"," + resType + ")");
                        Map result = V3AMX.getInstance().getConnectorRuntime().getConnectionDefinitionPropertiesAndDefaults(dslName, resType);
                        if (result != null) {
                            Map props = (Map)result.get(CONN_DEFINITION_PROPS_KEY);
                            GuiUtil.getLogger().info("=======  getConnectionDefinitionPropertiesAndDefaults returns # of properties: " + props.size());
                            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", GuiUtil.convertMapToListOfMap(props));
                            break block12;
                        }
                        GuiUtil.getLogger().info("======= getConnectionDefinitionPropertiesAndDefaults returns NULL");
                        handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", noprops);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (!GuiUtil.isEmpty(resType) && resType.equals(DRIVER)) {
                    extra.put("DatasourceClassnameField", "");
                    extra.put("dsClassname", Boolean.FALSE);
                } else {
                    extra.put("DatasourceClassnameField", "");
                    extra.put("dsClassname", Boolean.TRUE);
                }
            }
            extra.put("PreviousResType", resType);
            extra.put("PreviousDB", dbVendor);
        }
    }

    public static void updateJdbcConnectionPoolWizardStep2(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        Map attrs = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardMap");
        String resType = (String)extra.get("ResType");
        String classname = (String)extra.get("DatasourceClassname");
        String driver = (String)extra.get("DriverClassname");
        String name = (String)extra.get("Name");
        String classnamefield = (String)extra.get("DatasourceClassnameField");
        String driverfield = (String)extra.get("DriverClassnameField");
        attrs.put("Name", name);
        attrs.put("ResType", resType);
        if ("".equals(attrs.get("TransactionIsolationLevel"))) {
            attrs.remove("TransactionIsolationLevel");
        }
        if (!GuiUtil.isEmpty(classnamefield) || !GuiUtil.isEmpty(driverfield)) {
            attrs.put("DatasourceClassname", classnamefield);
            attrs.put("DriverClassname", driverfield);
        } else if (!GuiUtil.isEmpty(classname) || !GuiUtil.isEmpty(driver)) {
            attrs.put("DatasourceClassname", classname);
            attrs.put("DriverClassname", driver);
        } else {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("Classname Cannot be Empty"));
            return;
        }
    }

    public static void saveJdbcConnectionPool(HandlerContext handlerCtx) {
        try {
            List convertToFalse;
            List onlyUseAttrs;
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            HashMap<String, String> attrs = (HashMap<String, String>)handlerCtx.getInputValue("attrs");
            String resourceType = (String)attrs.get("ResType");
            if (resourceType.equals(DRIVER)) {
                attrs.put("DatasourceClassname", "");
            } else {
                attrs.put("DriverClassname", "");
            }
            List skipAttrs = (List)handlerCtx.getInputValue("skipAttrs");
            if (skipAttrs != null) {
                for (String sk : skipAttrs) {
                    if (!attrs.keySet().contains(sk)) continue;
                    attrs.remove(sk);
                }
            }
            if ((onlyUseAttrs = (List)handlerCtx.getInputValue("onlyUseAttrs")) != null) {
                HashMap<String, String> newAttrs = new HashMap<String, String>();
                for (String key : onlyUseAttrs) {
                    if (!attrs.keySet().contains(key)) continue;
                    newAttrs.put(key, (String)attrs.get(key));
                }
                attrs = newAttrs;
            }
            if ((convertToFalse = (List)handlerCtx.getInputValue("convertToFalse")) != null) {
                for (String sk : convertToFalse) {
                    if (!attrs.keySet().contains(sk) || attrs.get(sk) != null) continue;
                    attrs.remove(sk);
                    attrs.put(sk, "false");
                }
            }
            V3AMX.setAttributes(objectNameStr, (Map<String, Object>)attrs);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    static {
        resTypeList.add("");
        resTypeList.add(DATA_SOURCE);
        resTypeList.add(XADATA_SOURCE);
        resTypeList.add(CCDATA_SOURCE);
        resTypeList.add(DRIVER);
        dbVendorList.add("");
        dbVendorList.add(JAVADB);
        dbVendorList.add(ORACLE);
        dbVendorList.add(DERBY);
        dbVendorList.add(SYBASE);
        dbVendorList.add(DB2);
        dbVendorList.add(POINTBASE);
        dbVendorList.add(POSTGRESQL);
        dbVendorList.add(INFORMIX);
        dbVendorList.add(CLOUDSCAPE);
        dbVendorList.add(MSSQL);
        dbVendorList.add(MYSQL);
        Collections.sort(dbVendorList);
    }
}

