/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.admingui.common.util.GuiUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestApiHandlers {
    public static final String FORM_ENCODING = "application/x-www-form-urlencoded";
    public static final String RESPONSE_TYPE = "application/xml";

    public static void getDefaultValues(HandlerContext handlerCtx) {
        try {
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            Map orig = (Map)handlerCtx.getInputValue("orig");
            Map<String, String> defaultValues = RestApiHandlers.buildDefaultValueMap(endpoint);
            if (orig == null) {
                handlerCtx.setOutputValue("valueMap", defaultValues);
            } else {
                for (String origKey : orig.keySet()) {
                    String defaultV = defaultValues.get(origKey);
                    if (defaultV == null) continue;
                    orig.put(origKey, defaultV);
                }
                handlerCtx.setOutputValue("valueMap", (Object)orig);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getEntityAttrs(HandlerContext handlerCtx) {
        try {
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            String entity = RestApiHandlers.get(endpoint);
            handlerCtx.setOutputValue("valueMap", RestApiHandlers.getEntityAttrs(entity));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void createProxy(HandlerContext handlerCtx) {
        String endpoint;
        int status;
        HashMap<String, String> attrs = (HashMap<String, String>)handlerCtx.getInputValue("attrs");
        if (attrs == null) {
            attrs = new HashMap<String, String>();
        }
        if ((status = RestApiHandlers.sendCreateRequest(endpoint = (String)handlerCtx.getInputValue("endpoint"), attrs, (List)handlerCtx.getInputValue("skipAttrs"), (List)handlerCtx.getInputValue("onlyUseAttrs"), (List)handlerCtx.getInputValue("convertToFalse"))) != 200 && status != 201) {
            GuiUtil.getLogger().severe("CreateProxy failed.  parent=" + endpoint + "; attrs =" + attrs);
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
            return;
        }
        handlerCtx.setOutputValue("result", (Object)endpoint);
    }

    public static void deleteCascade(HandlerContext handlerCtx) {
        try {
            HashMap<String, String> payload = new HashMap<String, String>();
            String endpoint = (String)handlerCtx.getInputValue("objectNameStr");
            payload.put("cascade", "true");
            for (Map oneRow : (List)handlerCtx.getInputValue("selectedRows")) {
                RestApiHandlers.delete(endpoint + "/" + (String)oneRow.get("Name"), payload);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    protected static Map<String, String> buildDefaultValueMap(String endpoint) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        String options = RestApiHandlers.options(endpoint, RESPONSE_TYPE);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new ByteArrayInputStream(options.getBytes()));
        Element root = doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName("messageParameters");
        if (nl.getLength() > 0) {
            NodeList params = nl.item(0).getChildNodes();
            for (int i = 0; i < params.getLength(); ++i) {
                String defaultValue;
                Node child = params.item(i);
                if (child.getNodeType() != 1 || "".equals(defaultValue = ((Element)child).getAttribute("defaultValue")) || defaultValue == null) continue;
                String nodeName = child.getNodeName();
                nodeName = nodeName.substring(0, 1).toUpperCase() + nodeName.substring(1);
                defaultValues.put(nodeName, defaultValue);
            }
        }
        return defaultValues;
    }

    protected static MultivaluedMap buildMultivalueMap(Map<String, String> payload) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        for (Map.Entry<String, String> entry : payload.entrySet()) {
            formData.putSingle((Object)entry.getKey(), (Object)entry.getValue());
        }
        return formData;
    }

    public static int sendCreateRequest(String endpoint, Map<String, String> attrs, List<String> skipAttrs, List<String> onlyUseAttrs, List<String> convertToFalse) {
        RestApiHandlers.removeSpecifiedAttrs(attrs, skipAttrs);
        if (onlyUseAttrs != null) {
            HashMap<String, String> newAttrs = new HashMap<String, String>();
            for (String key : onlyUseAttrs) {
                if (!attrs.keySet().contains(key)) continue;
                newAttrs.put(key, attrs.get(key));
            }
            attrs = newAttrs;
        }
        attrs = RestApiHandlers.convertNullValuesToFalse(attrs, convertToFalse);
        attrs = RestApiHandlers.fixKeyNames(attrs);
        return RestApiHandlers.post(endpoint, attrs);
    }

    protected static Map<String, String> fixKeyNames(Map<String, String> map) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey().substring(0, 1).toLowerCase() + entry.getKey().substring(1);
            String value = entry.getValue();
            results.put(key, value);
        }
        return results;
    }

    protected static void removeSpecifiedAttrs(Map<String, String> attrs, List<String> removeList) {
        if (removeList == null || removeList.size() <= 0) {
            return;
        }
        Set<Map.Entry<String, String>> attrSet = attrs.entrySet();
        Iterator<Map.Entry<String, String>> iter = attrSet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> oneEntry = iter.next();
            if (!removeList.contains(oneEntry.getKey())) continue;
            iter.remove();
        }
    }

    protected static Map<String, String> convertNullValuesToFalse(Map<String, String> attrs, List<String> convertToFalse) {
        if (convertToFalse != null) {
            HashMap<String, String> newAttrs = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                String key = entry.getKey();
                if (convertToFalse.contains(key) && (entry.getValue() == null || "null".equals(entry.getValue()))) {
                    newAttrs.put(key, "false");
                    continue;
                }
                newAttrs.put(key, entry.getValue());
            }
            return newAttrs;
        }
        return attrs;
    }

    protected static Map<String, String> getEntityAttrs(String entity) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(entity.getBytes()));
            Element root = doc.getDocumentElement();
            NamedNodeMap nnm = root.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node node = nnm.item(i);
                attrs.put(RestApiHandlers.upperCaseFirstLetter(node.getNodeName()), node.getNodeValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attrs;
    }

    protected static String upperCaseFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    protected static String get(String address) {
        return (String)Client.create().resource(address).accept(new String[]{RESPONSE_TYPE}).get(String.class);
    }

    protected static int post(String address, Map<String, String> payload) {
        WebResource webResource = Client.create().resource(address);
        MultivaluedMap formData = RestApiHandlers.buildMultivalueMap(payload);
        ClientResponse cr = (ClientResponse)webResource.post(ClientResponse.class, (Object)formData);
        RestApiHandlers.checkStatusForSuccess(cr);
        return cr.getStatus();
    }

    protected static String put(String address) {
        throw new UnsupportedOperationException();
    }

    protected static int delete(String address, Map<String, String> payload) {
        WebResource webResource = Client.create().resource(address);
        ClientResponse cr = (ClientResponse)webResource.queryParams(RestApiHandlers.buildMultivalueMap(payload)).delete(ClientResponse.class);
        RestApiHandlers.checkStatusForSuccess(cr);
        return cr.getStatus();
    }

    protected static String options(String address, String responseType) {
        return (String)Client.create().resource(address).accept(new String[]{responseType}).options(String.class);
    }

    protected static void checkStatusForSuccess(ClientResponse cr) {
        int status = cr.getStatus();
        if (status < 200 || status > 299) {
            throw new RuntimeException(cr.toString());
        }
    }
}

