/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.util.GuiUtil;

public class TargetUtil {
    public static boolean isCluster(String name) {
        if (GuiUtil.isEmpty(name)) {
            return false;
        }
        return TargetUtil.getClusters().contains(name);
    }

    public static List getStandaloneInstances() {
        ArrayList result = new ArrayList();
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/list-instances";
        HashMap<String, Object> attrsMap = new HashMap<String, Object>();
        attrsMap.put("standaloneonly", "true");
        try {
            Map responseMap = RestApiHandlers.restRequest(endpoint, attrsMap, "get", null);
            ArrayList messages = (ArrayList)responseMap.get("messages");
            Map message = (Map)messages.get(0);
            List props = (List)message.get("properties");
            if (props == null) {
                return result;
            }
            for (Map oneProp : props) {
                result.add(oneProp.get("name"));
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getStandaloneInstances ; \nendpoint = " + endpoint + ", attrsMap=" + attrsMap);
        }
        return result;
    }

    public static List getClusters() {
        List<Object> clusters = new ArrayList();
        try {
            clusters = RestApiHandlers.getChildrenNames(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster", "Name");
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getClusters;");
            ex.printStackTrace();
        }
        return clusters;
    }
}

