/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.intf.config.JavaConfig;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.V3AMX;

public class InstanceHandler {
    private static final String PROPERTY_VALUE = "Value";

    public static void getDebugInfo(HandlerContext handlerCtx) {
        String debugOptions = (String)handlerCtx.getInputValue("debugOptions");
        String debugPort = "";
        StringTokenizer tokens = new StringTokenizer(debugOptions, ",");
        String doption = "";
        while (tokens.hasMoreTokens()) {
            int pos;
            doption = tokens.nextToken().trim();
            if (!doption.startsWith("address") || (pos = doption.indexOf("=")) < 0) continue;
            debugPort = doption.substring(pos + 1).trim();
            break;
        }
        Boolean debugEnabled = (Boolean)handlerCtx.getInputValue("debugEnabled");
        String msg = "true".equals("" + debugEnabled) ? GuiUtil.getMessage("inst.debugEnabled") + debugPort : GuiUtil.getMessage("inst.notEnabled");
        handlerCtx.setOutputValue("debugInfo", (Object)msg);
    }

    public static void getProfilerAttrs(HandlerContext handlerCtx) {
        ObjectName objName = null;
        Boolean edit = false;
        try {
            JavaConfig amx = V3AMX.getInstance().getConfig("server-config").getJava();
            objName = (ObjectName)amx.attributesMap().get("Profiler");
            if (objName != null) {
                edit = true;
            }
            handlerCtx.setOutputValue("edit", (Object)edit);
            handlerCtx.setOutputValue("objectName", (Object)objName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("edit", (Object)false);
        }
    }

    public static void getJvmOptionsValues(HandlerContext handlerCtx) {
        try {
            ArrayList list = InstanceHandler.getJvmOptions(handlerCtx);
            handlerCtx.setOutputValue("result", GuiUtil.convertArrayToListOfMap(list.toArray(), PROPERTY_VALUE));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("result", new HashMap());
        }
    }

    public static ArrayList getJvmOptions(HandlerContext handlerCtx) {
        Map attrs;
        HashMap result;
        ArrayList list;
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        if (!endpoint.endsWith(".json")) {
            endpoint = endpoint + ".json";
        }
        if ((list = (ArrayList)(result = (HashMap)RestApiHandlers.restRequest(endpoint, attrs = (Map)handlerCtx.getInputValue("attrs"), "get", handlerCtx).get("data")).get("JvmOption")) == null || list != null && ((String)list.get(0)).contains("EnD")) {
            list = new ArrayList();
        }
        return list;
    }

    public static void saveJvmOptionValues(HandlerContext handlerCtx) {
        try {
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            List options = (List)handlerCtx.getInputValue("options");
            HashMap<String, String> payload = new HashMap<String, String>();
            InstanceHandler.deleteJvmOptions(handlerCtx);
            for (Map oneRow : options) {
                String value = (String)oneRow.get(PROPERTY_VALUE);
                if (value.startsWith("-XX:")) {
                    value = "\"" + value + "\"";
                }
                payload.put("id", value);
                InstanceHandler.addJvmOption(endpoint, payload);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void addJvmOption(String endpoint, Map payload) throws Exception {
        RestResponse response;
        if (endpoint.contains("/profiler")) {
            endpoint = endpoint.substring(0, endpoint.indexOf("/profiler")) + "/jvm-options";
            payload.put("profiler", "true");
        }
        if (!(response = RestApiHandlers.post(endpoint, payload)).isSuccess()) {
            throw new Exception(response.getResponseBody());
        }
    }

    public static void deleteJvmOptions(HandlerContext handlerCtx) throws Exception {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        ArrayList list = InstanceHandler.getJvmOptions(handlerCtx);
        for (Object s : list) {
            RestResponse response;
            String str = (String)s;
            if (str.startsWith("-XX:")) {
                str = "\"" + str + "\"";
            }
            payload.put("id", str);
            if (endpoint.contains("/profiler")) {
                endpoint = endpoint.substring(0, endpoint.indexOf("/profiler")) + "/jvm-options";
                payload.put("profiler", "true");
            }
            if ((response = RestApiHandlers.delete(endpoint, payload)).isSuccess()) continue;
            throw new Exception(response.getResponseBody());
        }
    }

    public static void restartDomain(HandlerContext handlerCtx) {
        V3AMX.getInstance().getRuntime().restartDomain();
    }

    public static void stopDomain(HandlerContext handlerCtx) {
        V3AMX.getInstance().getDomainRoot().stopDomain();
    }

    public static void getJvmReport(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        if (type == null || type.equals("")) {
            type = "summary";
        }
        try {
            String report = V3AMX.getInstance().getRuntime().getJVMReport(type);
            handlerCtx.setOutputValue("report", (Object)report);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("report", (Object)"");
        }
    }
}

