/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.util.GuiUtil;

public class ClusterHandler {
    public static String CLUSTER_RESOURCE_NAME = "org.glassfish.cluster.admingui.Strings";
    public static String RUNNING = "RUNNING";
    public static String NOT_RUNNING = "NOT_RUNNING";
    public static String PARTIALLY_RUNNING = "PARTIALLY_RUNNING";

    public static void getClusterStatusSummary(HandlerContext handlerCtx) {
        Map propsMap = (Map)handlerCtx.getInputValue("listInstancePropsMap");
        int running = 0;
        int notRunning = 0;
        try {
            for (Object value : propsMap.values()) {
                if (value.toString().equals(RUNNING)) {
                    ++running;
                    continue;
                }
                ++notRunning;
            }
            handlerCtx.setOutputValue("numRunning", (Object)GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "cluster.number.instance.running", new String[]{"" + running}));
            handlerCtx.setOutputValue("numNotRunning", (Object)GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "cluster.number.instance.notRunning", new String[]{"" + notRunning}));
        }
        catch (Exception ex) {
            handlerCtx.setOutputValue("status", (Object)GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "cluster.status.unknown"));
        }
    }

    public static void saveInstanceWeight(HandlerContext handlerCtx) {
        List rows = (List)handlerCtx.getInputValue("rows");
        ArrayList<String> errorInstances = new ArrayList<String>();
        Map response = null;
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/servers/server/";
        for (Map oneRow : rows) {
            String instanceName = (String)oneRow.get("Name");
            String endpoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/instanceName";
            HashMap<String, Object> attrsMap = new HashMap<String, Object>();
            attrsMap.put("lbWeight", oneRow.get("LbWeight"));
            try {
                response = RestApiHandlers.restRequest(prefix + instanceName, attrsMap, "post", null);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().severe("Error in saveInstanceWeight ; \nendpoint = " + prefix + instanceName + "attrsMap=" + attrsMap);
                response = null;
            }
            if (response != null) continue;
            errorInstances.add(instanceName);
        }
        if (errorInstances.size() > 0) {
            String details = GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "instance.error.updateWeight", new String[]{"" + errorInstances});
            GuiUtil.handleError(handlerCtx, details);
        }
    }

    public static void clusterAction(HandlerContext handlerCtx) {
        String action = (String)handlerCtx.getInputValue("action");
        List rows = (List)handlerCtx.getInputValue("rows");
        ArrayList<String> errorClusters = new ArrayList<String>();
        Map response = null;
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/";
        for (Map oneRow : rows) {
            String clusterName = (String)oneRow.get("name");
            boolean error = false;
            if (action.equals("delete-cluster")) {
                Map clusterInstanceMap = (Map)handlerCtx.getInputValue("extraInfo");
                List instanceNameList = (List)clusterInstanceMap.get(clusterName);
                for (String instanceName : instanceNameList) {
                    response = ClusterHandler.deleteInstance(instanceName, null);
                    if (response != null) continue;
                    errorClusters.add(clusterName);
                    error = true;
                    break;
                }
                if (error) continue;
            }
            try {
                response = RestApiHandlers.restRequest(prefix + clusterName + "/" + action, null, "post", null);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().severe("Error in clusterAction ; \nendpoint = " + prefix + clusterName + "/" + action + ", attrMap = null");
                response = null;
            }
            if (response != null) continue;
            errorClusters.add(clusterName);
        }
        if (errorClusters.size() > 0) {
            String details = GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "cluster.error.action", new String[]{"" + errorClusters});
            GuiUtil.handleError(handlerCtx, details);
        }
    }

    public static void instanceAction(HandlerContext handlerCtx) {
        String action = (String)handlerCtx.getInputValue("action");
        List rows = (List)handlerCtx.getInputValue("rows");
        ArrayList<String> errorInstances = new ArrayList<String>();
        Map response = null;
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/servers/server/";
        for (Map oneRow : rows) {
            String instanceName = (String)oneRow.get("name");
            if (action.equals("delete-instance")) {
                response = ClusterHandler.deleteInstance(instanceName, (String)oneRow.get("node"));
            } else {
                try {
                    response = RestApiHandlers.restRequest(prefix + instanceName + "/" + action, null, "post", null);
                }
                catch (Exception ex) {
                    GuiUtil.getLogger().severe("Error in instanceAction ; \nendpoint = " + prefix + instanceName + "/" + action + "attrsMap=" + null);
                    response = null;
                }
            }
            if (response != null) continue;
            errorInstances.add(instanceName);
        }
        if (errorInstances.size() > 0) {
            String details = GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "instance.error.action", new String[]{"" + errorInstances});
            GuiUtil.handleError(handlerCtx, details);
        } else if (action.equals("stop-instance")) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public static void nodeAction(HandlerContext handlerCtx) {
        String action = (String)handlerCtx.getInputValue("action");
        HashMap nodeInstanceMap = (HashMap)handlerCtx.getInputValue("nodeInstanceMap");
        if (nodeInstanceMap == null) {
            nodeInstanceMap = new HashMap();
        }
        List rows = (List)handlerCtx.getInputValue("rows");
        ArrayList<String> errorInstances = new ArrayList<String>();
        Map response = null;
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/nodes/node/";
        for (Map oneRow : rows) {
            int code = 500;
            String nodeName = (String)oneRow.get("name");
            List instancesList = (List)nodeInstanceMap.get(nodeName);
            if (instancesList != null && instancesList.size() != 0) {
                GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "nodes.instanceExistError", new String[]{nodeInstanceMap.get(nodeName).toString(), nodeName}));
                return;
            }
            if (action.equals("delete-node")) {
                try {
                    response = RestApiHandlers.restRequest(prefix + nodeName + "/" + action + ".json", null, "post", null);
                }
                catch (Exception ex) {
                    GuiUtil.getLogger().severe("Error in nodeAction ; \nendpoint = " + prefix + nodeName + "/" + action + "attrsMap=" + null);
                    response = null;
                }
            }
            if (response != null) {
                code = (Integer)response.get("responseCode");
                if (code == 200 || code == 201) continue;
                Object body = response.get("responseBody");
                errorInstances.add(body.toString());
                break;
            }
            errorInstances.add(nodeName);
            break;
        }
        if (errorInstances.size() > 0) {
            String details = GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "node.error.delete", new String[]{"" + errorInstances});
            GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), details);
        }
    }

    public static void createClusterInstances(HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        List instanceRow = (List)handlerCtx.getInputValue("instanceRow");
        HashMap<String, Object> attrsMap = new HashMap<String, Object>();
        Map response = null;
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/create-instance";
        for (Map oneInstance : instanceRow) {
            attrsMap.put("name", oneInstance.get("name"));
            attrsMap.put("cluster", clusterName);
            attrsMap.put("node", oneInstance.get("node"));
            try {
                response = RestApiHandlers.restRequest(endpoint, attrsMap, "post", null);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().severe("Error in createCluster ; \nendpoint = " + endpoint + "attrsMap=" + attrsMap);
            }
        }
    }

    public static void getDeploymentTargets(HandlerContext handlerCtx) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("server");
        try {
            Map props;
            List clusterList = (List)handlerCtx.getInputValue("clusterList");
            if (clusterList != null) {
                for (String oneCluster : clusterList) {
                    result.add(oneCluster);
                }
            }
            if ((props = (Map)handlerCtx.getInputValue("listInstanceProps")) != null) {
                result.addAll(props.keySet());
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe(ex.getLocalizedMessage());
        }
        handlerCtx.setOutputValue("result", result);
    }

    private static Map deleteInstance(String instanceName, String nodeName) {
        try {
            return RestApiHandlers.restRequest(GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + instanceName + "/delete-instance", null, "post", null);
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in deleteInstance ; \nendpoint = " + GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + instanceName + "/delete-instance\n" + "attrsMap=" + null);
            return null;
        }
    }
}

