/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.TargetUtil;

public class ResourceHandlers {
    public static void getResourceRealStatus(HandlerContext handlerCtx) {
        List rows = (List)handlerCtx.getInputValue("rows");
        String resourceRefEndPoint = (String)handlerCtx.getInputValue("endpoint");
        for (Map oneRow : rows) {
            String name = (String)oneRow.get("encodedName");
            String endpoint = resourceRefEndPoint + "/" + name;
            if (!RestApiHandlers.get(endpoint).isSuccess()) continue;
            String enabledStr = DeployUtil.getTargetEnableInfo(name, false, false);
            List targets = DeployUtil.getApplicationTarget(name, "resource-ref");
            ArrayList<String> targetUrls = new ArrayList<String>();
            for (String target : targets) {
                if (TargetUtil.isCluster(target)) {
                    targetUrls.add(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + target);
                    continue;
                }
                targetUrls.add(GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + target);
            }
            oneRow.put("targetUrls", targetUrls);
            oneRow.put("enabled", enabledStr);
        }
        handlerCtx.setOutputValue("result", (Object)rows);
    }

    public static void getJMSFactoriesTable(HandlerContext handlerCtx) throws Exception {
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        Map<String, String> children = RestApiHandlers.getChildMap(endpoint);
        ArrayList result = new ArrayList();
        for (Map.Entry<String, String> entry : children.entrySet()) {
            Map<String, Object> poolEntity;
            String poolName = entry.getKey();
            String poolUrl = entry.getValue();
            if (GuiUtil.isEmpty(poolName) || !(poolEntity = RestApiHandlers.getEntityAttrs(poolUrl, "entity")).get("resourceAdapterName").equals("jmsra")) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("selected", false);
            oneRow.put("name", poolName);
            oneRow.put("jndiName", poolEntity.get("name"));
            oneRow.put("connectionDefinitionName", poolEntity.get("connectionDefinitionName"));
            oneRow.put("description", poolEntity.get("description"));
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }
}

