/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.intf.config.JavaConfig;
import org.glassfish.admin.amx.intf.config.MessageSecurityConfig;
import org.glassfish.admin.amx.intf.config.Property;
import org.glassfish.admin.amx.intf.config.ProviderConfig;
import org.glassfish.admin.amx.intf.config.SecurityService;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityHandler {
    private static List skipRealmPropsList = new ArrayList();
    private static List realmClassList;
    private static final String PROPERTY_NAME = "Name";
    private static final String PROPERTY_VALUE = "Value";
    private static final String COMMON_BUNDLE = "org.glassfish.common.admingui.Strings";
    private static final String JVM_OPTION_SECURITY_MANAGER = "-Djava.security.manager";
    private static final String JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL = "-Djava.security.manager=";

    public static void getRealmAttrForCreate(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("realmClasses", (Object)realmClassList);
        handlerCtx.setOutputValue("classnameOption", (Object)"predefine");
        HashMap<String, Boolean> attrMap = new HashMap<String, Boolean>();
        attrMap.put("predefinedClassname", Boolean.TRUE);
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("properties", new ArrayList());
    }

    public static void getRealmAttrForEdit(HandlerContext handlerCtx) {
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        HashMap realmMap = (HashMap)RestApiHandlers.getEntityAttrs(endpoint, "entity");
        HashMap responseMap = (HashMap)RestApiHandlers.restRequest(endpoint + "/property.json", null, "GET", null);
        HashMap propsMap = (HashMap)((Map)responseMap.get("data")).get("extraProperties");
        ArrayList propList = (ArrayList)propsMap.get("properties");
        HashMap<String, Object> origProps = new HashMap<String, Object>();
        for (HashMap prop : propList) {
            origProps.put((String)prop.get("name"), prop.get("value"));
        }
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        attrMap.put(PROPERTY_NAME, (String)realmMap.get("name"));
        attrMap.put("fileJaax", "fileRealm");
        attrMap.put("ldapJaax", "ldapRealm");
        attrMap.put("solarisJaax", "solarisRealm");
        attrMap.put("jdbcJaax", "jdbcRealm");
        String classname = (String)realmMap.get("classname");
        if (realmClassList.contains(classname)) {
            handlerCtx.setOutputValue("classnameOption", (Object)"predefine");
            attrMap.put("predefinedClassname", Boolean.TRUE);
            attrMap.put("classname", classname);
            List props = SecurityHandler.getChildrenMapForTableList(origProps, "property", skipRealmPropsList);
            handlerCtx.setOutputValue("properties", (Object)props);
            if (classname.indexOf("FileRealm") != -1) {
                attrMap.put("file", origProps.get("file"));
                attrMap.put("fileJaax", origProps.get("jaas-context"));
                attrMap.put("fileAsGroups", origProps.get("assign-groups"));
            } else if (classname.indexOf("LDAPRealm") != -1) {
                attrMap.put("ldapJaax", origProps.get("jaas-context"));
                attrMap.put("ldapAsGroups", origProps.get("assign-groups"));
                attrMap.put("directory", origProps.get("directory"));
                attrMap.put("baseDn", origProps.get("base-dn"));
            } else if (classname.indexOf("SolarisRealm") != -1) {
                attrMap.put("solarisJaax", origProps.get("jaas-context"));
                attrMap.put("solarisAsGroups", origProps.get("assign-groups"));
            } else if (classname.indexOf("JDBCRealm") != -1) {
                attrMap.put("jdbcJaax", origProps.get("jaas-context"));
                attrMap.put("jdbcAsGroups", origProps.get("assign-groups"));
                attrMap.put("datasourceJndi", origProps.get("datasource-jndi"));
                attrMap.put("userTable", origProps.get("user-table"));
                attrMap.put("userNameColumn", origProps.get("user-name-column"));
                attrMap.put("passwordColumn", origProps.get("password-column"));
                attrMap.put("groupTable", origProps.get("group-table"));
                attrMap.put("groupNameColumn", origProps.get("group-name-column"));
                attrMap.put("dbUser", origProps.get("db-user"));
                attrMap.put("dbPassword", origProps.get("db-password"));
                attrMap.put("digestAlgorithm", origProps.get("digest-algorithm"));
                attrMap.put("encoding", origProps.get("encoding"));
                attrMap.put("charset", origProps.get("charset"));
            } else if (classname.indexOf("CertificateRealm") != -1) {
                attrMap.put("certAsGroups", origProps.get("assign-groups"));
            }
        } else {
            handlerCtx.setOutputValue("classnameOption", (Object)"input");
            attrMap.put("predefinedClassname", Boolean.FALSE);
            attrMap.put("classnameInput", classname);
            List<HashMap> props = SecurityHandler.getListfromMap(origProps);
            handlerCtx.setOutputValue("properties", props);
        }
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("realmClasses", (Object)realmClassList);
    }

    public static List getChildrenMapForTableList(Map<String, Object> realmMap, String childType, List skipList) {
        boolean hasSkip = true;
        if (skipList == null) {
            hasSkip = false;
        }
        ArrayList result = new ArrayList();
        if (realmMap != null) {
            Set<Map.Entry<String, Object>> s = realmMap.entrySet();
            for (Map.Entry<String, Object> m : s) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                if (hasSkip && skipList.contains(m.getKey())) continue;
                oneRow.put("selected", false);
                oneRow.put(m.getKey(), m.getValue());
                oneRow.put("encodedName", GuiUtil.encode(m.getKey(), null, null));
                result.add(oneRow);
            }
        }
        return result;
    }

    public static List<HashMap> getListfromMap(HashMap<String, Object> props) {
        ArrayList<HashMap> result = new ArrayList<HashMap>();
        for (Map.Entry<String, Object> m : props.entrySet()) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("selected", false);
            oneRow.put(PROPERTY_NAME, m.getKey());
            oneRow.put(PROPERTY_VALUE, m.getValue());
            oneRow.put("Description", "");
            result.add(oneRow);
        }
        return result;
    }

    public static void saveRealm(HandlerContext handlerCtx) {
        String option = (String)handlerCtx.getInputValue("classnameOption");
        List propList = (List)handlerCtx.getInputValue("propList");
        HashMap<String, String> attrMap = (HashMap<String, String>)handlerCtx.getInputValue("attrMap");
        if (attrMap == null) {
            attrMap = new HashMap<String, String>();
        }
        String classname = "";
        try {
            if (option.equals("predefine")) {
                classname = (String)attrMap.get("classname");
                if (classname.indexOf("FileRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "file", "file");
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "fileJaax");
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "fileAsGroups");
                } else if (classname.indexOf("LDAPRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "ldapJaax");
                    SecurityHandler.putOptional(attrMap, propList, "base-dn", "baseDn");
                    SecurityHandler.putOptional(attrMap, propList, "directory", "directory");
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "ldapAsGroups");
                } else if (classname.indexOf("SolarisRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "solarisJaax");
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "solarisAsGroups");
                } else if (classname.indexOf("JDBCRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "jdbcJaax");
                    SecurityHandler.putOptional(attrMap, propList, "datasource-jndi", "datasourceJndi");
                    SecurityHandler.putOptional(attrMap, propList, "user-table", "userTable");
                    SecurityHandler.putOptional(attrMap, propList, "user-name-column", "userNameColumn");
                    SecurityHandler.putOptional(attrMap, propList, "password-column", "passwordColumn");
                    SecurityHandler.putOptional(attrMap, propList, "group-table", "groupTable");
                    SecurityHandler.putOptional(attrMap, propList, "group-name-column", "groupNameColumn");
                    SecurityHandler.putOptional(attrMap, propList, "db-user", "dbUser");
                    SecurityHandler.putOptional(attrMap, propList, "db-password", "dbPassword");
                    SecurityHandler.putOptional(attrMap, propList, "digest-algorithm", "digestAlgorithm");
                    SecurityHandler.putOptional(attrMap, propList, "encoding", "encoding");
                    SecurityHandler.putOptional(attrMap, propList, "charset", "charset");
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "jdbcAsGroups");
                } else if (classname.indexOf("CertificateRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "certAsGroups");
                }
            } else {
                classname = (String)attrMap.get("classnameInput");
            }
            Boolean edit = (Boolean)handlerCtx.getInputValue("edit");
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            if (edit.booleanValue()) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("classname", classname);
                String propertyStr = "";
                for (Map oneProp : propList) {
                    propertyStr = propertyStr + oneProp.get("name") + "=";
                    propertyStr = propertyStr + oneProp.get("value") + ":";
                }
                values.put("property", propertyStr);
                RestApiHandlers.restRequest(endpoint, values, "post", handlerCtx);
            } else {
                HashMap<String, Object> cMap = new HashMap<String, Object>();
                cMap.put("name", attrMap.get(PROPERTY_NAME));
                cMap.put("classname", classname);
                String propertyStr = "";
                for (Map oneProp : propList) {
                    propertyStr = propertyStr + oneProp.get("name") + "=";
                    propertyStr = propertyStr + oneProp.get("value") + ":";
                }
                endpoint = endpoint + "/auth-realm";
                cMap.put("property", propertyStr);
                RestApiHandlers.restRequest(endpoint, cMap, "post", handlerCtx);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void putOptional(Map<String, String> attrMap, List propList, String propName, String key) {
        HashMap<String, String> oneProp = new HashMap<String, String>();
        oneProp.put("name", propName);
        String value = attrMap.get(key);
        if (GuiUtil.isEmpty(value)) {
            return;
        }
        oneProp.put("value", attrMap.get(key));
        propList.add(oneProp);
    }

    public static void saveUser(HandlerContext handlerCtx) {
        try {
            String endpoint;
            String realmName = (String)handlerCtx.getInputValue("Realm");
            String configName = (String)handlerCtx.getInputValue("configName");
            String grouplist = (String)handlerCtx.getInputValue("GroupList");
            String password = (String)handlerCtx.getInputValue("Password");
            String userid = (String)handlerCtx.getInputValue("UserId");
            Boolean createNew = (Boolean)handlerCtx.getInputValue("CreateNew");
            if (password == null) {
                password = "";
            }
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            if (createNew == null) {
                endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/auth-realm/" + realmName + "/delete-user";
                attrs.put("username", userid);
                RestResponse response = RestApiHandlers.delete(endpoint, attrs);
                if (!response.isSuccess()) {
                    GuiUtil.getLogger().severe("Remove user failed.  parent=" + endpoint + "; attrs =" + attrs);
                    GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
                }
                createNew = Boolean.TRUE;
            }
            if (createNew != null && createNew == Boolean.TRUE) {
                endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/auth-realm/" + realmName + "/create-user";
                attrs = new HashMap();
                attrs.put("username", userid);
                attrs.put("authrealmname", realmName);
                attrs.put("userpassword", password);
                ArrayList grpList = GuiUtil.parseStringList(grouplist, ",");
                if (grpList == null) {
                    grpList = new ArrayList(0);
                }
                attrs.put("groups", grpList);
                RestResponse response = RestApiHandlers.post(endpoint, attrs);
                if (!response.isSuccess()) {
                    GuiUtil.getLogger().severe("Add user failed.  parent=" + endpoint + "; attrs =" + attrs);
                    GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getUserInfo(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("Realm");
        String userName = (String)handlerCtx.getInputValue("User");
        String configName = (String)handlerCtx.getInputValue("configName");
        handlerCtx.setOutputValue("GroupList", (Object)SecurityHandler.getGroupNames(realmName, userName, configName, handlerCtx));
    }

    public static void getFileUsers(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("Realm");
        String configName = (String)handlerCtx.getInputValue("configName");
        ArrayList result = new ArrayList();
        try {
            String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/auth-realm/" + realmName + "/list-users.json";
            Map responseMap = RestApiHandlers.restRequest(endpoint, null, "get", handlerCtx);
            responseMap = (Map)responseMap.get("data");
            List children = (List)responseMap.get("children");
            if (children != null) {
                HashMap<String, Object> map = null;
                for (HashMap child : children) {
                    map = new HashMap<String, Object>();
                    String name = (String)child.get("message");
                    map.put("users", name);
                    map.put("groups", SecurityHandler.getGroupNames(realmName, name, configName, handlerCtx));
                    map.put("selected", false);
                    result.add(map);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void removeUser(HandlerContext handlerCtx) {
        String error = null;
        String realmName = (String)handlerCtx.getInputValue("Realm");
        String configName = (String)handlerCtx.getInputValue("configName");
        try {
            List obj;
            List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
            for (Map oneRow : selectedRows) {
                String user = (String)oneRow.get("name");
                String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/admin-service/jmx-connector/system.json";
                Map responseMap = RestApiHandlers.restRequest(endpoint, null, "get", handlerCtx);
                Map valueMap = (Map)responseMap.get("data");
                String authRealm = (String)(valueMap = (Map)((Map)valueMap.get("extraProperties")).get("entity")).get("authRealmName");
                if (realmName.equals(authRealm) && user.equals(GuiUtil.getSessionValue("userName"))) {
                    error = GuiUtil.getMessage(COMMON_BUNDLE, "msg.error.cannotDeleteCurrent");
                    continue;
                }
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/auth-realm/" + realmName + "/delete-user";
                attrs.put("name", user);
                RestResponse response = RestApiHandlers.delete(endpoint, attrs);
                if (response.isSuccess()) continue;
                GuiUtil.getLogger().severe("Remove user failed.  parent=" + endpoint + "; attrs =" + attrs);
                error = GuiUtil.getMessage("msg.error.checkLog");
            }
            if (error != null) {
                GuiUtil.prepareAlert(handlerCtx, "error", error, null);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void hasManageUserButton(HandlerContext handlerCtx) {
        try {
            String realmName = (String)handlerCtx.getInputValue("realmName");
            handlerCtx.setOutputValue("result", (Object)V3AMX.getInstance().getRealmsMgr().supportsUserManagement(realmName));
        }
        catch (Exception ex) {
            handlerCtx.setOutputValue("result", (Object)false);
        }
    }

    private static String getGroupNames(String realmName, String userName, String configName, HandlerContext handlerCtx) {
        try {
            String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/auth-realm/" + realmName + "/list-group-names?username=" + userName;
            Map responseMap = RestApiHandlers.restRequest(endpoint, null, "get", handlerCtx);
            HashMap children = (HashMap)((Map)responseMap.get("data")).get("extraProperties");
            String name = (String)((List)children.get("groups")).get(0);
            return name;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static void addDefaultProviderInfo(HandlerContext handlerCtx) {
        ArrayList providerList = (ArrayList)handlerCtx.getInputValue("providerList");
        String configName = (String)handlerCtx.getInputValue("configName");
        String msgSecurityName = (String)handlerCtx.getInputValue("msgSecurityName");
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/message-security-config/" + msgSecurityName;
        Map<String, Object> valueMap = RestApiHandlers.getEntityAttrs(endpoint, "entity");
        String defaultProvider = (String)valueMap.get("defaultProvider");
        String defaultClientProvider = (String)valueMap.get("defaultClientProvider");
        String trueStr = GuiUtil.getMessage("common.true");
        String falseStr = GuiUtil.getMessage("common.false");
        for (HashMap oneRow : providerList) {
            if (defaultProvider.length() > 0 || defaultClientProvider.length() > 0) {
                oneRow.put("default", trueStr);
                continue;
            }
            oneRow.put("default", falseStr);
        }
    }

    public static void createMsgSecurity(HandlerContext handlerCtx) {
        Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
        String providerName = (String)attrMap.get(PROPERTY_NAME);
        HashMap<String, Object> providerAttrs = new HashMap<String, Object>();
        providerAttrs.put(PROPERTY_NAME, providerName);
        providerAttrs.put("ProviderType", attrMap.get("ProviderType"));
        providerAttrs.put("ClassName", attrMap.get("ClassName"));
        List pList = V3AMX.verifyPropertyList((List)handlerCtx.getInputValue("propList"));
        if (pList.size() > 0) {
            Map[] propMaps = pList.toArray(new Map[pList.size()]);
            providerAttrs.put(Util.deduceType(Property.class), propMaps);
        }
        HashMap msgAttrs = new HashMap();
        msgAttrs.put("AuthLayer", attrMap.get("AuthLayer"));
        if ("true".equals(attrMap.get("defaultProvider"))) {
            String type = (String)attrMap.get("ProviderType");
            if (type.equals("server") || type.equals("client-server")) {
                msgAttrs.put("DefaultProvider", providerName);
            }
            if (type.equals("client") || type.equals("client-server")) {
                msgAttrs.put("DefaultClientProvider", providerName);
            }
        }
        msgAttrs.put(Util.deduceType(ProviderConfig.class), providerAttrs);
        SecurityService ss = V3AMX.getInstance().getConfig("server-config").getSecurityService();
        AMXConfigProxy msgConfig = ss.createChild("message-security-config", msgAttrs);
        ProviderConfig provider = (ProviderConfig)msgConfig.childrenMap(ProviderConfig.class).get(providerName);
        handlerCtx.setOutputValue("providerObjName", (Object)provider.objectName().toString());
    }

    public static void getMessageSecurityAuthLayersForCreate(HandlerContext handlerCtx) throws Exception {
        ArrayList<String> layers = new ArrayList<String>();
        String configName = (String)handlerCtx.getInputValue("configName");
        layers.add("SOAP");
        layers.add("HttpServlet");
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/message-security-config";
        Set<String> msgSecurityCfgs = RestApiHandlers.getChildMap(endpoint).keySet();
        for (String name : msgSecurityCfgs) {
            if (!layers.contains(name)) continue;
            layers.remove(name);
        }
        handlerCtx.setOutputValue("layers", layers);
    }

    public static void getProvidersByType(HandlerContext handlerCtx) throws Exception {
        List type = (List)handlerCtx.getInputValue("type");
        ArrayList<String> result = new ArrayList<String>();
        String configName = (String)handlerCtx.getInputValue("configName");
        String msgSecurityName = (String)handlerCtx.getInputValue("msgSecurityName");
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/message-security-config/" + msgSecurityName + "/provider-config";
        List<String> providers = RestApiHandlers.getChildList(endpoint);
        for (String providerEndpoint : providers) {
            HashMap providerAttrs = (HashMap)RestApiHandlers.getAttributesMap(providerEndpoint);
            String providerType = (String)providerAttrs.get("providerType");
            if (!type.contains(providerType)) continue;
            result.add(com.sun.jsftemplating.util.Util.htmlEscape((String)((String)providerAttrs.get("providerId"))));
        }
        result.add(0, "");
        handlerCtx.setOutputValue("result", result);
    }

    public static void saveMsgProviderInfo(HandlerContext handlerCtx) {
        Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
        String edit = (String)handlerCtx.getInputValue("edit");
        String providerName = (String)attrMap.get(PROPERTY_NAME);
        String msgSecurityName = (String)attrMap.get("msgSecurityName");
        String configName = (String)attrMap.get("configName");
        List propList = (List)handlerCtx.getInputValue("propList");
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/message-security-config/" + msgSecurityName + "/provider-config";
        String providerEndpoint = endpoint + "/" + providerName;
        if (edit.equals("true")) {
            boolean providerExist = RestApiHandlers.get(providerEndpoint).isSuccess();
            if (!providerExist) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage(COMMON_BUNDLE, "msg.error.noSuchProvider"));
                return;
            }
            Map<String, Object> providerMap = RestApiHandlers.getEntityAttrs(providerEndpoint, "entity");
            providerMap.put("className", attrMap.get("ClassName"));
            providerMap.put("providerType", attrMap.get("ProviderType"));
            RestApiHandlers.sendUpdateRequest(endpoint, providerMap, null, null, null);
        } else {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("providerId", attrMap.get(PROPERTY_NAME));
            attrs.put("className", attrMap.get("ClassName"));
            attrs.put("providerType", attrMap.get("ProviderType"));
            if (propList.size() > 0) {
                Map[] propMaps = propList.toArray(new Map[propList.size()]);
                attrs.put(Util.deduceType(Property.class), propMaps);
            }
            RestApiHandlers.sendCreateRequest(endpoint, attrs, null, null, null);
        }
        String[] attrList = new String[]{"Request-AuthSource", "Request-AuthRecipient", "Response-AuthSource", "Response-AuthRecipient"};
        for (int i = 0; i < attrList.length; ++i) {
            if (!"".equals(attrMap.get(attrList[i]))) continue;
            attrMap.put(attrList[i], null);
        }
        HashMap<String, Object> reqPolicyMap = new HashMap<String, Object>();
        reqPolicyMap.put("authSource", attrMap.get("Request-AuthSource"));
        reqPolicyMap.put("authRecipient", attrMap.get("Request-AuthRecipient"));
        String reqPolicyEP = providerEndpoint + "/request-policy";
        RestApiHandlers.sendUpdateRequest(reqPolicyEP, reqPolicyMap, null, null, null);
        HashMap<String, Object> respPolicyMap = new HashMap<String, Object>();
        respPolicyMap.put("authSource", attrMap.get("Response-AuthSource"));
        respPolicyMap.put("authRecipient", attrMap.get("Response-AuthRecipient"));
        String respPolicyEP = providerEndpoint + "/response-policy";
        RestApiHandlers.sendUpdateRequest(respPolicyEP, respPolicyMap, null, null, null);
    }

    public static void checkMsgSecurityDefaultProvider(HandlerContext handlerCtx) {
        String defClient;
        String msgSecurityName = (String)handlerCtx.getInputValue("msgSecurityName");
        MessageSecurityConfig msgConfig = SecurityHandler.getMsgSecurityProxy(msgSecurityName);
        String defServer = msgConfig.getDefaultProvider();
        if (!GuiUtil.isEmpty(defServer) && msgConfig.childrenMap(ProviderConfig.class).get(defServer) == null) {
            msgConfig.setDefaultProvider(null);
        }
        if (!GuiUtil.isEmpty(defClient = msgConfig.getDefaultClientProvider()) && msgConfig.childrenMap(ProviderConfig.class).get(defClient) == null) {
            msgConfig.setDefaultClientProvider(null);
        }
    }

    public static void saveSecurityManagerValue(HandlerContext handlerCtx) {
        int i;
        String value;
        Boolean userValue;
        JavaConfig javaC;
        Boolean status;
        String configName = (String)handlerCtx.getInputValue("configName");
        if (GuiUtil.isEmpty(configName)) {
            configName = "server-config";
        }
        if ((status = SecurityHandler.isSecurityManagerEnabled(javaC = V3AMX.getInstance().getConfig(configName).getJavaConfig())).equals(userValue = new Boolean(value = (String)handlerCtx.getInputValue("value")))) {
            return;
        }
        ArrayList<String> newOptions = new ArrayList<String>();
        String[] origOptions = javaC.getJvmOptions();
        if (userValue.booleanValue()) {
            for (i = 0; i < origOptions.length; ++i) {
                newOptions.add(origOptions[i]);
            }
            newOptions.add(JVM_OPTION_SECURITY_MANAGER);
        } else {
            for (i = 0; i < origOptions.length; ++i) {
                if (origOptions[i].trim().equals(JVM_OPTION_SECURITY_MANAGER) || origOptions[i].trim().startsWith(JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL)) continue;
                newOptions.add(origOptions[i]);
            }
        }
        String[] jvmOptions = newOptions.toArray(new String[0]);
        javaC.setJvmOptions(jvmOptions);
    }

    public static void getSecurityManagerValue(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("configName");
        if (GuiUtil.isEmpty(configName)) {
            configName = "server-config";
        }
        JavaConfig javaC = V3AMX.getInstance().getConfig(configName).getJavaConfig();
        handlerCtx.setOutputValue("value", (Object)SecurityHandler.isSecurityManagerEnabled(javaC).toString());
    }

    private static Boolean isSecurityManagerEnabled(JavaConfig javaC) {
        String[] jvmOptions = javaC.getJvmOptions();
        for (int i = 0; i < jvmOptions.length; ++i) {
            if (!jvmOptions[i].trim().equals(JVM_OPTION_SECURITY_MANAGER) && !jvmOptions[i].trim().startsWith(JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static MessageSecurityConfig getMsgSecurityProxy(String msgSecurityName) {
        Set pSet = V3AMX.getInstance().getDomainRoot().getQueryMgr().queryTypeName("message-security-config", msgSecurityName);
        Iterator i$ = pSet.iterator();
        if (i$.hasNext()) {
            AMXProxy msgProxy = (AMXProxy)i$.next();
            return (MessageSecurityConfig)msgProxy.as(MessageSecurityConfig.class);
        }
        return null;
    }

    private static String str(String aa) {
        return aa == null ? "" : aa;
    }

    static {
        String[] classnames = V3AMX.getInstance().getRealmsMgr().getPredefinedAuthRealmClassNames();
        realmClassList = new ArrayList();
        realmClassList.add("");
        for (int i = 0; i < classnames.length; ++i) {
            realmClassList.add(classnames[i]);
        }
        skipRealmPropsList.add("jaas-context");
        skipRealmPropsList.add("file");
        skipRealmPropsList.add("assign-groups");
        skipRealmPropsList.add("base-dn");
        skipRealmPropsList.add("directory");
        skipRealmPropsList.add("datasource-jndi");
        skipRealmPropsList.add("user-table");
        skipRealmPropsList.add("user-name-column");
        skipRealmPropsList.add("password-column");
        skipRealmPropsList.add("group-table");
        skipRealmPropsList.add("group-name-column");
        skipRealmPropsList.add("db-user");
        skipRealmPropsList.add("db-password");
        skipRealmPropsList.add("digest-algorithm");
        skipRealmPropsList.add("encoding");
        skipRealmPropsList.add("charset");
    }
}

