/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import org.glassfish.admin.amx.base.Query;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringHandlers {
    private static final List<String> levels = new ArrayList<String>();
    public static final String JRUBY = "JRuby Container";
    public static final String JVM = "JVM";
    public static final String WEB_CONTAINER = "Web Container";
    public static final String HTTP_SERVICE = "HTTP Service";
    public static final String THREAD_POOL = "Thread Pool";
    public static final String JDBC_CONNECTION_POOL = "JDBC Connection Pool";
    public static final String CONNECTOR_CONNECTION_POOL = "Connector Connection Pool";
    public static final String EJB_CONTAINER = "EJB Container";
    public static final String TRANSACTION_SERVICE = "Transaction Service";
    public static final String ORB = "ORB";
    public static final String CONNECTOR_SERVICE = "Connector Service";
    public static final String JMS_SERVICE = "JMS Service";
    public static final String WEB_SERVICES_CONTAINER = "Web Services Container";
    public static final String JPA = "JPA";
    public static final String SECURITY = "Security";
    public static final String JERSEY = "Jersey";
    private static final List monDisplayList;
    private static final List monNamesList;
    private static final List containerDispList;
    private static final List containerNameList;

    public static void getMonitorLevels(HandlerContext handlerCtx) {
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        ArrayList result = new ArrayList();
        try {
            String value;
            String dispName;
            ListIterator vi;
            String monitoringServiceEndPoint = endpoint + "/monitoring-service";
            Map<String, Object> attrs = RestApiHandlers.getEntityAttrs(monitoringServiceEndPoint + "/container-monitoring", "entitiy");
            if (attrs != null) {
                for (String prop : attrs.keySet()) {
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    String cname = null;
                    String pname = prop;
                    ListIterator ci = containerDispList.listIterator();
                    vi = containerNameList.listIterator();
                    while (ci.hasNext() && vi.hasNext()) {
                        dispName = (String)ci.next();
                        value = (String)vi.next();
                        if (!pname.equals(value)) continue;
                        cname = dispName;
                    }
                    oneRow.put("monCompName", cname == null ? pname : cname);
                    oneRow.put("level", attrs.get(prop));
                    oneRow.put("selected", false);
                    result.add(oneRow);
                }
            }
            String monitoringLevelsEndPoint = monitoringServiceEndPoint + "/module-monitoring-levels";
            attrs = RestApiHandlers.getEntityAttrs(monitoringLevelsEndPoint, "entity");
            for (String oneMonComp : attrs.keySet()) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                String name = null;
                ListIterator ni = monDisplayList.listIterator();
                vi = monNamesList.listIterator();
                while (ni.hasNext() && vi.hasNext()) {
                    dispName = (String)ni.next();
                    value = (String)vi.next();
                    if (!oneMonComp.equals(value)) continue;
                    name = dispName;
                }
                if (name == null) {
                    name = oneMonComp;
                }
                oneRow.put("monCompName", name);
                oneRow.put("level", attrs.get(oneMonComp));
                oneRow.put("selected", false);
                result.add(oneRow);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("monitorCompList", result);
    }

    public static void getStats(HandlerContext handlerCtx) {
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String statType = (String)handlerCtx.getInputValue("statType");
        String type = (String)handlerCtx.getInputValue("type");
        Locale locale = GuiUtil.getLocale();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, locale);
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        ArrayList result = new ArrayList();
        try {
            if ((type == null || statType == null || type.equals(statType)) && MonitoringHandlers.doesProxyExist(endpoint).booleanValue()) {
                Map<String, Object> stats = MonitoringHandlers.getMonitoringStatInfo(endpoint);
                for (String statName : stats.keySet()) {
                    Long startTime;
                    Map monAttrs = (Map)stats.get(statName);
                    HashMap<String, String> statMap = new HashMap<String, String>();
                    String val = "";
                    String details = "--";
                    String desc = "--";
                    String start = "--";
                    String last = "--";
                    String unit = "";
                    String current = "";
                    String mname = null;
                    String runtimes = null;
                    String queuesize = null;
                    String thresholds = "--";
                    HashMap statsMap = new HashMap();
                    if (monAttrs.size() == 0) continue;
                    if (monAttrs.containsKey("name")) {
                        mname = (String)monAttrs.get("name");
                    } else if (monAttrs.containsKey("appname")) {
                        mname = (String)monAttrs.get("appname");
                    }
                    unit = (String)monAttrs.get("unit");
                    desc = (String)monAttrs.get("description");
                    Long lastTime = (Long)monAttrs.get("lastsampletime");
                    if (lastTime != -1L) {
                        last = df.format(new Date(lastTime));
                    }
                    if ((startTime = (Long)monAttrs.get("starttime")) != -1L) {
                        start = df.format(new Date(startTime));
                    }
                    if (monAttrs.containsKey("count")) {
                        val = monAttrs.get("count") + " " + unit;
                    } else if (monAttrs.containsKey("current")) {
                        if (statName.equals("transaction-service")) {
                            String str = (String)monAttrs.get("current");
                            String formatStr = MonitoringHandlers.formatActiveIdsForDisplay(str);
                            if (!formatStr.isEmpty() && !formatStr.equals("")) {
                                val = formatStr;
                            }
                        } else if (unit != null) {
                            if (unit.equals("String")) {
                                val = (String)monAttrs.get("current");
                            } else {
                                Long currentVal = (Long)monAttrs.get("current");
                                val = currentVal + unit;
                            }
                        }
                    } else if (monAttrs.containsKey("applicationtype")) {
                        val = (String)monAttrs.get("applicationtype");
                    }
                    if (monAttrs.containsKey("appName")) {
                        details = GuiUtil.getMessage("msg.AppName") + ": " + monAttrs.get("appName") + "<br/>";
                    }
                    if (monAttrs.containsKey("appname")) {
                        details = GuiUtil.getMessage("msg.AppName") + ": " + monAttrs.get("appname") + "<br/>";
                    }
                    if (monAttrs.containsKey("jrubyversion")) {
                        details = details + GuiUtil.getMessage("msg.JrubyVersion") + ": " + monAttrs.get("jrubyversion") + "<br/>";
                    }
                    if (monAttrs.containsKey("rubyframework")) {
                        details = details + GuiUtil.getMessage("msg.Framework") + ": " + monAttrs.get("rubyframework") + "<br/>";
                    }
                    if (monAttrs.containsKey("environment")) {
                        details = details + GuiUtil.getMessage("msg.Environment") + ": " + monAttrs.get("environment") + "<br/>";
                    }
                    if (monAttrs.containsKey("address")) {
                        details = details + GuiUtil.getMessage("msg.Address") + ": " + monAttrs.get("address") + "<br/>";
                    }
                    if (monAttrs.containsKey("deploymenttype")) {
                        details = details + GuiUtil.getMessage("msg.DepType") + ": " + monAttrs.get("deploymenttype") + "<br/>";
                    }
                    if (monAttrs.containsKey("endpointname")) {
                        details = details + GuiUtil.getMessage("msg.EndPointName") + ": " + monAttrs.get("endpointname") + "<br/>";
                    }
                    if (monAttrs.containsKey("classname")) {
                        details = GuiUtil.getMessage("msg.ClassName") + ": " + monAttrs.get("classname") + "<br/>";
                    }
                    if (monAttrs.containsKey("impltype")) {
                        details = details + GuiUtil.getMessage("msg.ImplClass") + ": " + monAttrs.get("implclass") + "<br/>";
                    }
                    if (monAttrs.containsKey("implclass") && monAttrs.containsKey("impltype")) {
                        details = details + GuiUtil.getMessage("msg.ImplType") + ": " + monAttrs.get("impltype") + "<br/>";
                    }
                    if (monAttrs.containsKey("namespace")) {
                        details = details + GuiUtil.getMessage("msg.NameSpace") + ": " + monAttrs.get("namespace") + "<br/>";
                    }
                    if (monAttrs.containsKey("portname")) {
                        details = details + GuiUtil.getMessage("msg.PortName") + ": " + monAttrs.get("portname") + "<br/>";
                    }
                    if (monAttrs.containsKey("servicename")) {
                        details = details + GuiUtil.getMessage("msg.ServiceName") + ": " + monAttrs.get("servicename") + "<br/>";
                    }
                    if (monAttrs.containsKey("tester")) {
                        details = details + GuiUtil.getMessage("msg.Tester") + ": " + monAttrs.get("tester") + "<br/>";
                    }
                    if (monAttrs.containsKey("wsdl")) {
                        details = details + GuiUtil.getMessage("msg.WSDL") + ": " + monAttrs.get("wsdl") + "<br/>";
                    }
                    if (monAttrs.containsKey("maxtime")) {
                        details = GuiUtil.getMessage("msg.MaxTime") + ": " + monAttrs.get("maxtime") + " " + unit + "<br/>";
                    }
                    if (monAttrs.containsKey("mintime")) {
                        details = details + GuiUtil.getMessage("msg.MinTime") + ": " + monAttrs.get("mintime") + " " + unit + "<br/>";
                    }
                    if (monAttrs.containsKey("totaltime")) {
                        details = details + GuiUtil.getMessage("msg.TotalTime") + ": " + monAttrs.get("totaltime") + " " + unit + "<br/>";
                    }
                    if (monAttrs.containsKey("highwatermark")) {
                        details = GuiUtil.getMessage("msg.HWaterMark") + ": " + monAttrs.get("highwatermark") + " " + unit + "<br/>";
                    }
                    if (monAttrs.containsKey("lowwatermark")) {
                        details = details + GuiUtil.getMessage("msg.LWaterMark") + ": " + monAttrs.get("lowwatermark") + " " + unit + "<br/>";
                    }
                    if (monAttrs.containsKey("activeruntimes")) {
                        runtimes = (String)monAttrs.get("activeruntimes");
                    }
                    if (monAttrs.containsKey("queuesize")) {
                        queuesize = (String)monAttrs.get("queuesize");
                    }
                    if (monAttrs.containsKey("hardmaximum") && monAttrs.get("hardmaximum") != null) {
                        val = monAttrs.get("hardmaximum") + " " + "hard max " + "<br/>" + monAttrs.get("hardminimum") + " " + "hard min";
                    }
                    if (monAttrs.containsKey("newthreshold") && monAttrs.get("newThreshold") != null) {
                        thresholds = monAttrs.get("newthreshold") + " " + "new " + "<br/>" + monAttrs.get("queuedownthreshold") + " " + "queue down";
                    }
                    if (monAttrs.containsKey("queuesize") && monAttrs.containsKey("jrubyversion")) {
                        details = details + monAttrs.get("environment") + " " + monAttrs.get("jrubyversion");
                    }
                    statMap.put("name", mname);
                    statMap.put("startTime", start);
                    statMap.put("lastTime", last);
                    statMap.put("description", desc);
                    statMap.put("value", val == null ? "" : val);
                    statMap.put("details", details == null ? "--" : details);
                    statMap.put("thresholds", thresholds == null ? "--" : thresholds);
                    statMap.put("queueSize", queuesize == null ? "--" : queuesize);
                    statMap.put("runtimes", runtimes == null ? "--" : runtimes);
                    result.add(statMap);
                }
            }
            handlerCtx.setOutputValue("result", result);
            handlerCtx.setOutputValue("hasStats", (Object)(result.size() != 0 ? 1 : 0));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getStatsbyTypeName(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        String name = (String)handlerCtx.getInputValue("name");
        Locale locale = GuiUtil.getLocale();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, locale);
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        ArrayList result = new ArrayList();
        try {
            Query query = V3AMX.getInstance().getDomainRoot().getQueryMgr();
            Set amxproxy = query.queryTypeName(type, name);
            Iterator iter = amxproxy.iterator();
            while (iter.hasNext()) {
                Map monattrs = ((AMXProxy)iter.next()).attributesMap();
                for (String monName : monattrs.keySet()) {
                    if (monName.equals("Parent") || monName.equals("Children") || monName.equals("Name")) continue;
                    HashMap<String, Object> statMap = new HashMap<String, Object>();
                    Object val = monattrs.get(monName);
                    String details = "--";
                    String desc = "--";
                    Object start = "--";
                    Object last = "--";
                    String unit = "";
                    String current = "";
                    String mname = null;
                    Integer runtimes = null;
                    Object queuesize = null;
                    String thresholds = "--";
                    boolean nostatskey = true;
                    if (val instanceof CompositeDataSupport) {
                        CompositeDataSupport cds = (CompositeDataSupport)val;
                        CompositeType ctype = cds.getCompositeType();
                        if (cds.containsKey("statistics")) {
                            Object statistics = cds.get("statistics");
                            if (statistics instanceof CompositeData[]) {
                                CompositeData[] mycd = (CompositeData[])cds.get("statistics");
                                if (((CompositeData[])cds.get("statistics")).length == 0) {
                                    val = "--";
                                }
                                for (CompositeData cd : (CompositeData[])cds.get("statistics")) {
                                    String statname = null;
                                    nostatskey = false;
                                    HashMap<String, Object> statsMap = new HashMap<String, Object>();
                                    if (cd.containsKey("name") && type.equals("web-service-mon")) {
                                        val = cd.get("name");
                                    }
                                    if (cd.containsKey("name") && cd.containsKey("count")) {
                                        statname = (String)cd.get("name");
                                    }
                                    if (cd.containsKey("name") && !cd.containsKey("count")) {
                                        val = cd.get("name");
                                    }
                                    if (cd.containsKey("unit")) {
                                        unit = (String)cd.get("unit");
                                    }
                                    if (cd.containsKey("count")) {
                                        val = cd.get("count") + " " + unit;
                                    }
                                    if (cd.containsKey("description")) {
                                        desc = (String)cd.get("description");
                                    }
                                    if (cd.containsKey("lastSampleTime")) {
                                        last = (Long)cd.get("lastSampleTime") == -1L ? cd.get("lastSampleTime") : df.format(new Date((Long)cd.get("lastSampleTime")));
                                    }
                                    if (cd.containsKey("startTime")) {
                                        start = (Long)cd.get("startTime") == -1L ? cd.get("startTime") : df.format(new Date((Long)cd.get("lastSampleTime")));
                                    }
                                    if (cd.containsKey("appName")) {
                                        details = GuiUtil.getMessage("msg.AppName") + ": " + cd.get("appName") + "<br/>";
                                    }
                                    if (cd.containsKey("appname")) {
                                        details = GuiUtil.getMessage("msg.AppName") + ": " + cd.get("appname") + "<br/>";
                                    }
                                    if (cd.containsKey("jrubyversion")) {
                                        details = details + GuiUtil.getMessage("msg.JrubyVersion") + ": " + cd.get("jrubyversion") + "<br/>";
                                    }
                                    if (cd.containsKey("rubyframework")) {
                                        details = details + GuiUtil.getMessage("msg.Framework") + ": " + cd.get("rubyframework") + "<br/>";
                                    }
                                    if (cd.containsKey("environment")) {
                                        details = details + GuiUtil.getMessage("msg.Environment") + ": " + cd.get("environment") + "<br/>";
                                    }
                                    if (cd.containsKey("address")) {
                                        details = details + GuiUtil.getMessage("msg.Address") + ": " + cd.get("address") + "<br/>";
                                    }
                                    if (cd.containsKey("deploymentType")) {
                                        details = details + GuiUtil.getMessage("msg.DepType") + ": " + cd.get("deploymentType") + "<br/>";
                                    }
                                    if (cd.containsKey("endpointName")) {
                                        details = details + GuiUtil.getMessage("msg.EndPointName") + ": " + cd.get("endpointName") + "<br/>";
                                    }
                                    if (cd.containsKey("classname")) {
                                        details = GuiUtil.getMessage("msg.ClassName") + ": " + cd.get("classname") + "<br/>";
                                    }
                                    if (cd.containsKey("implType")) {
                                        details = details + GuiUtil.getMessage("msg.ImplClass") + ": " + cd.get("implClass") + "<br/>";
                                    }
                                    if (cd.containsKey("implClass") && cd.containsKey("implType")) {
                                        details = details + GuiUtil.getMessage("msg.ImplType") + ": " + cd.get("implType") + "<br/>";
                                    }
                                    if (cd.containsKey("namespace")) {
                                        details = details + GuiUtil.getMessage("msg.NameSpace") + ": " + cd.get("namespace") + "<br/>";
                                    }
                                    if (cd.containsKey("portName")) {
                                        details = details + GuiUtil.getMessage("msg.PortName") + ": " + cd.get("portName") + "<br/>";
                                    }
                                    if (cd.containsKey("serviceName")) {
                                        details = details + GuiUtil.getMessage("msg.ServiceName") + ": " + cd.get("serviceName") + "<br/>";
                                    }
                                    if (cd.containsKey("tester")) {
                                        details = details + GuiUtil.getMessage("msg.Tester") + ": " + cd.get("tester") + "<br/>";
                                    }
                                    if (cd.containsKey("wsdl")) {
                                        details = details + GuiUtil.getMessage("msg.WSDL") + ": " + cd.get("wsdl") + "<br/>";
                                    }
                                    statsMap.put("Name", statname == null ? monName : statname);
                                    statsMap.put("StartTime", start);
                                    statsMap.put("LastTime", last);
                                    statsMap.put("Description", desc);
                                    statsMap.put("Value", val == null ? "" : val);
                                    statsMap.put("Details", details);
                                    result.add(statsMap);
                                }
                            }
                        } else {
                            mname = cds.containsKey("name") ? (String)cds.get("name") : monName;
                            if (cds.containsKey("unit")) {
                                unit = (String)cds.get("unit");
                            }
                            if (cds.containsKey("description")) {
                                desc = (String)cds.get("description");
                            }
                            if (cds.containsKey("startTime")) {
                                start = (Long)cds.get("startTime") == -1L ? cds.get("startTime") : df.format(new Date((Long)cds.get("lastSampleTime")));
                            }
                            if (cds.containsKey("lastSampleTime")) {
                                last = (Long)cds.get("lastSampleTime") == -1L ? cds.get("lastSampleTime") : df.format(new Date((Long)cds.get("lastSampleTime")));
                            }
                            if (cds.containsKey("maxTime")) {
                                details = GuiUtil.getMessage("msg.MaxTime") + ": " + cds.get("maxTime") + " " + unit + "<br/>";
                            }
                            if (cds.containsKey("minTime")) {
                                details = details + GuiUtil.getMessage("msg.MinTime") + ": " + cds.get("minTime") + " " + unit + "<br/>";
                            }
                            if (cds.containsKey("totalTime")) {
                                details = details + GuiUtil.getMessage("msg.TotalTime") + ": " + cds.get("totalTime") + " " + unit + "<br/>";
                            }
                            if (cds.containsKey("highWaterMark")) {
                                details = GuiUtil.getMessage("msg.HWaterMark") + ": " + cds.get("highWaterMark") + " " + unit + "<br/>";
                            }
                            if (cds.containsKey("lowWaterMark")) {
                                details = details + GuiUtil.getMessage("msg.LWaterMark") + ": " + cds.get("lowWaterMark") + " " + unit + "<br/>";
                            }
                            if (cds.containsKey("activeRuntimes")) {
                                runtimes = (Integer)cds.get("activeRuntimes");
                            }
                            if (cds.containsKey("queueSize")) {
                                queuesize = cds.get("queueSize");
                            }
                            if (cds.containsKey("hardMaximum") && cds.get("hardMaximum") != null) {
                                val = cds.get("hardMaximum") + " " + "hard max " + "<br/>" + cds.get("hardMinimum") + " " + "hard min";
                            }
                            if (cds.containsKey("newThreshold") && cds.get("newThreshold") != null) {
                                thresholds = cds.get("newThreshold") + " " + "new " + "<br/>" + cds.get("queueDownThreshold") + " " + "queue down";
                            }
                            if (cds.containsKey("count")) {
                                val = cds.get("count") + " " + unit;
                            } else if (cds.containsKey("current")) {
                                if (name.equals("transaction-service")) {
                                    String str = (String)cds.get("current");
                                    String formatStr = MonitoringHandlers.formatActiveIdsForDisplay(str);
                                    if (!formatStr.isEmpty() && !formatStr.equals("")) {
                                        val = formatStr;
                                    }
                                } else {
                                    val = cds.get("current");
                                }
                            } else {
                                val = "--";
                            }
                        }
                    } else if (val instanceof String[]) {
                        mname = monName;
                        String values = "";
                        for (String s : (String[])val) {
                            values = values + (String)s + "<br/>";
                        }
                        val = values;
                    } else if (val instanceof CompositeData[]) {
                        String apptype = "";
                        for (CompositeData cd : (CompositeData[])val) {
                            if (cd.containsKey("appName")) {
                                mname = (String)cd.get("appName");
                            }
                            if (cd.containsKey("applicationType")) {
                                apptype = (String)cd.get("applicationType");
                            }
                            if (!cd.containsKey("queueSize") || !cd.containsKey("jrubyVersion")) continue;
                            details = details + cd.get("environment") + " " + cd.get("jrubyVersion");
                        }
                        val = apptype;
                    }
                    if (!nostatskey) continue;
                    statMap.put("name", mname != null ? mname : monName);
                    statMap.put("thresholds", thresholds == null ? "--" : thresholds);
                    statMap.put("queueSize", queuesize == null ? "--" : queuesize);
                    statMap.put("runtimes", runtimes == null ? "--" : runtimes);
                    statMap.put("current", current);
                    statMap.put("startTime", start);
                    statMap.put("lastTime", last);
                    statMap.put("description", desc);
                    statMap.put("value", val == null ? "" : val);
                    statMap.put("details", details == null ? "--" : details);
                    result.add(statMap);
                }
            }
            handlerCtx.setOutputValue("result", result);
            handlerCtx.setOutputValue("hasStats", (Object)(!amxproxy.isEmpty() ? 1 : 0));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void updateMonitorLevels(HandlerContext handlerCtx) {
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String containerEndpoint = (String)handlerCtx.getInputValue("containerEndpoint");
        List allRows = (List)handlerCtx.getInputValue("allRows");
        String objectNameStr = null;
        for (Map oneRow : allRows) {
            String name = (String)oneRow.get("monCompName");
            String value = null;
            ListIterator ni = monDisplayList.listIterator();
            ListIterator vi = monNamesList.listIterator();
            while (ni.hasNext() && vi.hasNext()) {
                String dispName = (String)ni.next();
                String mvalue = (String)vi.next();
                if (!name.equals(dispName)) continue;
                value = mvalue;
                objectNameStr = endpoint;
            }
            if (value == null) {
                ListIterator ci = containerDispList.listIterator();
                ListIterator cni = containerNameList.listIterator();
                while (ci.hasNext() && cni.hasNext()) {
                    String cDispName = (String)ci.next();
                    String cName = (String)cni.next();
                    if (!name.equals(cDispName)) continue;
                    value = "Level";
                    objectNameStr = containerEndpoint + "/" + cName;
                }
            }
            HashMap<String, Object> attrMap = new HashMap<String, Object>();
            attrMap.put(value == null ? name : value, oneRow.get("level"));
            String entityUrl = objectNameStr == null ? containerEndpoint + "/" + name : objectNameStr;
            RestResponse response = RestApiHandlers.sendUpdateRequest(entityUrl, attrMap, null, null, null);
            if (response.isSuccess()) continue;
            GuiUtil.getLogger().severe("Update monitor level failed.  parent=" + endpoint + "; attrsMap =" + attrMap);
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
            return;
        }
    }

    public static void addToMonitorList(HandlerContext handlerCtx) {
        List oldList = (List)handlerCtx.getInputValue("oldList");
        ArrayList<String> newList = (ArrayList<String>)handlerCtx.getInputValue("newList");
        if (newList == null) {
            newList = new ArrayList<String>();
        }
        if (oldList != null) {
            for (String sk : oldList) {
                newList.add(sk);
            }
        }
        handlerCtx.setOutputValue("result", newList);
    }

    public static void getValidMonitorLevels(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("monitorLevelList", levels);
    }

    public static void getFirstValueFromList(HandlerContext handlerCtx) {
        List values = (List)handlerCtx.getInputValue("values");
        String firstval = "";
        if (values != null && values.size() != 0) {
            firstval = (String)values.get(0);
        }
        handlerCtx.setOutputValue("firstValue", (Object)firstval);
    }

    public static void getAppName(HandlerContext handlerCtx) {
        String name;
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String appName = name = (String)handlerCtx.getInputValue("name");
        String fullName = name;
        try {
            ArrayList<String> applications = new ArrayList<String>(RestApiHandlers.getChildMap(endpoint).keySet());
            for (String oneApp : applications) {
                ArrayList<String> modules = new ArrayList<String>(RestApiHandlers.getChildMap(endpoint + "/" + oneApp + "/module").keySet());
                if (!modules.contains(name)) continue;
                appName = oneApp;
                break;
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        if (fullName != null && !name.equals(appName)) {
            fullName = appName + "/" + name;
        }
        handlerCtx.setOutputValue("appName", (Object)appName);
        handlerCtx.setOutputValue("appFullName", (Object)fullName);
    }

    public static void getNameforMbean(HandlerContext handlerCtx) {
        String app = (String)handlerCtx.getInputValue("appName");
        String comp = (String)handlerCtx.getInputValue("compVal");
        String end = (String)handlerCtx.getInputValue("end");
        String mbeanName = "EMPTY";
        try {
            Query query = V3AMX.getInstance().getDomainRoot().getQueryMgr();
            Set data = query.queryType("server-mon");
            Iterator iter = data.iterator();
            block2: while (iter.hasNext()) {
                Map attrs = ((AMXProxy)iter.next()).attributesMap();
                ObjectName[] pnames = (ObjectName[])attrs.get("Children");
                for (int i = 0; i < pnames.length; ++i) {
                    String pname = pnames[i].getKeyProperty("name");
                    if (pname == null) continue;
                    if (end.equals("true")) {
                        if (!pname.endsWith(app + "/" + comp)) continue;
                        mbeanName = pname;
                        continue block2;
                    }
                    if (!pname.startsWith(app + "/" + comp)) continue;
                    mbeanName = pname;
                    continue block2;
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("mbeanName", (Object)mbeanName);
    }

    public static void getNameforMbeanByType(HandlerContext handlerCtx) {
        String app = (String)handlerCtx.getInputValue("appName");
        String comp = (String)handlerCtx.getInputValue("compVal");
        String end = (String)handlerCtx.getInputValue("end");
        String type = (String)handlerCtx.getInputValue("type");
        String mbeanName = "EMPTY";
        List proxyList = V3AMX.getProxyListByType(type);
        if (proxyList.size() != 0) {
            ListIterator li = proxyList.listIterator();
            while (li.hasNext()) {
                String pname = (String)li.next();
                if (end.equals("true")) {
                    if (!pname.endsWith(app + "/" + comp)) continue;
                    mbeanName = pname;
                    break;
                }
                if (!pname.startsWith(app + "/" + comp)) continue;
                mbeanName = pname;
                break;
            }
        }
        handlerCtx.setOutputValue("mbeanName", (Object)mbeanName);
    }

    public static void getWebStatsUrl(HandlerContext handlerCtx) {
        String app = (String)handlerCtx.getInputValue("app");
        String monitorURL = (String)handlerCtx.getInputValue("monitorURL");
        List vsList = (List)handlerCtx.getInputValue("vsList");
        String compVal = (String)handlerCtx.getInputValue("compVal");
        Map moduleProps = (Map)handlerCtx.getInputValue("moduleProps");
        String webStatUrl = "EMPTY";
        String statType = "EMPTY";
        String monitorEndpoint = monitorURL + "/applications/" + app;
        if (compVal == null || compVal.equals("")) {
            for (String vs : vsList) {
                if (!MonitoringHandlers.doesProxyExist(monitorEndpoint = monitorEndpoint + "/" + vs).booleanValue()) continue;
                webStatUrl = monitorEndpoint;
                statType = "Web";
                break;
            }
        } else {
            String[] compStrs = compVal.split("/");
            if (vsList.contains(compStrs[0]) && moduleProps.containsKey(compStrs[1]) && ((String)moduleProps.get(compStrs[1])).equals("Servlet") && MonitoringHandlers.doesProxyExist(monitorEndpoint = monitorEndpoint + "/" + compVal).booleanValue()) {
                webStatUrl = monitorEndpoint;
                statType = "ServletInstance";
            }
        }
        handlerCtx.setOutputValue("webStatUrl", (Object)webStatUrl);
        handlerCtx.setOutputValue("webStatType", (Object)statType);
    }

    public static void getStatsUrl(HandlerContext handlerCtx) {
        String app = (String)handlerCtx.getInputValue("app");
        String comp = (String)handlerCtx.getInputValue("compVal");
        String monitorURL = (String)handlerCtx.getInputValue("monitorURL");
        Map moduleProps = (Map)handlerCtx.getInputValue("moduleProps");
        String statUrl = "EMPTY";
        String statType = "";
        statUrl = monitorURL + "/applications/" + app + "/" + comp;
        if (comp != null && MonitoringHandlers.doesProxyExist(statUrl).booleanValue()) {
            String[] compStrs = comp.split("/");
            statType = compStrs.length == 1 ? (String)moduleProps.get(compStrs[0]) : MonitoringHandlers.modifyStatType(compStrs[1]);
        }
        handlerCtx.setOutputValue("statUrl", (Object)statUrl);
        handlerCtx.setOutputValue("statType", (Object)statType);
    }

    public static void filterWebStats(HandlerContext handlerCtx) {
        List webStats = (List)handlerCtx.getInputValue("webStats");
        String statType = (String)handlerCtx.getInputValue("statType");
        List<String> requestStatNames = Arrays.asList("MaxTime", "ProcessingTime", "RequestCount", "ErrorCount");
        ArrayList<Map> stats = new ArrayList<Map>();
        if (webStats != null) {
            for (Map webStat : webStats) {
                String statName = (String)webStat.get("Name");
                if (requestStatNames.contains(statName) && statType.equals("Request")) {
                    stats.add(webStat);
                    continue;
                }
                if (!statName.contains(statType) || statType.equals("Request")) continue;
                stats.add(webStat);
            }
        }
        handlerCtx.setOutputValue("stats", stats);
    }

    public static void isPool(HandlerContext handlerCtx) {
        String poolName = (String)handlerCtx.getInputValue("poolName");
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        Boolean result = false;
        try {
            ArrayList<String> poolNames = new ArrayList<String>(RestApiHandlers.getChildMap(endpoint).keySet());
            if (poolNames.contains(poolName)) {
                result = true;
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("result", (Object)result);
    }

    public static void getMonitoringPools(HandlerContext handlerCtx) {
        List poolNames = (List)handlerCtx.getInputValue("poolNames");
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        ArrayList<String> jdbcMonitorList = new ArrayList<String>();
        ArrayList<String> connectorMonitorList = new ArrayList<String>();
        Object fisrtJdbc = null;
        Object firstConnector = null;
        try {
            ArrayList<String> jdbcPools = new ArrayList<String>(RestApiHandlers.getChildMap(endpoint + "/jdbc-connection-pool").keySet());
            ArrayList<String> connectorPools = new ArrayList<String>(RestApiHandlers.getChildMap(endpoint + "/connector-connection-pool").keySet());
            for (String poolName : poolNames) {
                if (jdbcPools.contains(poolName)) {
                    jdbcMonitorList.add(poolName);
                    continue;
                }
                if (!connectorPools.contains(poolName)) continue;
                connectorMonitorList.add(poolName);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("jdbcList", jdbcMonitorList);
        handlerCtx.setOutputValue("firstJdbc", fisrtJdbc);
        handlerCtx.setOutputValue("connectorList", connectorMonitorList);
        handlerCtx.setOutputValue("firstConnector", firstConnector);
    }

    public static void getInstanceMonitorURL(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        String monitorURL = null;
        String serverRestURL = (String)GuiUtil.getSessionValue("REST_URL");
        String port = null;
        if (instanceName.equals("server")) {
            monitorURL = (String)GuiUtil.getSessionValue("MONITOR_URL") + "/server";
        } else {
            if (MonitoringHandlers.doesProxyExist(serverRestURL + "/servers/server/" + instanceName + "/system-property/ASADMIN_LISTENER_PORT").booleanValue()) {
                port = (String)RestApiHandlers.getAttributesMap(serverRestURL + "/servers/server/" + instanceName + "/system-property/ASADMIN_LISTENER_PORT").get("value");
            } else {
                String configName = (String)RestApiHandlers.getAttributesMap(serverRestURL + "/servers/server/" + instanceName).get("configRef");
                port = (String)RestApiHandlers.getAttributesMap(serverRestURL + "/configs/config/" + configName + "/network-config/network-listeners/network-listener/admin-listener").get("port");
                if ((port = port.trim()).startsWith("${")) {
                    port = port.substring(2, port.length() - 1);
                    port = (String)RestApiHandlers.getAttributesMap(serverRestURL + "/configs/config/" + configName + "/system-property/ASADMIN_LISTENER_PORT").get("value");
                }
            }
            String node = (String)RestApiHandlers.getAttributesMap(serverRestURL + "/servers/server/" + instanceName).get("node");
            String nodeHost = (String)RestApiHandlers.getAttributesMap(serverRestURL + "/nodes/node/" + node).get("nodeHost");
            monitorURL = serverRestURL.startsWith("https:") ? "https://" + nodeHost + ":" + port + "/monitoring/domain/" + instanceName + "/server" : "http://" + nodeHost + ":" + port + "/monitoring/domain/" + instanceName + "/server";
        }
        handlerCtx.setOutputValue("monitorURL", (Object)monitorURL);
    }

    public static Boolean doesAppProxyExist(String appName, String moduleName) {
        boolean proxyexist = false;
        Map<String, Object> subComps = MonitoringHandlers.getSubComponents(appName, moduleName);
        if (subComps != null && subComps.size() > 0) {
            proxyexist = true;
        }
        return proxyexist;
    }

    public static Map<String, Object> getSubComponents(String appName, String moduleName) {
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/applications/application/list-sub-components";
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("appname", appName);
        attrs.put("modulename", moduleName);
        try {
            Map<String, Object> responseMap = RestApiHandlers.restRequest(endpoint, attrs, "GET", null);
            Map propsMap = (Map)((Map)responseMap.get("data")).get("properties");
            if (propsMap != null && propsMap.size() > 0) {
                return propsMap;
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in doesAppProxyExist ; \nendpoint = " + endpoint + "attrs=" + attrs + "method=GET");
        }
        return null;
    }

    public static Boolean doesProxyExist(String endpoint) {
        if (RestApiHandlers.get(endpoint).isSuccess()) {
            return true;
        }
        return false;
    }

    public static String modifyStatType(String name) {
        String[] nameStrs = name.split("-");
        String modifiedName = "";
        for (int i = 0; i < nameStrs.length; ++i) {
            String tmp = nameStrs[i].substring(0, 1).toUpperCase() + nameStrs[i].substring(1);
            modifiedName = modifiedName + tmp;
        }
        return modifiedName;
    }

    public static List servletInstanceValues(String name, String type, String instance) {
        List proxyList = V3AMX.getProxyListByType(type);
        ArrayList<String> servlets = new ArrayList<String>();
        if (proxyList.size() != 0) {
            ListIterator li = proxyList.listIterator();
            while (li.hasNext()) {
                String pname = (String)li.next();
                if (!pname.contains(name)) continue;
                String vs = "";
                vs = pname.contains(".war") ? pname.substring(pname.lastIndexOf(".war") + 5, pname.lastIndexOf("/")) : pname.substring(pname.indexOf("/") + 1, pname.lastIndexOf("/"));
                if (!instance.equals(vs)) continue;
                servlets.add(pname.substring(pname.lastIndexOf("/") + 1, pname.length()));
            }
        }
        return servlets;
    }

    public static List getAllEjbComps(String appname, String type, String state) {
        ArrayList menuList = new ArrayList();
        List bstate = MonitoringHandlers.getEjbComps(appname, type, "");
        if (!bstate.isEmpty()) {
            ListIterator bi = bstate.listIterator();
            while (bi.hasNext() && bi.hasNext()) {
                ArrayList<String> ejblist = new ArrayList<String>();
                String name = (String)bi.next();
                ejblist.add(name);
                List bcache = MonitoringHandlers.getEjbComps(appname, "bean-cache-mon", name);
                List bpool = MonitoringHandlers.getEjbComps(appname, "bean-pool-mon", name);
                List timers = MonitoringHandlers.getEjbComps(appname, "ejb-timed-object-mon", name);
                if (!bcache.isEmpty()) {
                    ejblist.addAll(bcache);
                }
                if (!bpool.isEmpty() && bpool.size() > 0) {
                    ejblist.addAll(bpool);
                }
                if (!timers.isEmpty()) {
                    ejblist.addAll(timers);
                }
                if (ejblist.isEmpty()) continue;
                menuList.add(ejblist);
            }
        }
        return menuList;
    }

    public static List getEjbComps(String name, String type, String ejbstate) {
        List proxyList = V3AMX.getProxyListByType(type);
        ArrayList<String> comps = new ArrayList<String>();
        if (proxyList.size() != 0) {
            ListIterator li = proxyList.listIterator();
            while (li.hasNext()) {
                String pname = (String)li.next();
                if (!ejbstate.isEmpty() || !ejbstate.equals("")) {
                    if (!pname.startsWith(name) && !pname.contains("/" + name + "/") || !pname.contains(ejbstate)) continue;
                    comps.add(pname.substring(pname.lastIndexOf("/") + 1, pname.length()));
                    continue;
                }
                if (!pname.startsWith(name) && !pname.contains("/" + name + "/")) continue;
                comps.add(pname.substring(pname.lastIndexOf("/") + 1, pname.length()));
            }
        }
        return comps;
    }

    private static String formatActiveIdsForDisplay(String str) {
        String values = " ";
        String[] strArray = str.split("%%%EOL%%%");
        if (strArray != null && strArray.length > 0) {
            values = values + "<table>";
            for (String s : strArray) {
                if (s.startsWith("Transaction")) {
                    String sh = s.replaceFirst(" ", "_");
                    String[] strHeaders = sh.split(" ");
                    if (strHeaders == null || strHeaders.length <= 0) continue;
                    values = values + "<tr>";
                    for (String h : strHeaders) {
                        if (h.isEmpty()) continue;
                        values = values + "<td>" + h + "</td>";
                    }
                    values = values + "</tr>";
                    continue;
                }
                String[] strData = s.split(" ");
                if (strData == null || strData.length <= 0) continue;
                values = values + "<tr>";
                for (String d : strData) {
                    if (d.isEmpty()) continue;
                    values = values + "<td>" + d + "</td>";
                }
                values = values + "</tr>";
            }
            values = values + "</table>";
        }
        return values;
    }

    private static Map<String, Object> getMonitoringStatInfo(String endpoint) {
        Map<String, Object> monitorInfoMap = new HashMap<String, Object>();
        try {
            Map extraPropsMap;
            Map<String, Object> responseMap = RestApiHandlers.restRequest(endpoint, null, "GET", null);
            Map dataMap = (Map)responseMap.get("data");
            if (dataMap != null && (extraPropsMap = (Map)dataMap.get("extraProperties")) != null) {
                monitorInfoMap = (Map)extraPropsMap.get("entity");
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getMonitoringStatInfo ; \nendpoint = " + endpoint + "attrs=" + "method=GET");
        }
        return monitorInfoMap;
    }

    static {
        levels.add("OFF");
        levels.add("LOW");
        levels.add("HIGH");
        monDisplayList = new ArrayList();
        monDisplayList.add(JVM);
        monDisplayList.add(WEB_CONTAINER);
        monDisplayList.add(HTTP_SERVICE);
        monDisplayList.add(THREAD_POOL);
        monDisplayList.add(JDBC_CONNECTION_POOL);
        monDisplayList.add(CONNECTOR_CONNECTION_POOL);
        monDisplayList.add(EJB_CONTAINER);
        monDisplayList.add(TRANSACTION_SERVICE);
        monDisplayList.add(ORB);
        monDisplayList.add(CONNECTOR_SERVICE);
        monDisplayList.add(JMS_SERVICE);
        monDisplayList.add(WEB_SERVICES_CONTAINER);
        monDisplayList.add(JPA);
        monDisplayList.add(SECURITY);
        monDisplayList.add(JERSEY);
        monNamesList = new ArrayList();
        monNamesList.add("jvm");
        monNamesList.add("webContainer");
        monNamesList.add("httpService");
        monNamesList.add("threadPool");
        monNamesList.add("jdbcConnectionPool");
        monNamesList.add("connectorConnectionPool");
        monNamesList.add("ejbContainer");
        monNamesList.add("transactionService");
        monNamesList.add("orb");
        monNamesList.add("connectorService");
        monNamesList.add("jmsService");
        monNamesList.add("webServicesContainer");
        monNamesList.add("jpa");
        monNamesList.add("security");
        monNamesList.add("jersey");
        containerDispList = new ArrayList();
        containerDispList.add(JRUBY);
        containerNameList = new ArrayList();
        containerNameList.add("jruby-container");
    }
}

