/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.handlers.RestUtilHandlers;
import org.glassfish.admingui.common.util.GuiUtil;

public class TargetUtil {
    public static boolean isCluster(String name) {
        if (GuiUtil.isEmpty(name)) {
            return false;
        }
        return TargetUtil.getClusters().contains(name);
    }

    public static List getStandaloneInstances() {
        List<Object> result = new ArrayList();
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/list-instances";
        HashMap<String, Object> attrsMap = new HashMap<String, Object>();
        attrsMap.put("standaloneonly", "true");
        try {
            Map<String, Object> responseMap = RestApiHandlers.restRequest(endpoint, attrsMap, "get", null);
            Map dataMap = (Map)responseMap.get("data");
            Map extraProps = (Map)dataMap.get("extraProperties");
            if (extraProps == null) {
                return result;
            }
            List props = (List)extraProps.get("instanceList");
            if (props == null) {
                return result;
            }
            result = RestUtilHandlers.getListFromMapKey(props, new String[0]);
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getStandaloneInstances ; \nendpoint = " + endpoint + ", attrsMap=" + attrsMap);
        }
        return result;
    }

    public static List getClusters() {
        ArrayList<String> clusters = new ArrayList<String>();
        try {
            clusters.addAll(RestApiHandlers.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster").keySet());
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getClusters;");
            ex.printStackTrace();
        }
        return clusters;
    }

    public static String getTargetEndpoint(String target) {
        try {
            List clusters;
            String encodedName = URLEncoder.encode(target, "UTF-8");
            String endpoint = (String)GuiUtil.getSessionValue("REST_URL");
            endpoint = target.equals("server") ? endpoint + "/servers/server/server" : ((clusters = TargetUtil.getClusters()).contains(target) ? endpoint + "/clusters/cluster/" + encodedName : endpoint + "/servers/server/" + encodedName);
            return endpoint;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String getConfigName(String target) {
        String endpoint = TargetUtil.getTargetEndpoint(target);
        return (String)RestApiHandlers.getAttributesMap(endpoint).get("configRef");
    }
}

