/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.MiscUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestApiHandlers {
    public static final String FORM_ENCODING = "application/x-www-form-urlencoded";
    public static final String RESPONSE_TYPE = "application/xml";
    public static final String GUI_TOKEN_FOR_EMPTY_PROPERTY_VALUE = "()";
    public static final Client JERSEY_CLIENT = Client.create();
    private static final String REST_TOKEN_COOKIE = "gfresttoken";

    public static void getDefaultValues(HandlerContext handlerCtx) {
        try {
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            Map orig = (Map)handlerCtx.getInputValue("orig");
            Map<String, String> defaultValues = RestApiHandlers.buildDefaultValueMap(endpoint);
            if (orig == null) {
                handlerCtx.setOutputValue("valueMap", defaultValues);
            } else {
                for (String origKey : orig.keySet()) {
                    String defaultV = defaultValues.get(origKey);
                    if (defaultV == null) continue;
                    orig.put(origKey, defaultV);
                }
                handlerCtx.setOutputValue("valueMap", (Object)orig);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getEntityAttrs(HandlerContext handlerCtx) {
        String key = (String)handlerCtx.getInputValue("key");
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        Map currentMap = (Map)handlerCtx.getInputValue("currentMap");
        Map<String, Object> valueMap = null;
        try {
            valueMap = RestApiHandlers.getEntityAttrs(endpoint, key);
            if (currentMap != null) {
                valueMap.putAll(currentMap);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("valueMap", valueMap);
    }

    public static void checkIfEndPointExist(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("exists", (Object)RestApiHandlers.get((String)handlerCtx.getInputValue("endpoint")).isSuccess());
    }

    public static void createEntity(HandlerContext handlerCtx) {
        HashMap<String, Object> attrs = (HashMap<String, Object>)handlerCtx.getInputValue("attrs");
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        RestResponse response = RestApiHandlers.sendCreateRequest(endpoint, attrs, (List)handlerCtx.getInputValue("skipAttrs"), (List)handlerCtx.getInputValue("onlyUseAttrs"), (List)handlerCtx.getInputValue("convertToFalse"));
        Map<String, Object> resultMap = RestApiHandlers.parseResponse(response, handlerCtx, endpoint, attrs, false);
        handlerCtx.setOutputValue("result", (Object)endpoint);
    }

    public static void restRequest(HandlerContext handlerCtx) {
        Map attrs = (Map)handlerCtx.getInputValue("attrs");
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String method = (String)handlerCtx.getInputValue("method");
        boolean quiet = (Boolean)handlerCtx.getInputValue("quiet");
        handlerCtx.setOutputValue("result", RestApiHandlers.restRequest(endpoint, attrs, method, handlerCtx, quiet));
    }

    public static Map<String, Object> restRequest(String endpoint, Map<String, Object> attrs, String method, HandlerContext handlerCtx, boolean quiet) {
        boolean useData = false;
        Object data = null;
        if (attrs == null) {
            try {
                data = handlerCtx == null ? null : handlerCtx.getInputValue("data");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (data != null) {
                useData = true;
            } else {
                attrs = new HashMap<String, Object>();
            }
        }
        method = method.toLowerCase();
        Logger logger = GuiUtil.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "restRequest: endpoint={0}\nattrs={1}\nmethod={2}", new Object[]{endpoint, attrs, method});
        }
        RestResponse response = null;
        if ("post".equals(method)) {
            response = useData ? RestApiHandlers.post(endpoint, data, (String)handlerCtx.getInputValue("contentType")) : RestApiHandlers.post(endpoint, attrs);
        } else if ("get".equals(method)) {
            response = RestApiHandlers.get(endpoint, attrs);
        } else if ("delete".equals(method)) {
            response = RestApiHandlers.delete(endpoint, attrs);
        }
        return RestApiHandlers.parseResponse(response, handlerCtx, endpoint, attrs, quiet);
    }

    private static Map<String, Object> parseResponse(RestResponse response, HandlerContext handlerCtx, String endpoint, Map attrs, boolean quiet) {
        String message = "";
        if (response != null) {
            try {
                int status = response.getResponseCode();
                Map<String, Object> responseMap = response.getResponse();
                if (status != 200 && status != 201) {
                    if (!quiet) {
                        GuiUtil.getLogger().log(Level.SEVERE, "RestResponse.getResponse() failed.  endpoint = ''{0}''; attrs = ''{1}''; RestResponse: {2}", new Object[]{endpoint, attrs, response.getResponseBody()});
                    }
                    if ((message = (String)((Map)responseMap.get("data")).get("message")) == null) {
                        Object msgs = responseMap.get("message");
                        if (msgs == null) {
                            message = "REST Request '" + endpoint + "' failed with response code '" + status + "'.";
                        } else if (msgs instanceof List) {
                            StringBuilder builder = new StringBuilder("");
                            for (Object obj : (List)msgs) {
                                if (obj instanceof Map && ((Map)obj).containsKey("message")) {
                                    obj = ((Map)obj).get("message");
                                }
                                builder.append(obj.toString());
                            }
                            message = builder.toString();
                        } else if (msgs instanceof Map) {
                            message = ((Map)msgs).get("message").toString();
                        } else {
                            message = "Unexpected message type.";
                            throw new RuntimeException(message);
                        }
                    }
                    if (handlerCtx != null) {
                        GuiUtil.handleError(handlerCtx, message);
                    } else {
                        throw new RuntimeException(message);
                    }
                }
                return responseMap;
            }
            catch (Exception ex) {
                if (!quiet) {
                    GuiUtil.getLogger().log(Level.SEVERE, "RestResponse.getResponse() failed.  endpoint = ''{0}''; attrs = ''{1}''; RestResponse: {2}", new Object[]{endpoint, attrs, response.getResponseBody()});
                }
                if (handlerCtx != null) {
                    if (message == null) {
                        GuiUtil.handleException(handlerCtx, ex);
                    } else {
                        GuiUtil.handleError(handlerCtx, message);
                    }
                }
                if (message == null) {
                    throw new RuntimeException(ex);
                }
                throw new RuntimeException(message, ex);
            }
        }
        return null;
    }

    public static void updateEntity(HandlerContext handlerCtx) {
        String endpoint;
        RestResponse response;
        HashMap<String, Object> attrs = (HashMap<String, Object>)handlerCtx.getInputValue("attrs");
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        if (!(response = RestApiHandlers.sendUpdateRequest(endpoint = (String)handlerCtx.getInputValue("endpoint"), attrs, (List)handlerCtx.getInputValue("skipAttrs"), (List)handlerCtx.getInputValue("onlyUseAttrs"), (List)handlerCtx.getInputValue("convertToFalse"))).isSuccess()) {
            GuiUtil.getLogger().severe("CreateProxy failed.  parent=" + endpoint + "; attrs =" + attrs);
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
            return;
        }
        handlerCtx.setOutputValue("result", (Object)endpoint);
    }

    public static void deleteCascade(HandlerContext handlerCtx) {
        try {
            HashMap<String, Object> payload = new HashMap<String, Object>();
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            String id = (String)handlerCtx.getInputValue("id");
            String cascade = (String)handlerCtx.getInputValue("cascade");
            if (cascade != null) {
                payload.put("cascade", cascade);
            }
            for (Map oneRow : (List)handlerCtx.getInputValue("selectedRows")) {
                RestResponse response = RestApiHandlers.delete(endpoint + "/" + URLEncoder.encode((String)oneRow.get(id), "UTF-8"), payload);
                if (response.isSuccess()) continue;
                GuiUtil.handleError(handlerCtx, "Unable to delete the resource " + (String)oneRow.get(id));
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void deleteConfigCascade(HandlerContext handlerCtx) {
        try {
            HashMap<String, Object> payload = new HashMap<String, Object>();
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            String id = (String)handlerCtx.getInputValue("id");
            String target = (String)handlerCtx.getInputValue("target");
            String cascade = (String)handlerCtx.getInputValue("cascade");
            if (cascade != null) {
                payload.put("cascade", cascade);
            }
            for (Map oneRow : (List)handlerCtx.getInputValue("selectedRows")) {
                RestResponse response = RestApiHandlers.delete(endpoint + "/" + URLEncoder.encode((String)oneRow.get(id), "UTF-8") + "?target=" + target, payload);
                if (response.isSuccess()) continue;
                GuiUtil.handleError(handlerCtx, "Unable to delete the resource " + (String)oneRow.get(id));
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getChildList(HandlerContext handlerCtx) {
        try {
            handlerCtx.setOutputValue("result", RestApiHandlers.buildChildEntityList((String)handlerCtx.getInputValue("parentEndpoint"), (String)handlerCtx.getInputValue("childType"), (List)handlerCtx.getInputValue("skipList"), (List)handlerCtx.getInputValue("includeList"), (String)handlerCtx.getInputValue("id")));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getChildrenNamesList(HandlerContext handlerCtx) {
        try {
            handlerCtx.setOutputValue("result", new ArrayList<String>(RestApiHandlers.getChildMap((String)handlerCtx.getInputValue("endpoint")).keySet()));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static Map getAttributesMap(String endpoint) {
        RestResponse response = RestApiHandlers.get(endpoint);
        if (!response.isSuccess()) {
            return new HashMap();
        }
        return RestApiHandlers.getEntityAttrs(endpoint, "entity");
    }

    protected static Map<String, String> buildDefaultValueMap(String endpoint) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        RestResponse response = RestApiHandlers.options(endpoint, RESPONSE_TYPE);
        Map data = (Map)response.getResponse().get("data");
        Map extraProperties = (Map)data.get("extraProperties");
        List methods = (List)extraProperties.get("methods");
        for (Map method : methods) {
            Map messageParameters;
            if (!"POST".equals(method.get("name")) || (messageParameters = (Map)method.get("messageParameters")) == null) continue;
            for (Map.Entry entry : messageParameters.entrySet()) {
                String param = (String)entry.getKey();
                String defaultValue = (String)((Map)entry.getValue()).get("defaultValue");
                if ("".equals(defaultValue) || defaultValue == null) continue;
                defaultValues.put(param, defaultValue);
            }
        }
        return defaultValues;
    }

    protected static MultivaluedMap buildMultivalueMap(Map<String, Object> payload) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        for (Map.Entry<String, Object> entry : payload.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            if (value instanceof Collection) {
                for (Object obj : (Collection)value) {
                    try {
                        formData.add((Object)key, obj);
                    }
                    catch (ClassCastException ex) {
                        GuiUtil.getLogger().info("Unable to add key (" + key + ") w/ value (" + obj + ").");
                    }
                }
                continue;
            }
            try {
                formData.putSingle((Object)key, value);
            }
            catch (ClassCastException ex) {
                GuiUtil.getLogger().info("Unable to add key (" + key + ") w/ value (" + value + ").");
            }
        }
        return formData;
    }

    public static RestResponse sendCreateRequest(String endpoint, Map<String, Object> attrs, List<String> skipAttrs, List<String> onlyUseAttrs, List<String> convertToFalse) {
        RestApiHandlers.removeSpecifiedAttrs(attrs, skipAttrs);
        attrs = RestApiHandlers.buildUseOnlyAttrMap(attrs, onlyUseAttrs);
        attrs = RestApiHandlers.convertNullValuesToFalse(attrs, convertToFalse);
        attrs = RestApiHandlers.fixKeyNames(attrs);
        return RestApiHandlers.post(endpoint, attrs);
    }

    public static RestResponse sendUpdateRequest(String endpoint, Map<String, Object> attrs, List<String> skipAttrs, List<String> onlyUseAttrs, List<String> convertToFalse) {
        RestApiHandlers.removeSpecifiedAttrs(attrs, skipAttrs);
        attrs = RestApiHandlers.buildUseOnlyAttrMap(attrs, onlyUseAttrs);
        attrs = RestApiHandlers.convertNullValuesToFalse(attrs, convertToFalse);
        attrs = RestApiHandlers.fixKeyNames(attrs);
        return RestApiHandlers.post(endpoint, attrs);
    }

    protected static Map<String, Object> fixKeyNames(Map<String, Object> map) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().substring(0, 1).toLowerCase() + entry.getKey().substring(1);
            Object value = entry.getValue();
            results.put(key, value);
        }
        return results;
    }

    protected static void removeSpecifiedAttrs(Map<String, Object> attrs, List<String> removeList) {
        if (removeList == null || removeList.size() <= 0) {
            return;
        }
        Set<Map.Entry<String, Object>> attrSet = attrs.entrySet();
        Iterator<Map.Entry<String, Object>> iter = attrSet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> oneEntry = iter.next();
            if (!removeList.contains(oneEntry.getKey())) continue;
            iter.remove();
        }
    }

    protected static Map buildUseOnlyAttrMap(Map<String, Object> attrs, List<String> onlyUseAttrs) {
        if (onlyUseAttrs != null) {
            HashMap<String, Object> newAttrs = new HashMap<String, Object>();
            for (String key : onlyUseAttrs) {
                if (!attrs.keySet().contains(key)) continue;
                newAttrs.put(key, attrs.get(key));
            }
            return newAttrs;
        }
        return attrs;
    }

    protected static Map<String, Object> convertNullValuesToFalse(Map<String, Object> attrs, List<String> convertToFalse) {
        if (convertToFalse != null) {
            HashMap<String, Object> newAttrs = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : attrs.entrySet()) {
                String key = entry.getKey();
                if (convertToFalse.contains(key) && (entry.getValue() == null || "null".equals(entry.getValue()))) {
                    newAttrs.put(key, "false");
                    continue;
                }
                newAttrs.put(key, entry.getValue());
            }
            return newAttrs;
        }
        return attrs;
    }

    public static Map<String, Object> getEntityAttrs(String endpoint, String key) {
        Map<String, Object> valueMap = new HashMap<String, Object>();
        try {
            Map<String, Object> result = RestApiHandlers.restRequest(endpoint, null, "get", null, false);
            int responseCode = (Integer)result.get("responseCode");
            if (responseCode < 200 || responseCode > 299) {
                throw new RuntimeException((String)result.get("responseBody"));
            }
            Map data = (Map)result.get("data");
            Map extraProperties = (Map)data.get("extraProperties");
            if (extraProperties.containsKey(key)) {
                valueMap = (Map)extraProperties.get(key);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return valueMap;
    }

    public static String upperCaseFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static List<String> getChildResourceList(String document) throws SAXException, IOException, ParserConfigurationException {
        ArrayList<String> children = new ArrayList<String>();
        Document doc = MiscUtil.getDocument(document);
        Element root = doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName("childResource");
        if (nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                children.add(child.getTextContent());
            }
        }
        return children;
    }

    public static List<Map> buildChildEntityList(String parent, String childType, List skipList, List includeList, String id) throws Exception {
        String endpoint = parent.endsWith("/") ? parent + childType : parent + "/" + childType;
        boolean hasSkip = skipList != null;
        boolean hasInclude = includeList != null;
        boolean convert = childType.equals("property");
        ArrayList<Map> childElements = new ArrayList<Map>();
        List<String> childUrls = RestApiHandlers.getChildList(endpoint);
        for (String childUrl : childUrls) {
            Map<String, Object> entity = RestApiHandlers.getEntityAttrs(childUrl, "entity");
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            if (hasSkip && skipList.contains(entity.get(id)) || hasInclude && !includeList.contains(entity.get(id))) continue;
            oneRow.put("selected", false);
            for (String attrName : entity.keySet()) {
                oneRow.put(attrName, RestApiHandlers.getA(entity, attrName, convert));
            }
            oneRow.put("encodedName", URLEncoder.encode(entity.get(id).toString(), "UTF-8"));
            oneRow.put("name", entity.get(id));
            childElements.add(oneRow);
        }
        return childElements;
    }

    private static String getA(Map<String, Object> attrs, String key, boolean convert) {
        Object val = attrs.get(key);
        if (val == null) {
            return "";
        }
        return convert && val.equals("") ? GUI_TOKEN_FOR_EMPTY_PROPERTY_VALUE : val.toString();
    }

    public static List<String> getChildList(String endpoint) throws Exception {
        ArrayList<String> childElements = new ArrayList<String>();
        Map<String, String> childResources = RestApiHandlers.getChildMap(endpoint);
        if (childResources != null) {
            childElements.addAll(childResources.values());
        }
        return childElements;
    }

    public static Map<String, String> getChildMap(String endpoint) throws Exception {
        Map extraProperties;
        Map<String, String> childElements = new TreeMap<String, String>();
        Map<String, Object> responseMap = RestApiHandlers.restRequest(endpoint, new HashMap<String, Object>(), "get", null, false);
        Map data = (Map)responseMap.get("data");
        if (data != null && (extraProperties = (Map)data.get("extraProperties")) != null && (childElements = (Map)extraProperties.get("childResources")) == null) {
            childElements = new TreeMap();
        }
        return childElements;
    }

    private static final String getRestToken() {
        String token = null;
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx != null) {
            token = (String)ctx.getExternalContext().getSessionMap().get("__rTkn__");
        }
        return token;
    }

    public static RestResponse get(String address) {
        return RestApiHandlers.get(address, new HashMap<String, Object>());
    }

    public static RestResponse get(String address, Map<String, Object> payload) {
        WebResource webResource = JERSEY_CLIENT.resource(address).queryParams(RestApiHandlers.buildMultivalueMap(payload));
        ClientResponse resp = (ClientResponse)((WebResource.Builder)webResource.cookie(new Cookie(REST_TOKEN_COOKIE, RestApiHandlers.getRestToken())).accept(new String[]{RESPONSE_TYPE})).get(ClientResponse.class);
        return RestResponse.getRestResponse(resp);
    }

    public static RestResponse post(String address, Object payload, String contentType) {
        WebResource webResource = JERSEY_CLIENT.resource(address);
        if (contentType == null) {
            contentType = "application/json";
        }
        if (payload instanceof Map) {
            payload = RestApiHandlers.buildMultivalueMap((Map)payload);
        }
        ClientResponse cr = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Content-Type", (Object)contentType).cookie(new Cookie(REST_TOKEN_COOKIE, RestApiHandlers.getRestToken()))).accept(new String[]{RESPONSE_TYPE})).post(ClientResponse.class, payload);
        RestResponse rr = RestResponse.getRestResponse(cr);
        return rr;
    }

    public static RestResponse post(String address, Map<String, Object> payload) {
        WebResource webResource = JERSEY_CLIENT.resource(address);
        MultivaluedMap formData = RestApiHandlers.buildMultivalueMap(payload);
        ClientResponse cr = (ClientResponse)((WebResource.Builder)webResource.cookie(new Cookie(REST_TOKEN_COOKIE, RestApiHandlers.getRestToken())).accept(new String[]{RESPONSE_TYPE})).post(ClientResponse.class, (Object)formData);
        RestResponse rr = RestResponse.getRestResponse(cr);
        return rr;
    }

    public static String put(String address) {
        throw new UnsupportedOperationException();
    }

    public static RestResponse delete(String address, Map<String, Object> payload) {
        WebResource webResource = JERSEY_CLIENT.resource(address);
        ClientResponse cr = (ClientResponse)((WebResource.Builder)webResource.queryParams(RestApiHandlers.buildMultivalueMap(payload)).cookie(new Cookie(REST_TOKEN_COOKIE, RestApiHandlers.getRestToken())).accept(new String[]{RESPONSE_TYPE})).delete(ClientResponse.class);
        RestApiHandlers.checkStatusForSuccess(cr);
        return RestResponse.getRestResponse(cr);
    }

    public static RestResponse options(String address, String responseType) {
        WebResource webResource = JERSEY_CLIENT.resource(address);
        ClientResponse cr = (ClientResponse)((WebResource.Builder)webResource.cookie(new Cookie(REST_TOKEN_COOKIE, RestApiHandlers.getRestToken())).accept(new String[]{responseType})).options(ClientResponse.class);
        RestApiHandlers.checkStatusForSuccess(cr);
        return RestResponse.getRestResponse(cr);
    }

    public static void checkStatusForSuccess(ClientResponse cr) {
        int status = cr.getStatus();
        if (status < 200 || status > 299) {
            throw new RuntimeException(cr.toString());
        }
    }
}

